/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.scriptlet;

import java.util.List;
import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.scriptlet.ScriptletInfoJson;
import kd.sdk.kingscript.scriptlet.ScriptletTreeJson;
import org.slf4j.Logger;

public abstract class ScriptletService {
    private static final Logger logger = Logs.getLogger();
    @ConfigurableItem(desc="scriptlet \u811a\u672c\u7247\u6bb5\u5b9e\u73b0\u7c7b")
    private static final String SCRIPTLET_SERVICE = "kingscript.scriptlet.service";

    public static ScriptletService create() {
        String scriptletService = System.getProperty(SCRIPTLET_SERVICE, "kd.bos.kingscript.scriptlet.ScriptletServiceImpl");
        if (scriptletService != null) {
            try {
                Class<?> cls = Class.forName(scriptletService);
                return (ScriptletService)cls.newInstance();
            }
            catch (Exception e) {
                logger.warn("Create scriptlet service failed: " + scriptletService + ", cause by" + e.getMessage(), (Throwable)e);
            }
        }
        throw new RuntimeException("error");
    }

    public abstract List<ScriptletTreeJson> getCodeEditorFragmentTree();

    public abstract List<ScriptletInfoJson> getCodeEditorFragment(String[] var1);
}

