/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.security;

import java.util.function.Predicate;
import java.util.function.Supplier;
import kd.sdk.kingscript.exception.ScriptSecurityException;
import kd.sdk.kingscript.security.SecurityController;

public class AllowHostClassLookup
implements Predicate<String> {
    private final Supplier<SecurityController> securityControllerSupplier;

    public AllowHostClassLookup(Supplier<SecurityController> securityControllerSupplier) {
        this.securityControllerSupplier = securityControllerSupplier;
    }

    @Override
    public boolean test(String className) {
        if (this.securityControllerSupplier != null && !this.securityControllerSupplier.get().allowHostClassLookup(className)) {
            throw new ScriptSecurityException("Not allow host class lookup: " + className);
        }
        return true;
    }
}

