/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.security;

import com.oracle.truffle.js.runtime.util.LRUCache;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.security.SecurityController;

public class DefaultSecurityController
implements SecurityController {
    public static final DefaultSecurityController INSTANCE = new DefaultSecurityController();
    private static final Map<String, Boolean> isCustomModuleCache = Collections.synchronizedMap(new LRUCache(8192));
    private static final Set<String> notAllowPrefixSet = new HashSet<String>();

    public static boolean isCustomModule(String scriptPath, ScriptInfo scriptInfo) {
        if (scriptPath == null) {
            return true;
        }
        Boolean isCustomModule = isCustomModuleCache.get(scriptPath);
        if (isCustomModule == null) {
            isCustomModule = Boolean.FALSE;
            String[] split = scriptPath.split("/");
            if (split.length >= 2) {
                boolean isISV;
                String segCloud = split[1];
                boolean bl = isISV = scriptInfo != null && scriptInfo.isISV();
                if (isISV && !segCloud.startsWith("bos-")) {
                    isCustomModule = Boolean.TRUE;
                }
            }
            isCustomModuleCache.put(scriptPath, isCustomModule);
        }
        return isCustomModule;
    }

    @Override
    public boolean allowHostClassLookup(String className) {
        for (String prefix : notAllowPrefixSet) {
            if (!className.startsWith(prefix)) continue;
            return className.equals("java.lang.reflect.Array");
        }
        return true;
    }

    @Override
    public boolean allowCreateHostObject(Class<?> cls) {
        return true;
    }

    @Override
    public boolean allowImportInternal(String scriptPath, String importInternalModulePath, ScriptInfo scriptInfo) {
        return !DefaultSecurityController.isCustomModule(scriptPath, scriptInfo);
    }

    @Override
    public boolean allowUseConstructorType(String scriptPath, String className, ScriptInfo scriptInfo) {
        return !DefaultSecurityController.isCustomModule(scriptPath, scriptInfo) || "kd.sdk.bos.launch.KingScriptPluginRegister".equals(className);
    }

    static {
        notAllowPrefixSet.add("java.lang.reflect.");
        notAllowPrefixSet.add("java.lang.Class");
        notAllowPrefixSet.add("java.lang.Runtime");
        notAllowPrefixSet.add("java.lang.System");
        notAllowPrefixSet.add("java.lang.Thread");
        notAllowPrefixSet.add("java.net.Socket");
        notAllowPrefixSet.add("java.net.ServerSocket");
        notAllowPrefixSet.add("java.io.");
        notAllowPrefixSet.add("java.nio.");
        notAllowPrefixSet.add("org.graalvm.");
        notAllowPrefixSet.add("com.oracle.truffle.");
    }
}

