/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.thread.host;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.sdk.kingscript.exception.AbortException;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.PolyglotException;

public class InterruptHostThreadSafePoint {
    public static void safepoint() {
        block3: {
            if (Thread.interrupted()) {
                throw new AbortException();
            }
            Context context = Context.getCurrent();
            try {
                context.safepoint();
            }
            catch (PolyglotException e) {
                if (!e.isInterrupted() && !e.isCancelled()) break block3;
                throw new AbortException(e);
            }
        }
    }

    public static <T> T execute(Callable<T> task, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            T t = executor.submit(task).get(timeout, unit);
            return t;
        }
        catch (TimeoutException e) {
            Context context = Context.getCurrent();
            if (context != null) {
                context.interrupt(Duration.ZERO);
            }
            throw e;
        }
        finally {
            executor.shutdown();
        }
    }
}

