/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.thread.local;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadLocalEx<T>
extends ThreadLocal<T> {
    private static volatile Method getMapMethod;
    private static volatile Method removeMethod;
    private Map<Thread, Boolean> allValueMap = new ConcurrentHashMap<Thread, Boolean>();

    @Override
    public void set(T value) {
        super.set(value);
        this.allValueMap.put(Thread.currentThread(), Boolean.TRUE);
    }

    @Override
    public void remove() {
        super.remove();
        this.allValueMap.remove(Thread.currentThread());
    }

    public void remove(Thread t) {
        try {
            this.allValueMap.remove(t);
            Object threadLocalMap = this.invokeGetMethod(t);
            this.invokeRemoveMethod(threadLocalMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clearDieThread() {
        for (Thread t : new ArrayList<Thread>(this.allValueMap.keySet())) {
            if (t.isAlive()) continue;
            this.remove(t);
        }
    }

    public void clearAll() {
        for (Thread t : new ArrayList<Thread>(this.allValueMap.keySet())) {
            this.remove(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeGetMethod(Thread t) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (getMapMethod == null) {
            ThreadLocalEx threadLocalEx = this;
            synchronized (threadLocalEx) {
                if (getMapMethod == null) {
                    Method getMapMethodLocal = ThreadLocal.class.getDeclaredMethod("getMap", Thread.class);
                    getMapMethodLocal.setAccessible(true);
                    getMapMethod = getMapMethodLocal;
                }
            }
        }
        return getMapMethod.invoke((Object)this, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeRemoveMethod(Object threadLocalMap) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (threadLocalMap != null) {
            if (removeMethod == null) {
                ThreadLocalEx threadLocalEx = this;
                synchronized (threadLocalEx) {
                    if (removeMethod == null) {
                        Method removeMethodLocal = threadLocalMap.getClass().getDeclaredMethod("remove", ThreadLocal.class);
                        removeMethodLocal.setAccessible(true);
                        removeMethod = removeMethodLocal;
                    }
                }
            }
            removeMethod.invoke(threadLocalMap, this);
        }
    }
}

