/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.thread.recycle;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.sdk.kingscript.exception.ScriptException;

final class ThreadAutoCloseableHub
implements AutoCloseable {
    private static ThreadLocal<ThreadAutoCloseableHub> toRecycleTH = new ThreadLocal();
    private List<AutoCloseable> acList = new LinkedList<AutoCloseable>();

    static void hookRecycle(AutoCloseable ac) {
        ThreadAutoCloseableHub hub = toRecycleTH.get();
        if (hub == null) {
            hub = new ThreadAutoCloseableHub();
            toRecycleTH.set(hub);
        }
        hub.addAutoCloseable(ac);
    }

    static boolean removeHookRecycle(AutoCloseable ac) {
        ThreadAutoCloseableHub hub = toRecycleTH.get();
        if (hub != null) {
            boolean b = hub.acList.remove(ac);
            if (hub.acList.isEmpty()) {
                toRecycleTH.remove();
            }
            return b;
        }
        return false;
    }

    private ThreadAutoCloseableHub() {
    }

    private void addAutoCloseable(AutoCloseable ac) {
        this.acList.add(ac);
    }

    @Override
    public void close() {
        ScriptException ex = null;
        for (AutoCloseable ac : new ArrayList<AutoCloseable>(this.acList)) {
            try {
                ac.close();
            }
            catch (Exception e) {
                if (ex == null) {
                    ex = ScriptException.wrap(e);
                    continue;
                }
                ex.setNextException(ScriptException.wrap(e));
            }
        }
        if (ex != null) {
            throw ex;
        }
    }
}

