/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.tool;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.sdk.annotation.SdkScriptWrapper;
import kd.sdk.kingscript.tool.EngineConfigForGen;

public final class ScriptWrapperSetupAndCheck {
    private final Map<String, String> sdkReplaceTypeMap;
    private final Map<String, Class<?>> sdkReplaceTypeClassMap;
    private final Set<String> replaceWrapperClassNameSet;

    public static void check(Class<?>[] allSdkClass) {
        new ScriptWrapperSetupAndCheck().doSetupSdkReplaceTypeMap(allSdkClass);
    }

    public static void setupSdkReplaceTypeMap(Class<?>[] allSdkClass, Map<String, String> sdkReplaceTypeMap, Map<String, Class<?>> sdkReplaceTypeClassMap, Set<String> replaceWrapperClassNameSet) {
        new ScriptWrapperSetupAndCheck(sdkReplaceTypeMap, sdkReplaceTypeClassMap, replaceWrapperClassNameSet).doSetupSdkReplaceTypeMap(allSdkClass);
    }

    private ScriptWrapperSetupAndCheck() {
        this.sdkReplaceTypeMap = new HashMap<String, String>();
        this.sdkReplaceTypeClassMap = new HashMap();
        this.replaceWrapperClassNameSet = new HashSet<String>();
    }

    private ScriptWrapperSetupAndCheck(Map<String, String> sdkReplaceTypeMap, Map<String, Class<?>> sdkReplaceTypeClassMap, Set<String> replaceWrapperClassNameSet) {
        this.sdkReplaceTypeMap = sdkReplaceTypeMap;
        this.sdkReplaceTypeClassMap = sdkReplaceTypeClassMap;
        this.replaceWrapperClassNameSet = replaceWrapperClassNameSet;
    }

    private void setSdkReplaceType(String className, String typeName) {
        this.sdkReplaceTypeMap.put(className, typeName);
    }

    private void doSetupSdkReplaceTypeMap(Class<?>[] allSdkClass) {
        HashMap aliasWrapperMap = new HashMap();
        HashMap javaTypeWrapperMap = new HashMap();
        for (Class<?> wrapperCls : allSdkClass) {
            Class existsWrapperCls;
            SdkScriptWrapper wrapper;
            if (EngineConfigForGen.skipInnerWrapper(wrapperCls) || javaTypeWrapperMap.containsValue(wrapperCls) || (wrapper = wrapperCls.getAnnotation(SdkScriptWrapper.class)) == null) continue;
            String aliasName = wrapper.scriptName();
            Class<?> javaType = wrapper.javaType();
            if (javaType == Object.class) {
                javaType = wrapperCls;
            }
            if (aliasName == null || aliasName.trim().isEmpty()) {
                aliasName = wrapperCls.getSimpleName();
            }
            if ((existsWrapperCls = (Class)javaTypeWrapperMap.get(javaType)) != null) {
                String error = "[@SdkScriptWrapper] \u4e0d\u5141\u8bb8\u5b58\u5728\u76f8\u540c\u7684javaType(" + javaType.getName() + "): " + existsWrapperCls.getName() + "\u548c" + wrapperCls.getName();
                throw new RuntimeException(error);
            }
            javaTypeWrapperMap.put(javaType, wrapperCls);
            String aliasFullName = wrapperCls.getPackage().getName() + '.' + aliasName;
            existsWrapperCls = (Class)aliasWrapperMap.get(aliasFullName);
            if (existsWrapperCls != null) {
                String error = "[@SdkScriptWrapper] \u4e0d\u5141\u8bb8\u5b58\u5728\u76f8\u540c\u7684scriptName(" + aliasFullName + "): " + existsWrapperCls.getName() + "\u548c" + wrapperCls.getName();
                throw new RuntimeException(error);
            }
            aliasWrapperMap.put(aliasFullName, wrapperCls);
            if (wrapperCls != javaType) {
                if (!wrapperCls.getName().equals(aliasFullName)) {
                    try {
                        Class.forName(aliasFullName);
                        throw new RuntimeException("[@SdkScriptWrapper] " + wrapperCls.getName() + "\u7684scriptName\u547d\u540d\u4e0e\u6b64\u7c7b\u51b2\u7a81: " + aliasFullName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                this.setSdkReplaceType(javaType.getName(), aliasFullName);
                this.setSdkReplaceType(wrapperCls.getName(), aliasFullName);
                this.sdkReplaceTypeClassMap.put(javaType.getName(), wrapperCls);
            }
            this.replaceWrapperClassNameSet.add(wrapperCls.getName());
        }
    }
}

