/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.transpiler;

import java.util.Map;
import kd.sdk.kingscript.transpiler.ScriptFeature;
import kd.sdk.kingscript.transpiler.sourcemap.SourceMap;
import kd.sdk.kingscript.types.convert.TypeConvertInterceptor;
import org.graalvm.polyglot.Value;

public final class TransResult {
    private Value jsValue;
    private ScriptFeature scriptFeature;
    private Map<String, Object> javaTypedValue;
    private String code;
    private SourceMap sourceMap;
    private boolean skipTrans = false;

    public static TransResult noTransResult(String code) {
        return new TransResult(code);
    }

    private TransResult(String code) {
        this.code = code;
        this.skipTrans = true;
    }

    public TransResult(Value jsValue, ScriptFeature scriptFeature, boolean keepMappingString) {
        this.jsValue = jsValue;
        this.scriptFeature = scriptFeature;
        this.javaTypedValue = (Map)TypeConvertInterceptor.hook_unwrap(jsValue);
        this.code = (String)this.javaTypedValue.get("code");
        Object map = this.javaTypedValue.get("map");
        if (map != null) {
            String mappings = (String)((Map)map).get("mappings");
            this.sourceMap = SourceMap.decode(mappings, keepMappingString);
        }
    }

    public boolean isSkipTrans() {
        return this.skipTrans;
    }

    public ScriptFeature getScriptFeature() {
        return this.scriptFeature;
    }

    public void setCode(String code) {
        this.code = code;
        this.jsValue.putMember("code", (Object)code);
    }

    public String getCode() {
        return this.code;
    }

    public SourceMap getSourceMap() {
        return this.sourceMap;
    }

    public String toString() {
        return this.code;
    }
}

