/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.transpiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.sdk.kingscript.transpiler.TargetVersion;
import kd.sdk.kingscript.transpiler.plugin.BabelPlugin;
import kd.sdk.kingscript.transpiler.plugin.TransInheritPlugin;
import kd.sdk.kingscript.transpiler.preset.BabelPreset;
import kd.sdk.kingscript.transpiler.preset.TypeScriptPreset;

public class TranslationOptions {
    private boolean minified = true;
    private boolean genAST = false;
    private boolean genSourceMaps = false;
    private boolean comments = false;
    private List<BabelPreset> presets = new ArrayList<BabelPreset>();
    private List<BabelPlugin> plugins = new ArrayList<BabelPlugin>();
    private TargetVersion targetVersion = TargetVersion.ES6;

    public String optionsKey(boolean debug) {
        return this.targetVersion.name() + '|' + (debug ? (char)'1' : '0') + (this.minified ? (char)'1' : '0') + (this.genAST ? (char)'1' : '0') + (this.genSourceMaps ? (char)'1' : '0') + (this.comments ? (char)'1' : '0') + this.presets + '|' + this.plugins;
    }

    public boolean isMinified() {
        return this.minified;
    }

    public void setMinified(boolean minified) {
        this.minified = minified;
    }

    public TranslationOptions() {
        this.addPreset(TypeScriptPreset.getInstance());
        this.addPlugin(TransInheritPlugin.getInstance());
    }

    public TargetVersion getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(TargetVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    public List<BabelPreset> getPresets() {
        return Collections.unmodifiableList(this.presets);
    }

    public final void addPreset(BabelPreset preset) {
        this.presets.add(preset);
    }

    public void removePreset(BabelPreset preset) {
        this.presets.remove(preset);
    }

    public List<BabelPlugin> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    public void addPlugin(BabelPlugin plugin) {
        this.plugins.add(plugin);
    }

    public void removePlugin(BabelPlugin plugin) {
        this.plugins.remove(plugin);
    }

    public boolean isGenAST() {
        return this.genAST;
    }

    public void setGenAST(boolean genAST) {
        this.genAST = genAST;
    }

    public boolean isGenSourceMaps() {
        return this.genSourceMaps;
    }

    public void setGenSourceMaps(boolean genSourceMaps) {
        this.genSourceMaps = genSourceMaps;
    }

    public boolean isComments() {
        return this.comments;
    }

    public void setComments(boolean comments) {
        this.comments = comments;
    }
}

