/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.transpiler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Collectors;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.ScriptOptions;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.crypto.CryptoUtil;
import kd.sdk.kingscript.log.Loggable;
import kd.sdk.kingscript.transpiler.BabelTranspiler;
import kd.sdk.kingscript.transpiler.TransResult;
import kd.sdk.kingscript.util.FileUtil;

public final class Transpiler {
    private Transpiler() {
    }

    public static void compileDirectoryMinified(KingScriptEngine executeEngine, String source, String out, String cryptoName) {
        boolean keepOutJS = cryptoName == null;
        Loggable.logger.info("compileDirectoryMinified(" + (cryptoName == null ? "NoCrypto" : "CryptoService=" + cryptoName) + "): " + source + " --> " + out);
        File sourceFile = new File(source);
        ArrayList<File> sourceFileList = new ArrayList<File>();
        FileUtil.collectFiles(sourceFile, sourceFileList, file -> {
            String name = file.getName();
            return name.endsWith(".ts") && !name.equals(".d.ts");
        });
        int rootLen = sourceFile.getAbsolutePath().length();
        Loggable.logger.info("found .ts files: " + sourceFileList.size());
        String[] scriptFiles = sourceFileList.stream().map(file -> file.getAbsolutePath()).collect(Collectors.toList()).toArray(new String[sourceFileList.size()]);
        String[] minScriptContents = Transpiler.compileFilesMinified(executeEngine, cryptoName, scriptFiles);
        int n = sourceFileList.size();
        for (int i = 0; i < n; ++i) {
            String tsPath = ((File)sourceFileList.get(i)).getAbsolutePath();
            tsPath = out + tsPath.substring(rootLen);
            String outScriptFile = tsPath + ".c.min";
            FileUtil.save(outScriptFile, minScriptContents[i]);
            Loggable.logger.info("out => " + outScriptFile);
            if (keepOutJS) continue;
            String outJsPath = tsPath.substring(0, tsPath.length() - 2) + "js";
            Loggable.logger.info("delete JS: " + outJsPath);
            new File(outJsPath).delete();
        }
        Loggable.logger.info("compileDirectoryMinified completed!");
    }

    public static String compileFileMinified(KingScriptEngine executeEngine, String cryptoName, String scriptFile) {
        try {
            String ts = FileUtil.readString(Paths.get(scriptFile, new String[0]));
            return CryptoUtil.encrypt(cryptoName, Transpiler.trans(executeEngine, ts)[0].getCode());
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    public static String[] compileFilesMinified(KingScriptEngine executeEngine, String cryptoName, String ... scriptFiles) {
        try {
            String[] ts = new String[scriptFiles.length];
            int i = 0;
            for (String scriptFile : scriptFiles) {
                ts[i++] = FileUtil.readString(Paths.get(scriptFile, new String[0]));
            }
            TransResult[] transResults = Transpiler.trans(executeEngine, ts);
            String[] ret = new String[scriptFiles.length];
            i = 0;
            for (TransResult transResult : transResults) {
                ret[i++] = CryptoUtil.encrypt(cryptoName, transResult.getCode());
            }
            return ret;
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    private static TransResult[] trans(KingScriptEngine executeEngine, String ... ts) {
        ScriptOptions options = ScriptOptions.createDefault();
        options.getDebugOptions().setEnabled(false);
        TransResult[] ret = new TransResult[ts.length];
        try (BabelTranspiler engine = BabelTranspiler.create(options);){
            int i = 0;
            for (String s : ts) {
                ret[i++] = engine.trans(executeEngine, s, false, false);
            }
        }
        return ret;
    }
}

