/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.transpiler;

import java.util.Map;
import kd.sdk.kingscript.config.LazySetHolder;
import kd.sdk.kingscript.debug.DebugThreadLocalRestorer;

public class TranspilerEvalContext
implements AutoCloseable {
    private static final LazySetHolder<DebugThreadLocalRestorer> HOLDER = new LazySetHolder<Object>("kingscript.debug.ThreadLocalRestorer", null);
    private static final ThreadLocal<TranspilerEvalContext> th = new ThreadLocal();
    private final TranspilerEvalContext parent;
    private final String scriptPath;
    private final DebugThreadLocalRestorer threadLocalRestorer;

    public static TranspilerEvalContext setup(String scriptPath, Map<String, String> env) {
        return new TranspilerEvalContext(scriptPath, env);
    }

    public static TranspilerEvalContext get() {
        return th.get();
    }

    public static Map<String, String> getEnv() {
        if (HOLDER.get() != null) {
            return HOLDER.get().get();
        }
        return null;
    }

    private TranspilerEvalContext(String scriptPath, Map<String, String> env) {
        this.scriptPath = scriptPath;
        this.parent = th.get();
        this.threadLocalRestorer = HOLDER.get();
        if (this.threadLocalRestorer != null && env != null) {
            this.threadLocalRestorer.set(env);
        }
        th.set(this);
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    @Override
    public void close() {
        if (this.threadLocalRestorer != null) {
            this.threadLocalRestorer.remove();
        }
        if (this.parent == null) {
            th.remove();
        } else {
            th.set(this.parent);
        }
    }
}

