/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.transpiler.model;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.sdk.kingscript.transpiler.model.ScriptSegment;

public class ScriptImportSegment
extends ScriptSegment {
    private String from;
    private Map<String, String> importItemMap = new HashMap<String, String>();

    public ScriptImportSegment(AtomicInteger lineCounter) {
        super(lineCounter);
    }

    @Override
    public int parse(char[] chs, int i) {
        String items;
        int n = chs.length;
        int toIndex = n - 1;
        int lineCount = 0;
        for (int j = i; j < n; ++j) {
            if (chs[j] == ';') {
                toIndex = j;
                break;
            }
            if (chs[j] != '\n') continue;
            ++lineCount;
        }
        String script = new String(chs, i, toIndex - i + 1);
        int p = -1;
        do {
            if ((p = script.indexOf("from", p + 1)) != -1) continue;
            return i;
        } while (Character.isAlphabetic(script.charAt(p - 1)) || Character.isAlphabetic(script.charAt(p + 4)));
        this.sb.append(script);
        this.from = script.substring(p + 4).replace('\r', ' ').replace('\n', ' ').replace(";", "").trim();
        if (this.from.charAt(0) == '\"' || this.from.charAt(0) == '\'') {
            this.from = this.from.substring(1, this.from.length() - 1);
        }
        if ((items = script.substring(6, p).replace('\r', ' ').replace('\n', ' ').replace(";", "").trim()).charAt(0) == '{') {
            items = items.substring(1, items.length() - 1);
        }
        for (String item : items.split(",")) {
            item = item.trim();
            boolean all = false;
            p = item.indexOf(" as ");
            if (p == -1) {
                p = item.indexOf("*as ");
                all = true;
            }
            if (p == -1) {
                this.importItemMap.put(item, item);
                continue;
            }
            String key = all ? "*" : item.substring(0, p).trim();
            this.importItemMap.put(key, item.substring(p + 3).trim());
        }
        this.lineCounter.addAndGet(lineCount);
        return toIndex;
    }

    public String getFrom() {
        return this.from;
    }

    public Map<String, String> getImportItemMap() {
        return this.importItemMap;
    }
}

