/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.transpiler.model.translator;

import java.util.List;
import kd.sdk.kingscript.transpiler.ScriptFeature;
import kd.sdk.kingscript.transpiler.model.ScriptModel;
import kd.sdk.kingscript.transpiler.model.ScriptModelParser;
import kd.sdk.kingscript.transpiler.model.ScriptSegment;
import kd.sdk.kingscript.transpiler.model.translator.ConstructorTypeSegmentTranslator;
import kd.sdk.kingscript.transpiler.model.translator.SegmentTranslator;

public final class Translator {
    public static String transDefault(String script, ScriptFeature scriptFeature) {
        return Translator.trans(script, scriptFeature, new ConstructorTypeSegmentTranslator());
    }

    public static String trans(String s, ScriptFeature scriptFeature, SegmentTranslator ... translators) {
        ScriptModel scriptModel = ScriptModelParser.parse(s);
        List<ScriptSegment> segmentList = scriptModel.getSegmentList();
        for (SegmentTranslator translator : translators) {
            int n = segmentList.size();
            for (int i = 0; i < n; ++i) {
                ScriptSegment segment = segmentList.get(i);
                if (!translator.accept(segment)) continue;
                ScriptSegment ret = translator.trans(segment, scriptFeature);
                if (ret.isEmpty()) {
                    segmentList.remove(i);
                    --i;
                    --n;
                    continue;
                }
                segmentList.set(i, ret);
            }
        }
        return scriptModel.toString();
    }
}

