/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.types.convert;

import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.host.HostLanguageService;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.sdk.kingscript.engine.KingScriptContext;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.mixture.Mixture;
import kd.sdk.kingscript.types.ScriptValue;
import kd.sdk.kingscript.types.adapter.TypeAdapters;
import kd.sdk.kingscript.types.adapter.config.TypeAdapterConfigItem;
import kd.sdk.kingscript.types.wrapper.ScriptObjectWrapper;
import org.graalvm.polyglot.Value;

public final class TypeConvertInterceptor {
    private static final TypeAdapterConfigItem EMPTY_ITEM = new TypeAdapterConfigItem<Object, Object>(null, null, false, t -> null);
    private static final Map<Class, TypeAdapterConfigItem> wrapItemMap = new ConcurrentHashMap<Class, TypeAdapterConfigItem>();
    private static final List<Class> wrapClassList = new ArrayList<Class>();
    private static final Field valueReceiverField;
    private static List<TypeAdapterConfigItem> adapterConfigItems;

    public static List<TypeAdapterConfigItem> getAdapterConfigItems() {
        return Collections.unmodifiableList(adapterConfigItems);
    }

    public static Object hook_unwrap(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Value) {
            return TypeConvertInterceptor.unwrapValue((Value)value);
        }
        if (value instanceof ScriptValue) {
            return ((ScriptValue)value).asJavaObject();
        }
        if (value instanceof ScriptObjectWrapper) {
            return ((ScriptObjectWrapper)value).unwrap();
        }
        Class<?> cls = value.getClass();
        if (cls.isArray()) {
            Class<?> componentType = cls.getComponentType();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object unwrap = TypeConvertInterceptor.hook_unwrap(Array.get(value, i));
                if (unwrap == null || !componentType.isAssignableFrom(unwrap.getClass())) continue;
                Array.set(value, i, unwrap);
            }
        }
        return TypeConvertInterceptor.unwrap_HostProxy_or_HostObject(value);
    }

    private static Object unwrapValue(Value value) {
        try {
            Object hostObj = valueReceiverField.get(value);
            hostObj = TypeConvertInterceptor.unwrap_HostProxy_or_HostObject(hostObj);
            if (hostObj instanceof TruffleObject) {
                hostObj = value.as(Object.class);
            }
            return hostObj;
        }
        catch (IllegalAccessException e) {
            throw new ScriptException(e);
        }
    }

    public static Object getReceiver(Value value) {
        try {
            return valueReceiverField.get(value);
        }
        catch (IllegalAccessException e) {
            throw new ScriptException(e);
        }
    }

    public static Object unwrap_HostProxy_or_HostObject(Object obj) {
        KingScriptContext ctx = KingScriptContext.get();
        if (ctx != null) {
            HostLanguageService hs = ctx.getHostLanguageService();
            if (hs.isHostProxy(obj)) {
                Object unwrapObj = hs.unboxProxyObject(obj);
                if (unwrapObj instanceof ScriptObjectWrapper) {
                    return ((ScriptObjectWrapper)unwrapObj).unwrap();
                }
            } else {
                if (hs.isHostObject(obj)) {
                    obj = hs.unboxHostObject(obj);
                }
                if (obj instanceof ScriptObjectWrapper) {
                    obj = ((ScriptObjectWrapper)obj).unwrap();
                }
            }
        }
        return obj;
    }

    public static Object hook_wrap(Object obj) {
        if (!(obj instanceof ScriptObjectWrapper) && !(obj instanceof Mixture)) {
            if (obj == null) {
                return null;
            }
            TypeAdapterConfigItem item = TypeConvertInterceptor.getTypeAdapterConfigItem(obj.getClass());
            if (item != null && !((obj = item.getConverter().apply(obj)) instanceof ScriptObjectWrapper) && !(obj instanceof TruffleObject)) {
                throw new ScriptException("Wrap as type error: " + obj + " should implement one of ScriptObjectWrapper or TruffleObject.");
            }
        }
        return obj;
    }

    private static TypeAdapterConfigItem getTypeAdapterConfigItem(Class cls) {
        String name;
        if (cls.getTypeName().endsWith("$$Adapter")) {
            return null;
        }
        TypeAdapterConfigItem item = wrapItemMap.get(cls);
        if (item == null && (name = cls.getName()).contains("$")) {
            Class<?>[] interfaces;
            Class<Object> realCls = cls.getSuperclass();
            if (realCls == Object.class && (interfaces = cls.getInterfaces()).length == 1) {
                realCls = interfaces[0];
            }
            if ((item = TypeConvertInterceptor.getTypeAdapterConfigItem(realCls)) != null) {
                wrapItemMap.put(cls, item);
            }
        }
        if (item != null) {
            return item == EMPTY_ITEM ? null : item;
        }
        HashMap<Class, TypeAdapterConfigItem> assignableMap = null;
        for (Class assignableCls : wrapClassList) {
            if (!assignableCls.isInterface() || !assignableCls.isAssignableFrom(cls)) continue;
            item = wrapItemMap.get(assignableCls);
            if (item == null) {
                wrapItemMap.put(assignableCls, EMPTY_ITEM);
                continue;
            }
            if (item == EMPTY_ITEM || !item.isIncludeSubTypes()) continue;
            if (assignableMap == null) {
                assignableMap = new HashMap<Class, TypeAdapterConfigItem>();
            }
            assignableMap.put(assignableCls, item);
        }
        if (assignableMap != null) {
            if (assignableMap.size() == 1) {
                item = (TypeAdapterConfigItem)assignableMap.values().iterator().next();
                wrapItemMap.put(cls, item);
                return item;
            }
            ArrayList assignableClsList = new ArrayList(assignableMap.keySet());
            int N = assignableClsList.size();
            block1: for (int i = 0; i < N - 1; ++i) {
                Class cls1 = (Class)assignableClsList.get(i);
                if (cls1 == null) continue;
                for (int j = i + 1; j < N; ++j) {
                    Class cls2 = (Class)assignableClsList.get(j);
                    if (cls2 == null) continue;
                    if (cls1.isAssignableFrom(cls2)) {
                        assignableClsList.set(i, null);
                        continue block1;
                    }
                    if (!cls2.isAssignableFrom(cls1)) continue;
                    assignableClsList.set(j, null);
                }
            }
            HashSet<Class> assignableClsSet = new HashSet<Class>(N);
            for (Class assignableCls : assignableClsList) {
                if (assignableCls == null) continue;
                assignableClsSet.add(assignableCls);
            }
            if (assignableClsSet.size() == 1) {
                item = (TypeAdapterConfigItem)assignableMap.get(assignableClsSet.iterator().next());
                wrapItemMap.put(cls, item);
                return item;
            }
            throw new ScriptException(cls.getName() + " exists multiple encapsulation possibilities\uff0cand it is necessary to clarify the definition of its wrapper, which is the same as the classes of the wrapper: " + assignableClsSet.stream().map(Class::getName).collect(Collectors.toList()));
        }
        wrapItemMap.put(cls, EMPTY_ITEM);
        return null;
    }

    static {
        adapterConfigItems = new ArrayList<TypeAdapterConfigItem>();
        try {
            TypeAdapters.setup(wrapItemMap, wrapClassList, adapterConfigItems);
            valueReceiverField = Value.class.getSuperclass().getDeclaredField("receiver");
            valueReceiverField.setAccessible(true);
        }
        catch (Throwable e) {
            throw new ScriptException(e);
        }
    }
}

