/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.types.mapping;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.sdk.kingscript.types.adapter.config.TypeAdapterConfigItem;
import kd.sdk.kingscript.types.convert.TypeConvertInterceptor;
import kd.sdk.kingscript.types.mapping.config.TypeMappingConfig;
import kd.sdk.kingscript.types.mapping.config.TypeMappingConfigItem;
import kd.sdk.kingscript.types.wrapper.ScriptObjectWrapper;
import org.graalvm.polyglot.HostAccess;

public final class TypeMappings {
    private static final List<TypeMappingConfigItem<Object, Object>> configList = new ArrayList<TypeMappingConfigItem<Object, Object>>();
    private static final AtomicBoolean loaded = new AtomicBoolean();

    public static void setup(HostAccess.Builder builder) {
        if (loaded.compareAndSet(false, true)) {
            ArrayList<TypeMappingConfig> spiList = new ArrayList<TypeMappingConfig>();
            ServiceLoader<TypeMappingConfig> serviceLoader = ServiceLoader.load(TypeMappingConfig.class);
            Iterator<TypeMappingConfig> iterator = serviceLoader.iterator();
            while (iterator.hasNext()) {
                spiList.add(iterator.next());
            }
            spiList.sort(Comparator.comparingInt(t -> t.level().ordinal()));
            for (TypeMappingConfig tmc : spiList) {
                List configItems = tmc.getConfigItems();
                if (configItems == null || configItems.isEmpty()) continue;
                configList.addAll(configItems);
            }
        }
        for (TypeMappingConfigItem<Object, Object> typeMappingConfigItem : configList) {
            builder.targetTypeMapping(typeMappingConfigItem.getSourceType(), typeMappingConfigItem.getTargetType(), typeMappingConfigItem.getAccepts(), typeMappingConfigItem.getConverter());
        }
        for (TypeAdapterConfigItem typeAdapterConfigItem : TypeConvertInterceptor.getAdapterConfigItems()) {
            builder.targetTypeMapping(typeAdapterConfigItem.getTargetType(), typeAdapterConfigItem.getSourceType(), v -> {
                if (v instanceof ScriptObjectWrapper) {
                    return typeAdapterConfigItem.getSourceType().isAssignableFrom(((ScriptObjectWrapper)v).unwrap().getClass());
                }
                return false;
            }, v -> ((ScriptObjectWrapper)v).unwrap());
        }
    }
}

