/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.types.wrapper;

import java.util.TreeSet;
import kd.sdk.annotation.SdkScriptWrapper;
import kd.sdk.kingscript.engine.KingScriptContext;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.types.ScriptExecutable;
import kd.sdk.kingscript.types.ScriptObject;
import kd.sdk.kingscript.types.Types;
import kd.sdk.kingscript.types.adapter.TypeAdapters;
import kd.sdk.kingscript.types.builtins.ScriptExecutableWrapper;
import kd.sdk.kingscript.types.wrapper.DynamicScriptObject;
import kd.sdk.kingscript.types.wrapper.ScriptProxyWrapper;
import kd.sdk.kingscript.util.BeanUtil;
import kd.sdk.kingscript.util.Todo;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;

public final class DynamicScriptProxyWrapper
implements ScriptProxyWrapper<Object> {
    private final Object javaBean;
    private final Object javaBeanWrapper;
    private final Value jsObject;
    private DynamicScriptObject dynamicMemberLookup;

    public static DynamicScriptProxyWrapper wrap(Object object) {
        return DynamicScriptProxyWrapper.wrap(object, true);
    }

    private static DynamicScriptProxyWrapper wrap(Object object, boolean checkIfScriptObject) {
        Object javaBean;
        Value jsObject;
        if (checkIfScriptObject) {
            DynamicScriptProxyWrapper.checkIfScriptObject(object);
        }
        if (object instanceof DynamicScriptProxyWrapper) {
            return (DynamicScriptProxyWrapper)object;
        }
        if (object instanceof Value) {
            jsObject = (Value)object;
            javaBean = Types.js2java(jsObject);
        } else {
            if (TypeAdapters.isWrapSelfObjectType(object)) {
                KingScriptContext ctx = KingScriptContext.get();
                Object hostObject = ctx.getHostLanguageService().toHostObject_no_hook_wrap(ctx.getHostContext(), object);
                jsObject = ctx.getContext().asValue(hostObject);
            } else {
                jsObject = Types.java2js(object);
            }
            javaBean = object;
        }
        return new DynamicScriptProxyWrapper(javaBean, jsObject);
    }

    private static void checkIfScriptObject(Object object) {
        Class<?> cls = object.getClass();
        if (!ScriptObject.class.isAssignableFrom(cls)) {
            throw new ScriptException("wrap " + cls.getName() + " should implement " + ScriptObject.class.getName() + ".");
        }
        if (cls.getAnnotation(SdkScriptWrapper.class) == null) {
            throw new ScriptException("wrap " + cls.getName() + " should mark annotation @" + SdkScriptWrapper.class.getSimpleName());
        }
    }

    private DynamicScriptProxyWrapper(Object javaBean, Value jsObject) {
        this.javaBean = javaBean;
        this.javaBeanWrapper = Types.js2java(jsObject);
        this.jsObject = jsObject;
        if (this.javaBeanWrapper instanceof DynamicScriptObject) {
            this.dynamicMemberLookup = (DynamicScriptObject)this.javaBeanWrapper;
        } else if (javaBean instanceof DynamicScriptObject) {
            this.dynamicMemberLookup = (DynamicScriptObject)javaBean;
        }
        this.checkWrapper();
    }

    private void checkWrapper() {
        if (this.javaBeanWrapper != this.javaBean && Types.js2java(this.javaBeanWrapper) != this.javaBean) {
            throw new ScriptException("wrapper " + this.javaBeanWrapper.getClass().getSimpleName() + " not shared with host " + this.javaBean.getClass().getSimpleName() + ", check the TypeAdapterConfig configuration and " + this.javaBeanWrapper.getClass().getSimpleName() + "'s implement.");
        }
    }

    @Override
    public Object unwrap() {
        return this.javaBean;
    }

    public Object getMember(String key) {
        if (this.jsObject.hasMember(key)) {
            return this.jsObject.getMember(key);
        }
        Value getter = this.getGetter(key);
        if (getter != null && getter.canExecute()) {
            return getter.execute(new Object[0]);
        }
        if (this.dynamicMemberLookup != null) {
            return Types.java2js(this.dynamicMemberLookup.get(key));
        }
        throw new ScriptException("No such member: " + key + " @" + this.javaBean.getClass().getSimpleName() + " or @" + this.javaBeanWrapper.getClass().getSimpleName());
    }

    @Override
    public void putMember(String key, Value value) {
        if (this.jsObject.hasMember(key)) {
            this.jsObject.putMember(key, (Object)value);
            return;
        }
        Value setter = this.getSetter(key);
        if (setter != null && setter.canExecute()) {
            setter.execute(new Object[]{value});
            return;
        }
        if (this.dynamicMemberLookup != null) {
            Object obj = this.dynamicMemberLookup.get(key);
            if (obj instanceof ScriptExecutable) {
                Todo.todo("\u5904\u7406\u591a\u53c2\u6570\u7684\u60c5\u51b5");
                ScriptExecutableWrapper.sharedOf((ScriptExecutable)obj).execute(value);
            } else if (obj instanceof ProxyExecutable) {
                ((ProxyExecutable)obj).execute(new Value[]{value});
            } else {
                this.dynamicMemberLookup.set(key, Types.js2java(value));
            }
            return;
        }
        throw new ScriptException("No such member: " + key + " @" + this.javaBean.getClass().getSimpleName() + " or @" + this.javaBeanWrapper.getClass().getSimpleName());
    }

    public boolean removeMember(String key) {
        if (this.dynamicMemberLookup != null && this.dynamicMemberLookup.remove(key)) {
            return true;
        }
        throw new UnsupportedOperationException("removeMember() not supported.");
    }

    public Object getMemberKeys() {
        TreeSet<String> members = new TreeSet<String>(this.jsObject.getMemberKeys());
        if (this.dynamicMemberLookup != null) {
            members.addAll(this.dynamicMemberLookup.keys());
        }
        return members.toArray(new String[members.size()]);
    }

    public boolean hasMember(String key) {
        return this.getGetter(key) != null || this.jsObject.hasMember(key) || this.dynamicMemberLookup != null && this.dynamicMemberLookup.has(key);
    }

    private Value getGetter(String key) {
        Value getter = this.jsObject.getMember("get" + BeanUtil.firstLetterUpperCase(key));
        if (getter == null) {
            getter = this.jsObject.getMember("is" + BeanUtil.firstLetterUpperCase(key));
        }
        return getter;
    }

    private Value getSetter(String key) {
        return this.jsObject.getMember("set" + BeanUtil.firstLetterUpperCase(key));
    }
}

