/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filestorage.s3;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.filestorage.s3.s3client.S3Client;
import kd.bos.filestorage.s3.util.URLUtils;
import kd.bos.filestorage.spi.FileStorageConfig;
import kd.bos.filestorage.spi.FileStorageService;

public class S3Storage
implements FileStorageService {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    private FileStorageConfig fileStorageConfig;
    private S3Client s3Client;

    public void setConfig(FileStorageConfig fileStorageConfig) {
        this.fileStorageConfig = fileStorageConfig;
        this.s3Client = new S3Client(fileStorageConfig.getAuthType(), fileStorageConfig.getAuthUserName(), fileStorageConfig.getAuthPassword(), fileStorageConfig.getFileServerHttpUrl(), 15000, 1000 * fileStorageConfig.getUploadTimeout());
    }

    public List<String> getForbiddenExtensions() {
        return new ArrayList<String>();
    }

    public String getTicket() {
        return null;
    }

    private String getRandomUploadBucket(String buckets) {
        String[] containerList = buckets.split(",");
        SecureRandom random = new SecureRandom();
        int index = random.nextInt(containerList.length);
        return containerList[index].trim();
    }

    public String upload(InputStream inputStream, String filePath, String fileName, boolean isCreateNewFileWhenExists, Map<String, String> headers) throws IOException, URISyntaxException {
        String bucketName = this.getRandomUploadBucket(this.fileStorageConfig.getContainer());
        this.s3Client.putObject(inputStream, bucketName, URLUtils.getValidFilePath(filePath), headers);
        return bucketName + filePath;
    }

    public InputStream getInputStream(String fullFilePath, String userAgent) throws IOException, URISyntaxException {
        URLUtils.ValidUrl validUrl = URLUtils.getValidUrl(fullFilePath);
        return this.s3Client.getS3ObjectAsStream(validUrl.getBucketName(), validUrl.getFilePath());
    }

    public void download(String fullFilePath, OutputStream outputStream, String userAgent) throws IOException, URISyntaxException {
        URLUtils.ValidUrl validUrl = URLUtils.getValidUrl(fullFilePath);
        this.s3Client.getObject(validUrl.getBucketName(), validUrl.getFilePath(), outputStream);
    }

    public void delete(String fullFilePath) throws IOException, URISyntaxException {
        URLUtils.ValidUrl validUrl = URLUtils.getValidUrl(fullFilePath);
        this.s3Client.removeObject(validUrl.getBucketName(), validUrl.getFilePath());
    }

    public boolean exists(String fullFilePath) throws IOException, URISyntaxException {
        URLUtils.ValidUrl validUrl = URLUtils.getValidUrl(fullFilePath);
        return this.s3Client.exists(validUrl.getBucketName(), validUrl.getFilePath());
    }

    public void close() throws IOException {
        this.s3Client.close();
    }
}

