/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filestorage.s3.auth.aws.v4;

import kd.bos.filestorage.s3.auth.AuthInfo;
import kd.bos.filestorage.s3.auth.IAuthStrategy;
import kd.bos.filestorage.s3.auth.aws.v4.AWSV4SignerBase;
import kd.bos.filestorage.s3.auth.aws.v4.AWSV4SignerForAuthorizationHeader;
import kd.bos.filestorage.s3.util.DataUtils;

public class AWSV4AuthStrategy
implements IAuthStrategy {
    private static final String SERVICE_NAME_S3 = "s3";

    @Override
    public void auth(AuthInfo authInfo) {
        AWSV4SignerForAuthorizationHeader signer = new AWSV4SignerForAuthorizationHeader(authInfo.getUrl(), authInfo.getHttpMethod(), SERVICE_NAME_S3);
        String authorization = signer.computeSignature(authInfo.getHeaders(), null, this.calculateContentHashString(authInfo.getContent()), authInfo.getAccessKey(), authInfo.getSecretKey());
        authInfo.getHeaders().put("Authorization", authorization);
    }

    private String calculateContentHashString(byte[] content) {
        if (content == null) {
            return AWSV4SignerBase.EMPTY_BODY_SHA256;
        }
        byte[] contentHash = AWSV4SignerBase.hash(content);
        return DataUtils.toHex(contentHash);
    }
}

