/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filestorage.s3.s3client;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.filestorage.s3.auth.AuthContext;
import kd.bos.filestorage.s3.auth.AuthInfo;
import kd.bos.filestorage.s3.util.DataUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class S3Client
implements Closeable {
    public static final String PLACEHOLDER = "%s/%s/%s";
    private static Log logger = LogFactory.getLog(S3Client.class);
    private String serverUrl;
    private String accessKey;
    private String secretKey;
    private CloseableHttpClient httpClient2;
    private int connectionTimeOut;
    private int socketTimeout;
    private AuthContext authContext;

    public S3Client(String authType, String accessKey, String secretKey, String serverUrl, int connectionTimeOut, int socketTimeout) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.serverUrl = serverUrl;
        this.connectionTimeOut = connectionTimeOut;
        this.socketTimeout = socketTimeout;
        this.authContext = new AuthContext(authType);
    }

    private void setHeaderToRequest(Map<String, String> headers, HttpRequestBase request) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public List<String> listBuckets() throws URISyntaxException, IOException, DocumentException {
        String url = String.format("%s/", this.serverUrl);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.authContext.auth(new AuthInfo(url, headers, this.accessKey, this.secretKey, "GET", null));
        URIBuilder urlBuilder = new URIBuilder(url);
        HttpGet request = new HttpGet(urlBuilder.build());
        this.setHeaderToRequest(headers, (HttpRequestBase)request);
        try (CloseableHttpResponse response = this.doHttpInvoke((HttpRequestBase)request);){
            String xmlResponse = EntityUtils.toString((HttpEntity)response.getEntity());
            List<String> list = S3Client.getBucketsFromXml(xmlResponse);
            return list;
        }
    }

    public static List<String> getBucketsFromXml(String xmlContent) throws DocumentException {
        ArrayList<String> bucketNames = new ArrayList<String>(8);
        SAXReader saxReader = new SAXReader();
        try {
            saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException e) {
            logger.error("XXE: " + e.getMessage());
        }
        Document document = saxReader.read((InputStream)new ByteArrayInputStream(xmlContent.getBytes(StandardCharsets.UTF_8)));
        Element root = document.getRootElement();
        Element buckets = root.element("Buckets");
        if (buckets == null) {
            return Collections.emptyList();
        }
        Iterator it = buckets.elementIterator();
        while (it.hasNext()) {
            Element bucketName;
            Element bucket = (Element)it.next();
            if (bucket == null || (bucketName = bucket.element("Name")) == null) continue;
            bucketNames.add(bucketName.getText());
        }
        return bucketNames;
    }

    public void createBucket(String bucketName) throws URISyntaxException, IOException {
        String url = String.format("%s/%s", this.serverUrl, bucketName);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.authContext.auth(new AuthInfo(url, headers, this.accessKey, this.secretKey, "PUT", null));
        URIBuilder urlBuilder = new URIBuilder(url);
        HttpPut request = new HttpPut(urlBuilder.build());
        this.setHeaderToRequest(headers, (HttpRequestBase)request);
        this.httpInvoke((HttpRequestBase)request);
    }

    private void httpInvoke(HttpRequestBase request) throws IOException {
        try (CloseableHttpResponse response = this.doHttpInvoke(request);){
            if (this.isHttpNotOk(response)) {
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{response.getStatusLine().getReasonPhrase()});
            }
        }
    }

    public void getObject(String bucketName, String filePath, OutputStream out) throws URISyntaxException, IOException {
        String url = String.format(PLACEHOLDER, this.serverUrl, bucketName, filePath);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.authContext.auth(new AuthInfo(url, headers, this.accessKey, this.secretKey, "GET", null));
        URIBuilder urlBuilder = new URIBuilder(url);
        HttpGet request = new HttpGet(urlBuilder.build());
        this.setHeaderToRequest(headers, (HttpRequestBase)request);
        try (CloseableHttpResponse response = this.doHttpInvoke((HttpRequestBase)request);){
            if (this.isHttpNotOk(response)) {
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{response.getStatusLine().getReasonPhrase()});
            }
            InputStream input = response.getEntity().getContent();
            IOUtils.copy((InputStream)input, (OutputStream)out);
        }
    }

    public InputStream getS3ObjectAsStream(String bucketName, String filePath) throws URISyntaxException, IOException {
        String url = String.format(PLACEHOLDER, this.serverUrl, bucketName, filePath);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.authContext.auth(new AuthInfo(url, headers, this.accessKey, this.secretKey, "GET", null));
        URIBuilder urlBuilder = new URIBuilder(url);
        HttpGet request = new HttpGet(urlBuilder.build());
        this.setHeaderToRequest(headers, (HttpRequestBase)request);
        CloseableHttpResponse response = this.doHttpInvokeNoclose((HttpRequestBase)request);
        if (this.isHttpNotOk(response)) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{response.getStatusLine().getReasonPhrase()});
        }
        return response.getEntity().getContent();
    }

    public void putObject(InputStream input, String bucketName, String filePath, Map<String, String> metadata) throws IOException, URISyntaxException {
        String url = String.format(PLACEHOLDER, this.serverUrl, bucketName, filePath);
        HashMap<String, String> headers = new HashMap<String, String>();
        byte[] byteData = DataUtils.inputStreamToBytes(input);
        this.authContext.auth(new AuthInfo(url, headers, this.accessKey, this.secretKey, "PUT", byteData));
        URIBuilder urlBuilder = new URIBuilder(url);
        HttpPut request = new HttpPut(urlBuilder.build());
        ByteArrayEntity httpEntity = new ByteArrayEntity(byteData);
        request.setEntity((HttpEntity)httpEntity);
        if (metadata != null) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
        this.setHeaderToRequest(headers, (HttpRequestBase)request);
        this.httpInvoke((HttpRequestBase)request);
    }

    public void removeObject(String bucketName, String filePath) throws URISyntaxException, IOException {
        String url = String.format(PLACEHOLDER, this.serverUrl, bucketName, filePath);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.authContext.auth(new AuthInfo(url, headers, this.accessKey, this.secretKey, "DELETE", null));
        URIBuilder urlBuilder = new URIBuilder(url);
        HttpDelete request = new HttpDelete(urlBuilder.build());
        this.setHeaderToRequest(headers, (HttpRequestBase)request);
        this.httpInvoke((HttpRequestBase)request);
    }

    public boolean exists(String bucketName, String filePath) throws URISyntaxException, IOException {
        String url = String.format(PLACEHOLDER, this.serverUrl, bucketName, filePath);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.authContext.auth(new AuthInfo(url, headers, this.accessKey, this.secretKey, "HEAD", null));
        URIBuilder urlBuilder = new URIBuilder(url);
        HttpHead request = new HttpHead(urlBuilder.build());
        this.setHeaderToRequest(headers, (HttpRequestBase)request);
        try (CloseableHttpResponse response = this.doHttpInvoke((HttpRequestBase)request);){
            if (this.isHttpNotOk(response)) {
                if (response.getStatusLine().getStatusCode() == 404) {
                    boolean bl = false;
                    return bl;
                }
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{response.getStatusLine().getReasonPhrase()});
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void close() throws IOException {
    }

    public CloseableHttpResponse doHttpInvoke(HttpRequestBase request) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectionTimeOut).setSocketTimeout(this.socketTimeout).build();
        request.setConfig(requestConfig);
        CloseableHttpResponse res = httpClient.execute((HttpUriRequest)request);
        httpClient.close();
        return res;
    }

    public CloseableHttpResponse doHttpInvokeNoclose(HttpRequestBase request) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectionTimeOut).setSocketTimeout(this.socketTimeout).build();
        request.setConfig(requestConfig);
        return httpClient.execute((HttpUriRequest)request);
    }

    public boolean isHttpNotOk(CloseableHttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        return code < 200 || code > 299;
    }
}

