/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filestorage.s3.util;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.apache.commons.lang.StringUtils;

public class URLUtils {
    public static ValidUrl getValidUrl(String url) {
        int splitIndex = (url = URLUtils.getValidFilePath(url)).indexOf(47);
        if (splitIndex < 0) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{"invalid url, should be {bucket}/{filePath}"});
        }
        String bucketName = url.substring(0, splitIndex);
        String filePath = url.substring(splitIndex + 1);
        if (StringUtils.isBlank((String)bucketName) || StringUtils.isBlank((String)filePath)) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{"bucketName or filePath should not be empty"});
        }
        return new ValidUrl(bucketName, filePath);
    }

    public static String getValidFilePath(String filePath) {
        return filePath.charAt(0) == '/' ? filePath.substring(1) : filePath;
    }

    public static class ValidUrl {
        private String bucketName;
        private String filePath;

        public ValidUrl(String bucketName, String filePath) {
            this.bucketName = bucketName;
            this.filePath = filePath;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getFilePath() {
            return URLUtils.getValidFilePath(this.filePath);
        }
    }
}

