/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.instance.Instance;
import kd.sdk.kingscript.debug.callchain.DebugCallSpan;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.debug.constant.KingScriptServiceConstant;
import kd.sdk.kingscript.debug.util.KingScriptUtil;
import kd.sdk.kingscript.lib.ScriptPathFormat;
import kd.sdk.kingscript.util.JsonUtil;
import kd.sdk.kingscript.util.Tuple;
import redis.clients.jedis.util.SafeEncoder;

public class RedisDebugInfoRegistryImpl
implements DebugInfoRegistry {
    private DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("kingscript");
    private static final String SCRIPT_PATH = "scriptPath";
    private static final String ENGINE_POOL_NAME = "enginePoolName";
    private static final String SESSION_ID = "sessionId";
    private static final String REQUEST_ENGINE_ROUND = "requestEngineRound";
    private static final String ECHO_COMMAND = "echoCommand";
    private static final String NEXT_SID = "nextSid";
    private static final String DISABLE = "debugInfoRegistry_disable";
    private static final String DEBUG_REPLAY_MESSAGE = "debugReplayMessage";
    private static final String RUNTIME_CONTEXT_ID = "runtimeContextId";
    private static final String ENV = "env";
    private static final String CALL_SPAN = "callSpan";
    private static final String KEEP_ALIVE = "keepAlive";
    private static final String KEEP_ALIVE_DEBUGID_LIST = "keepAliveDebugIdList";

    public void register(String debugId, String[] scriptPaths, String enginePoolName, String sessionId, String userName) {
        HashMap<byte[], byte[]> hsetValueMap = new HashMap<byte[], byte[]>();
        hsetValueMap.put(SafeEncoder.encode((String)SCRIPT_PATH), KingScriptUtil.encode(scriptPaths));
        hsetValueMap.put(SafeEncoder.encode((String)ENGINE_POOL_NAME), KingScriptUtil.encode(enginePoolName));
        hsetValueMap.put(SafeEncoder.encode((String)SESSION_ID), KingScriptUtil.encode(sessionId));
        this.cache.hmset(debugId, hsetValueMap, KingScriptServiceConstant.TIMEOUT);
        for (String scriptPath : scriptPaths) {
            String uniqueKey = this.genKey(enginePoolName, scriptPath, sessionId);
            this.cache.put(uniqueKey, (Object)debugId, KingScriptServiceConstant.TIMEOUT);
            String scriptPathKey = Instance.getClusterName() + '\b' + ScriptPathFormat.format((String)scriptPath);
            this.cache.put(scriptPathKey, (Object)(debugId + '\b' + userName), 86400);
        }
    }

    public boolean hasRegistered(String debugId) {
        byte[] bytes = this.cache.hget(debugId, SafeEncoder.encode((String)ENGINE_POOL_NAME));
        return bytes != null && bytes.length > 0;
    }

    public void setEnv(String debugId, Map<String, String> env) {
        this.cache.remove(debugId, ENV);
        this.cache.hset(debugId, SafeEncoder.encode((String)ENV), KingScriptUtil.encode(env), KingScriptServiceConstant.TIMEOUT);
    }

    public Map<String, String> getEnv(String debugId) {
        byte[] hget = this.cache.hget(debugId, SafeEncoder.encode((String)ENV));
        if (hget == null || hget.length == 0) {
            return Collections.emptyMap();
        }
        return (Map)KingScriptUtil.decode(hget);
    }

    public String findDebugId(String scriptPath, String enginePoolName, String sessionId) {
        return (String)this.cache.get(this.genKey(enginePoolName, scriptPath, sessionId));
    }

    public String getDebuggingInfo(String scriptPath) {
        int p;
        String scriptPathKey = Instance.getClusterName() + '\b' + ScriptPathFormat.format((String)scriptPath);
        String s = (String)this.cache.get(scriptPathKey);
        if (s != null && (p = s.indexOf(8)) != -1) {
            String debugId = s.substring(0, p);
            String userName = s.substring(p + 1);
            if (!this.isDisabled(debugId)) {
                return "Current debugging user: " + userName;
            }
        }
        return null;
    }

    public String findEnginePoolName(String debugId) {
        byte[] poolNameByteArray = this.cache.hget(debugId, SafeEncoder.encode((String)ENGINE_POOL_NAME));
        if (poolNameByteArray == null || poolNameByteArray.length == 0) {
            return null;
        }
        return (String)KingScriptUtil.decode(poolNameByteArray);
    }

    public void unRegister(String debugId) {
        Map map = this.cache.hgetAll(debugId);
        if (map != null && map.size() > 0) {
            String enginePoolName = null;
            String[] scriptPaths = null;
            String sessionId = null;
            for (Map.Entry next : map.entrySet()) {
                String key = SafeEncoder.encode((byte[])((byte[])next.getKey()));
                if (ENGINE_POOL_NAME.equalsIgnoreCase(key)) {
                    enginePoolName = (String)KingScriptUtil.decode((byte[])next.getValue());
                    continue;
                }
                if (SCRIPT_PATH.equalsIgnoreCase(key)) {
                    scriptPaths = (String[])KingScriptUtil.decode((byte[])next.getValue());
                    continue;
                }
                if (SESSION_ID.equalsIgnoreCase(key)) {
                    sessionId = (String)KingScriptUtil.decode((byte[])next.getValue());
                    continue;
                }
                if (enginePoolName == null || scriptPaths == null || sessionId == null) continue;
                break;
            }
            this.cache.remove(debugId);
            if (scriptPaths != null && scriptPaths.length > 0 && sessionId != null && sessionId.length() > 0) {
                for (String scriptPath : scriptPaths) {
                    this.cache.remove(this.genKey(enginePoolName, scriptPath, sessionId));
                }
            }
        }
        this.removeKeepAlive(debugId);
        this.cache.remove(debugId + '\b' + REQUEST_ENGINE_ROUND);
        this.cache.remove(debugId + '\b' + NEXT_SID);
        this.cache.remove(debugId + '\b' + DEBUG_REPLAY_MESSAGE);
        this.cache.remove(debugId + '\b' + CALL_SPAN);
        this.cache.remove(debugId + '\b' + ECHO_COMMAND);
    }

    public boolean isDisabled(String debugId) {
        String[] setValues = this.cache.getSetValues(DISABLE);
        if (setValues == null || setValues.length == 0) {
            return false;
        }
        for (String value : setValues) {
            if (!value.equals(debugId)) continue;
            return true;
        }
        return false;
    }

    public void setDisable(String debugId) {
        this.cache.addToSet(DISABLE, new String[]{debugId}, 86400);
    }

    public boolean isEchoCommand(String debugId) {
        return "1".equals(this.cache.get(debugId + '\b' + ECHO_COMMAND));
    }

    public void setEchoCommand(String debugId, boolean echo) {
        this.cache.put(debugId + '\b' + ECHO_COMMAND, (Object)(echo ? "1" : "0"), KingScriptServiceConstant.TIMEOUT);
    }

    public void addDebugCallSpan(String debugId, DebugCallSpan span) {
        this.cache.addToSet(debugId + '\b' + CALL_SPAN, new String[]{JsonUtil.toJSONString((Object)span)});
    }

    public List<DebugCallSpan> getDebugCallSpanList(String debugId) {
        String[] callSpanStrArray = this.cache.getSetValues(debugId + '\b' + CALL_SPAN);
        if (callSpanStrArray == null || callSpanStrArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<DebugCallSpan> callSpan = new ArrayList<DebugCallSpan>(callSpanStrArray.length);
        for (String callSpanStr : callSpanStrArray) {
            callSpan.add((DebugCallSpan)JsonUtil.parseObject((String)callSpanStr, DebugCallSpan.class));
        }
        return callSpan;
    }

    public Tuple<Long, Long> getKeepAlive(String debugId) {
        byte[] bs = this.cache.hget(debugId, SafeEncoder.encode((String)KEEP_ALIVE));
        if (bs == null || bs.length == 0) {
            return null;
        }
        Long[] ls = (Long[])KingScriptUtil.decode(bs);
        return new Tuple((Object)ls[0], (Object)ls[1]);
    }

    public void setKeepAlive(String debugId, Tuple<Long, Long> keepAlive) {
        this.cache.hset(debugId, SafeEncoder.encode((String)KEEP_ALIVE), KingScriptUtil.encode(new Long[]{(Long)keepAlive.getKey(), (Long)keepAlive.getValue()}), KingScriptServiceConstant.TIMEOUT);
        this.cache.addToSet(KEEP_ALIVE_DEBUGID_LIST, new String[]{debugId});
    }

    public List<String> getKeepAliveDebugIdList() {
        return Arrays.asList(this.cache.getSetValues(KEEP_ALIVE_DEBUGID_LIST));
    }

    public void removeKeepAlive(String debugId) {
        this.cache.removeSetValues(KEEP_ALIVE_DEBUGID_LIST, new String[]{debugId});
    }

    public int incRequestEngineRound(String debugId) {
        return (int)this.cache.inc(debugId + '\b' + REQUEST_ENGINE_ROUND, KingScriptServiceConstant.TIMEOUT);
    }

    public int getRequestEngineRound(String debugId) {
        String roundStr = (String)this.cache.get(debugId + '\b' + REQUEST_ENGINE_ROUND);
        if (roundStr == null || roundStr.length() == 0) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(roundStr);
    }

    public void removeThenAddReplayMessage(String debugId, String method, String requestMessage) {
        this.removeReplayMessage(debugId, method);
        this.cache.hset(debugId + '\b' + DEBUG_REPLAY_MESSAGE, SafeEncoder.encode((String)method), KingScriptUtil.encode(requestMessage), KingScriptServiceConstant.TIMEOUT);
    }

    public void removeReplayMessage(String debugId, String method) {
        this.cache.remove(debugId + '\b' + DEBUG_REPLAY_MESSAGE, method);
    }

    public List<String> getReplayMessageList(String debugId) {
        Map messageByteMap = this.cache.hgetAll(debugId + '\b' + DEBUG_REPLAY_MESSAGE);
        if (messageByteMap == null || messageByteMap.size() == 0) {
            return Collections.emptyList();
        }
        Collection values = messageByteMap.values();
        ArrayList<String> messages = new ArrayList<String>(values.size());
        for (byte[] value : values) {
            messages.add((String)KingScriptUtil.decode(value));
        }
        return messages;
    }

    public long nextSID(String debugId) {
        return this.cache.inc(debugId + '\b' + NEXT_SID, KingScriptServiceConstant.TIMEOUT);
    }

    public void setSID(String debugId, long sid) {
        this.cache.put(debugId + '\b' + NEXT_SID, (Object)String.valueOf(sid), KingScriptServiceConstant.TIMEOUT);
    }

    public void setRuntimeExecutionContextId(String debugId, long contextId) {
        this.cache.hset(debugId, SafeEncoder.encode((String)RUNTIME_CONTEXT_ID), KingScriptUtil.encode(contextId), KingScriptServiceConstant.TIMEOUT);
    }

    public long getRuntimeExecutionContextId(String debugId) {
        byte[] contextIdByte = this.cache.hget(debugId, SafeEncoder.encode((String)RUNTIME_CONTEXT_ID));
        if (contextIdByte == null || contextIdByte.length == 0) {
            return 0L;
        }
        return (Long)KingScriptUtil.decode(contextIdByte);
    }

    public void removeRuntimeExecutionContextId(String debugId) {
        this.cache.remove(debugId, RUNTIME_CONTEXT_ID);
    }

    public void setScriptId(String debugId, String scriptPath, String scriptId) {
        this.cache.hset(debugId, SafeEncoder.encode((String)scriptPath), KingScriptUtil.encode(scriptId), KingScriptServiceConstant.TIMEOUT);
        this.cache.hset(debugId, SafeEncoder.encode((String)scriptId), KingScriptUtil.encode(scriptPath), KingScriptServiceConstant.TIMEOUT);
    }

    public String getScriptId(String debugId, String scriptPath) {
        byte[] scriptIdByte = this.cache.hget(debugId, SafeEncoder.encode((String)scriptPath));
        if (scriptIdByte == null || scriptIdByte.length == 0) {
            return null;
        }
        return (String)KingScriptUtil.decode(scriptIdByte);
    }

    public String getScriptPath(String debugId, String scriptId) {
        byte[] scriptPath = this.cache.hget(debugId, SafeEncoder.encode((String)scriptId));
        if (scriptPath == null || scriptPath.length == 0) {
            return null;
        }
        return (String)KingScriptUtil.decode(scriptPath);
    }

    private String genKey(String enginePoolName, String scriptPath, String sessionId) {
        return enginePoolName + '\b' + ScriptPathFormat.format((String)scriptPath) + '\b' + sessionId;
    }
}

