/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.ws.registry;

import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.sdk.kingscript.debug.constant.KingScriptServiceConstant;
import kd.sdk.kingscript.debug.util.KingScriptUtil;
import kd.sdk.kingscript.debug.ws.registry.WsClientRegistryStore;
import redis.clients.jedis.util.SafeEncoder;

public class RedisWsClientRegistryStoreImpl
implements WsClientRegistryStore {
    private DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("kingscript");
    private static final String CLIENT_REGISTRY = "clientRegistry";
    private static final String WS_URL = "wsUrl";
    private static final String WS_IP = "wsIp";

    public String getWsUrl(String debugId) {
        return this.get(debugId, WS_URL);
    }

    public String getIp(String debugId) {
        return this.get(debugId, WS_IP);
    }

    public void set(String debugId, String wsUrl, String ip) {
        HashMap<byte[], byte[]> valueMap = new HashMap<byte[], byte[]>();
        valueMap.put(SafeEncoder.encode((String)WS_URL), KingScriptUtil.encode(wsUrl));
        valueMap.put(SafeEncoder.encode((String)WS_IP), KingScriptUtil.encode(ip));
        this.cache.hmset(debugId + '\b' + CLIENT_REGISTRY, valueMap, KingScriptServiceConstant.TIMEOUT);
    }

    public void remove(String debugId) {
        this.cache.remove(debugId + '\b' + CLIENT_REGISTRY);
    }

    private String get(String debugId, String fieldKey) {
        byte[] byteValue = this.cache.hget(debugId + '\b' + CLIENT_REGISTRY, SafeEncoder.encode((String)fieldKey));
        if (byteValue == null || byteValue.length == 0) {
            return null;
        }
        return (String)KingScriptUtil.decode(byteValue);
    }
}

