/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.featureopration;

import com.google.common.util.concurrent.RateLimiter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.encrypt.Encrypters;
import kd.bos.government.featureopration.FeatureOperationData;
import kd.bos.government.featureopration.FeatureOperationDataCollector;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaCollectorImpl
implements FeatureOperationDataCollector {
    private static final Log log = LogFactory.getLog(KafkaCollectorImpl.class);
    private static final String KEY_SCRIPT_DATA_KAFKA_URL = "script.data.collect.kafka.url";
    private static final String KEY_SCRIPT_DATA_KAFKA_U = "script.data.collect.kafka.user";
    private static final String KEY_SCRIPT_DATA_KAFKA_P = "script.data.collect.kafka.pwd";
    private static final String KEY_SCRIPT_DATA_KAFKA_TOPIC = "script.data.collect.kafka.topic";
    private static String scriptTopic = System.getProperty("script.data.collect.kafka.topic", "bos_script");
    private static KafkaProducer scriptProducer = KafkaCollectorImpl.getScriptProducer();
    private static final String KEY_KAFKA_URL = "feature.operation.data.collect.kafka.url";
    private static final String KEY_KAFKA_TOPIC = "feature.operation.data.collect.kafka.topic";
    private static final String KEY_KAFKA_US = "feature.operation.data.collect.kafka.user";
    private static final String KEY_KAFKA_PD = "feature.operation.data.collect.kafka.pwd";
    private static final String KEY_INTARVAL = "feature.operation.data.collect.kafka.interval";
    private static final String KEY_MAP_MAXSIZE = "feature.operation.data.collect.kafka.map.max";
    private static final String KEY_CLEAN_PERIOD = "feature.operation.data.collect.kafka.clean.period";
    private static final String BLOCK_MS = "feature.operation.data.collect.kafka.maxblockms";
    private static final String REQUEST_TIMEOUT = "feature.operation.data.collect.kafka.requesttimeout";
    private static final String DELIVERY_TIMEOUT = "feature.operation.data.collect.kafka.deliverytimeout";
    private static final Map<String, Long> eventReportTimeMap = new ConcurrentHashMap<String, Long>(1);
    private static volatile KafkaProducer<String, String> producer = null;
    private static final AtomicBoolean kafkaActive = new AtomicBoolean(true);
    private static String topic;
    private static Map<String, String> instanceNumberMap;
    private static long lastClearTime_instanceMap;
    private static Class<?> aClass;
    RateLimiter rateLimiter = RateLimiter.create((double)10000.0);

    private static void cleanExpiredEvents() {
        long num = 0L;
        for (Map.Entry<String, Long> entry : eventReportTimeMap.entrySet()) {
            if (System.currentTimeMillis() - entry.getValue() <= Long.parseLong(System.getProperty(KEY_INTARVAL, "60000"))) continue;
            ++num;
            eventReportTimeMap.remove(entry.getKey());
        }
        log.info(String.format("clean success, num: %s, currentsize: %s", num, eventReportTimeMap.size()));
    }

    private static void kafkaConnectDetect() {
        try {
            if (!kafkaActive.get()) {
                producer.partitionsFor(topic);
                kafkaActive.set(true);
            }
        }
        catch (Exception e) {
            log.warn("kafka Connect failed:", (Throwable)e);
        }
        log.info("kafkaActive: " + kafkaActive.get());
    }

    @Override
    public void record(FeatureOperationData data) {
        try {
            if (!kafkaActive.get() || producer == null || data == null) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)System.getProperty(KEY_KAFKA_URL))) {
                return;
            }
            String prodInstCode = KafkaCollectorImpl.getprodInstCode();
            if (StringUtils.isEmpty((CharSequence)prodInstCode)) {
                log.warn("instanceNumber is empty");
                return;
            }
            if (StringUtils.isEmpty((CharSequence)data.getInstanceNumber())) {
                data.setInstanceNumber(prodInstCode);
            }
            String eventCode = data.getEventCode();
            String instanceNumber = data.getInstanceNumber();
            String limitKey = eventCode + "_" + instanceNumber;
            if (StringUtils.isEmpty((CharSequence)eventCode) || this.isLimit(limitKey)) {
                return;
            }
            eventReportTimeMap.put(limitKey, System.currentTimeMillis());
            String dataJsonStr = KafkaCollectorImpl.toJson(data);
            ProducerRecord producerRecord = new ProducerRecord(topic, (Object)dataJsonStr);
            producer.send(producerRecord, (metadata, exception) -> {
                if (exception != null) {
                    kafkaActive.set(false);
                    log.warn("KafkaReporter error:", (Throwable)exception);
                }
            });
        }
        catch (Exception e) {
            log.warn("KafkaReporter error:", (Throwable)e);
        }
    }

    @Override
    public void _reportScriptData(String jsonStr) {
        if (scriptProducer == null) {
            log.info("scriptProducer is null");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)jsonStr) || jsonStr.length() > 5000) {
            log.info("jsonStr is null or length > 5000");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty(KEY_SCRIPT_DATA_KAFKA_URL))) {
            log.info("script.data.collect.kafka.url is empty");
            return;
        }
        if (!this.rateLimiter.tryAcquire()) {
            log.info("rateLimit");
            return;
        }
        try {
            ProducerRecord scriptRecord = new ProducerRecord(scriptTopic, (Object)jsonStr);
            scriptProducer.send(scriptRecord, (metadata, exception) -> {
                if (exception != null) {
                    log.warn("send error", (Throwable)exception);
                }
            });
        }
        catch (Exception e) {
            log.error("send error", (Throwable)e);
        }
    }

    private static void initKafkaProducer() {
        String url = System.getProperty(KEY_KAFKA_URL);
        if (StringUtils.isEmpty((CharSequence)url)) {
            log.info("kafka url is empty");
            return;
        }
        String user = KafkaCollectorImpl.getEncrypterStr(System.getProperty(KEY_KAFKA_US));
        String pwd = KafkaCollectorImpl.getEncrypterStr(System.getProperty(KEY_KAFKA_PD));
        Properties properties = new Properties();
        properties.put("bootstrap.servers", url);
        properties.setProperty("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        properties.setProperty("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        properties.put("acks", "0");
        properties.put("retries", (Object)0);
        String maxBlockms = System.getProperty(BLOCK_MS, "500");
        String requestTimeout = System.getProperty(REQUEST_TIMEOUT, "500");
        String deliveryTimeout = System.getProperty(DELIVERY_TIMEOUT, "500");
        properties.put("max.block.ms", maxBlockms);
        properties.put("request.timeout.ms", requestTimeout);
        properties.put("delivery.timeout.ms", deliveryTimeout);
        if (user != null && pwd != null) {
            String config = "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + user + "\" password=\"" + pwd + "\";";
            properties.setProperty("sasl.jaas.config", config);
            properties.setProperty("sasl.mechanism", "PLAIN");
            properties.setProperty("security.protocol", "SASL_PLAINTEXT");
        }
        producer = new KafkaProducer(properties);
    }

    private static String getEncrypterStr(String str) {
        if (str != null) {
            str = Encrypters.decode((String)str);
        }
        return str;
    }

    private boolean isLimit(String limitKey) {
        if (eventReportTimeMap.containsKey(limitKey)) {
            long lastReportTime;
            long interval = Long.parseLong(System.getProperty(KEY_INTARVAL, "60000"));
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - (lastReportTime = eventReportTimeMap.get(limitKey).longValue()) < interval) {
                return true;
            }
        }
        if (!eventReportTimeMap.containsKey(limitKey) && eventReportTimeMap.size() >= Integer.parseInt(System.getProperty(KEY_MAP_MAXSIZE, "10000"))) {
            log.info("Over size, skip");
            return true;
        }
        return false;
    }

    public static String toJson(FeatureOperationData data) {
        if (data == null) {
            return "{}";
        }
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("{");
        KafkaCollectorImpl.appendJsonField(jsonBuilder, "eventCode", data.getEventCode(), true);
        KafkaCollectorImpl.appendJsonField(jsonBuilder, "zonedDateTime", data.getZonedDateTime(), true);
        KafkaCollectorImpl.appendJsonField(jsonBuilder, "description", data.getDescription(), true);
        KafkaCollectorImpl.appendJsonField(jsonBuilder, "instanceNumber", data.getInstanceNumber(), false);
        jsonBuilder.append("}");
        log.debug("jsonStr:{}", (Object)jsonBuilder.toString());
        return jsonBuilder.toString();
    }

    private static void appendJsonField(StringBuilder builder, String fieldName, String value, boolean appendComma) {
        builder.append("\"").append(fieldName).append("\":\"").append(KafkaCollectorImpl.escapeJsonString(value)).append("\"");
        if (appendComma) {
            builder.append(",");
        }
    }

    private static String escapeJsonString(String input) {
        if (input == null) {
            return "";
        }
        StringBuilder escaped = new StringBuilder();
        block9: for (char c : input.toCharArray()) {
            switch (c) {
                case '\"': {
                    escaped.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    escaped.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    escaped.append("\\b");
                    continue block9;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block9;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block9;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block9;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block9;
                }
                default: {
                    if (c <= '\u001f') {
                        escaped.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    escaped.append(c);
                }
            }
        }
        return escaped.toString();
    }

    private static String getprodInstCode() {
        RequestContext rc = RequestContext.get();
        String key = rc.getTenantId() + "_" + rc.getAccountId();
        if (!instanceNumberMap.containsKey(key)) {
            try {
                Map productInfo;
                Method getProductInfos = aClass.getDeclaredMethod("getProductInfos", new Class[0]);
                List productInfos = (List)getProductInfos.invoke(null, new Object[0]);
                if (productInfos != null && !productInfos.isEmpty() && (productInfo = (Map)productInfos.get(0)) != null && productInfo.containsKey("prodInstCode")) {
                    instanceNumberMap.put(key, (String)productInfo.get("prodInstCode"));
                }
            }
            catch (Exception e) {
                log.warn("get prodInstCode error:", (Throwable)e);
            }
        }
        return instanceNumberMap.get(key);
    }

    private static KafkaProducer getScriptProducer() {
        try {
            String url = System.getProperty(KEY_SCRIPT_DATA_KAFKA_URL);
            if (StringUtils.isEmpty((CharSequence)url)) {
                log.info("script data kafka url is empty");
                return null;
            }
            String user = KafkaCollectorImpl.getEncrypterStr(System.getProperty(KEY_SCRIPT_DATA_KAFKA_U));
            String pwd = KafkaCollectorImpl.getEncrypterStr(System.getProperty(KEY_SCRIPT_DATA_KAFKA_P));
            Properties properties = new Properties();
            properties.put("bootstrap.servers", url);
            properties.setProperty("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            properties.setProperty("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            properties.put("acks", "0");
            properties.put("retries", (Object)0);
            String maxBlockms = System.getProperty(BLOCK_MS, "500");
            String requestTimeout = System.getProperty(REQUEST_TIMEOUT, "500");
            String deliveryTimeout = System.getProperty(DELIVERY_TIMEOUT, "500");
            properties.put("max.block.ms", maxBlockms);
            properties.put("request.timeout.ms", requestTimeout);
            properties.put("delivery.timeout.ms", deliveryTimeout);
            if (user != null && pwd != null) {
                String config = "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + user + "\" password=\"" + pwd + "\";";
                properties.setProperty("sasl.jaas.config", config);
                properties.setProperty("sasl.mechanism", "PLAIN");
                properties.setProperty("security.protocol", "SASL_PLAINTEXT");
            }
            return new KafkaProducer(properties);
        }
        catch (Exception e) {
            log.error("getScriptProducer error", (Throwable)e);
            return null;
        }
    }

    static {
        instanceNumberMap = new ConcurrentHashMap<String, String>();
        lastClearTime_instanceMap = 0L;
        try {
            aClass = Class.forName("kd.bos.servicehelper.license.LicenseServiceHelper");
            topic = System.getProperty(KEY_KAFKA_TOPIC, "feature_operation");
            ConfigurationUtil.observeChange((String)KEY_KAFKA_URL, (key, newValue) -> KafkaCollectorImpl.initKafkaProducer());
            ConfigurationUtil.observeChange((String)KEY_KAFKA_TOPIC, (key, newValue) -> {
                topic = System.getProperty(KEY_KAFKA_TOPIC, "feature_operation");
                KafkaCollectorImpl.initKafkaProducer();
            });
            ConfigurationUtil.observeChange((String)KEY_KAFKA_US, (key, newValue) -> KafkaCollectorImpl.initKafkaProducer());
            ConfigurationUtil.observeChange((String)KEY_KAFKA_PD, (key, newValue) -> KafkaCollectorImpl.initKafkaProducer());
            ConfigurationUtil.observeChange((String)KEY_SCRIPT_DATA_KAFKA_TOPIC, (key, newValue) -> {
                scriptTopic = System.getProperty(KEY_SCRIPT_DATA_KAFKA_TOPIC, "bos_script");
            });
            KafkaCollectorImpl.initKafkaProducer();
        }
        catch (Exception e) {
            log.warn("Error observing configuration changes", (Throwable)e);
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    KafkaCollectorImpl.kafkaConnectDetect();
                    KafkaCollectorImpl.cleanExpiredEvents();
                    if (System.currentTimeMillis() - lastClearTime_instanceMap > 3600000L) {
                        instanceNumberMap.clear();
                        lastClearTime_instanceMap = System.currentTimeMillis();
                    }
                }
                catch (Exception e) {
                    log.warn("Error TimerTask:", (Throwable)e);
                }
            }
        };
        Timer timer = new Timer("KafkaCollectorImpl-Daemon");
        int periodMin = Integer.parseInt(System.getProperty(KEY_CLEAN_PERIOD, "1"));
        timer.schedule(task, 1000L, 60000L * (long)periodMin);
    }
}

