/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.metadata.db;

import java.sql.Connection;
import java.sql.Driver;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.DBType;
import kd.bos.db.datasource.DataSourceURLs;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDException;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.ZooEventifyCenterFactory;
import kd.bos.government.metadata.db.DBConfig;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class DBHelper {
    private static final Log logger = LogFactory.getLog(DBHelper.class);
    private static final int TIMEOUT_DEFAULT = 3000;
    private static final String DB_CONFIG = "dbConfig";
    private static final Map<String, DBConfig> dbConfigMap = new ConcurrentHashMap<String, DBConfig>(1);

    public static boolean dbIsConfigured() {
        try {
            String isConfigured = System.getProperty("isDBConfigured");
            if (isConfigured == null) {
                if (DBHelper.getDbConfig() != null && !"false".equals(System.getProperty("isDBConfigured"))) {
                    System.setProperty("isDBConfigured", "true");
                    return true;
                }
                return false;
            }
            return Boolean.getBoolean("isDBConfigured");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static DBConfig getDbConfig() throws Exception {
        Boolean isConfFromMc = Boolean.parseBoolean(System.getProperty("monitor.db.mcconf.switch", "false"));
        DBConfig dbConfigInfo = dbConfigMap.get(DB_CONFIG);
        String jsonDbConfig = null;
        if (dbConfigInfo != null && !isConfFromMc.booleanValue()) {
            return dbConfigInfo;
        }
        try {
            ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
            jsonDbConfig = messageCenter.getNodeValue("gov.zk.url", DBHelper.getRootPath(), DB_CONFIG);
            if (jsonDbConfig != null) {
                dbConfigInfo = (DBConfig)((Object)JSONUtils.cast((String)jsonDbConfig, DBConfig.class, (boolean)true));
                dbConfigInfo.setPassword(Encrypters.decode((String)dbConfigInfo.getPassword()));
                if (!DBHelper.testConnection(dbConfigInfo)) {
                    return dbConfigInfo;
                }
                dbConfigMap.put(DB_CONFIG, dbConfigInfo);
                if (isConfFromMc.booleanValue() && dbConfigInfo.getIsModify()) {
                    DBHelper.updateToZk(dbConfigInfo, jsonDbConfig);
                }
            }
        }
        catch (Exception e) {
            dbConfigInfo = null;
            logger.warn("MonitorDbManager getDbConfig from zk exception", (Throwable)e);
        }
        if (dbConfigInfo == null && StringUtils.isNotEmpty((String)System.getProperty("mc.server.url"))) {
            logger.info("zk\u4e3a\u7a7a\uff0c\u518d\u6b21\u53bbMC\u4e2d\u67e5\u8be2\u5b58\u50a8\u5e93\u914d\u7f6e\uff01");
            HashMap<String, String> map = new HashMap<String, String>(3);
            map.put("DCID", Instance.getClusterName());
            map.put("key", "/runtime/monitor/config/dbConfig");
            try {
                jsonDbConfig = (String)MCApiUtil.getMCAPIInfo((String)"/kapi/app/mc/DataSaveGetService", (boolean)true, null, map);
                if (jsonDbConfig != null) {
                    dbConfigInfo = (DBConfig)((Object)JSONUtils.cast((String)jsonDbConfig, DBConfig.class, (boolean)true));
                    dbConfigInfo.setPassword(Encrypters.decode((String)dbConfigInfo.getPassword()));
                    if (!DBHelper.testConnection(dbConfigInfo)) {
                        return dbConfigInfo;
                    }
                }
            }
            catch (Exception e) {
                dbConfigInfo = null;
                if (e instanceof KDException) {
                    if (!"626".equals(((KDException)e).getErrorCode().getCode())) {
                        logger.error("The MonitorDbManager.getDbConfig query db error,errorMessage:" + ((KDException)e).getArgs(), (Throwable)e);
                    }
                } else {
                    logger.error("The MCReporter.saveMonitorDbConfig query db error,errorMessage:" + e.getMessage(), (Throwable)e);
                }
                logger.error((Throwable)e);
            }
            if (dbConfigInfo != null) {
                DBHelper.updateToZk(dbConfigInfo, jsonDbConfig);
            }
        }
        return dbConfigInfo;
    }

    private static void updateToZk(DBConfig dbConfigInfo, String jsonDbConfig) throws Exception {
        if (dbConfigInfo.getIsModify()) {
            dbConfigInfo.setIsModify(false);
            dbConfigInfo.setPassword(Encrypters.encode((String)dbConfigInfo.getPassword()));
            jsonDbConfig = JSONUtils.toString((Object)((Object)dbConfigInfo));
        }
        ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
        messageCenter.setNodeWithPersistent("gov.zk.url", DBHelper.getRootPath(), DB_CONFIG, jsonDbConfig);
    }

    public static String getPrimaryKeysQuerySql(DBType dbType, String tableName) {
        if (DBType.Oracle == dbType || DBType.DM == dbType || DBType.OceanBase_Oracle == dbType) {
            return "/*dialect*/select col.column_name from user_constraints con, user_cons_columns col where con.constraint_name = col.constraint_name and con.constraint_type='P' and col.table_name = '" + tableName.toUpperCase() + "' order by position";
        }
        if (DBType.MySQL == dbType || DBType.TDSQL == dbType || DBType.TiDB == dbType) {
            return "/*dialect*/select column_name from information_schema.key_column_usage where table_name = '" + tableName + "' and TABLE_SCHEMA = schema() and constraint_name= 'PRIMARY'";
        }
        if (DBType.PostgreSQL == dbType || DBType.GaussDB == dbType || DBType.KingBase == dbType || DBType.Vastbase == dbType || DBType.Gbase == dbType || DBType.Gauss200 == dbType) {
            return "/*dialect*/select kcu.column_name as key_column from information_schema.table_constraints tco join information_schema.key_column_usage kcu on kcu.constraint_name = tco.constraint_name and kcu.constraint_schema = tco.constraint_schema and kcu.constraint_name = tco.constraint_name where tco.constraint_type = 'PRIMARY KEY' and kcu.table_name = '" + tableName.toLowerCase() + "' order by kcu.ordinal_position";
        }
        if (DBType.SQLServer == dbType) {
            return "/*dialect*/select c.name from sysindexes i join sysindexkeys k on i.id = k.id and i.indid = k.indid join sysobjects o on i.id = o.id join syscolumns c on i.id=c.id and k.colid = c.colid where o.xtype = 'U' and exists(select 1 from sysobjects where xtype = 'PK' and name = i.name) and o.name= '" + tableName.toUpperCase() + '\'';
        }
        if (DBType.YasDB == dbType) {
            return "/*dialect*/select col.column_name from user_constraints con, user_cons_columns col where con.constraint_name = col.constraint_name and con.constraint_type='P' and col.table_name = '" + tableName.toUpperCase() + "'";
        }
        throw new RuntimeException("dbType " + dbType.name() + " not supported yet!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean testConnection(DBConfig dbConfigInfo) {
        try (Connection connection = DBHelper.getDBConnection(dbConfigInfo);){
            System.setProperty("isDBConfigured", "true");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.setProperty("isDBConfigured", "false");
            return false;
        }
    }

    public static String getRootPath() {
        return Instance.getClusterName() + "/runtime/monitor/config";
    }

    public static Connection getDBConnection(DBConfig dbConfig) throws Exception {
        Properties prop = DBHelper.getDBProperties(dbConfig);
        prop.setProperty("connectTimeout", String.valueOf(3000));
        prop.setProperty("socketTimeout", String.valueOf(3000));
        prop.setProperty("initialTimeout", String.valueOf(3000));
        Driver driver = (Driver)Class.forName(prop.getProperty("driverClassName")).newInstance();
        return driver.connect(prop.getProperty("url"), prop);
    }

    private static Properties getDBProperties(DBConfig dbConfig) {
        Properties prop = new Properties();
        prop.setProperty("driverClassName", DBHelper.getDriver(dbConfig.getEnumDbType()));
        prop.setProperty("url", DBHelper.getURL(dbConfig.getEnumDbType(), dbConfig.getIp(), dbConfig.getPort(), dbConfig.getDbName()));
        prop.setProperty("user", dbConfig.getUserName());
        prop.setProperty("password", dbConfig.getPassword());
        if (DBType.Oracle != dbConfig.getEnumDbType()) {
            prop.setProperty("database", dbConfig.getDbName());
        }
        return prop;
    }

    private static String getDriver(DBType dbType) {
        String driver;
        switch (dbType) {
            case Oracle: {
                driver = "oracle.jdbc.driver.OracleDriver";
                break;
            }
            case SQLServer: {
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                break;
            }
            case Gbase: {
                driver = "org.gbase.Driver";
                break;
            }
            case PostgreSQL: {
                driver = "org.postgresql.Driver";
                break;
            }
            case DM: {
                driver = "dm.jdbc.driver.DmDriver";
                break;
            }
            case KingBase: {
                driver = "com.kingbase8.Driver";
                break;
            }
            case TDSQL: {
                driver = "com.tencentcloud.tdsql.mysql.cj.jdbc.Driver";
                break;
            }
            case Vastbase: {
                driver = "cn.com.vastbase.Driver";
                break;
            }
            case YasDB: {
                driver = "com.yashandb.jdbc.Driver";
                break;
            }
            case GaussDB: {
                driver = "com.huawei.opengauss.jdbc.Driver";
                break;
            }
            case OceanBase_Oracle: {
                driver = "com.oceanbase.jdbc.Driver";
                break;
            }
            default: {
                driver = "com.mysql.cj.jdbc.Driver";
            }
        }
        return driver;
    }

    private static String getURL(DBType dbType, String ip, int port, String instance) {
        String url;
        if (StringUtils.isEmpty((String)instance)) {
            instance = "";
        }
        switch (dbType) {
            case Oracle: {
                url = "jdbc:oracle:thin:@" + ip + ":" + port + "/" + instance;
                break;
            }
            case SQLServer: {
                url = "jdbc:sqlserver://" + ip + ":" + port + ";DatabaseName=" + instance + (DataSourceURLs.sqlServerUnusedTLS ? ";encrypt=false;trustServerCertificate=true" : "");
                break;
            }
            case Gbase: {
                url = "jdbc:gbase://" + ip + ":" + port + "/" + instance;
                break;
            }
            case PostgreSQL: {
                url = "jdbc:postgresql://" + ip + ":" + port + "/" + instance;
                break;
            }
            case DM: {
                if (DBHelper.isCluster(ip)) {
                    url = "jdbc:dm://" + DataSourceURLs.dmClusterServerName + "?" + DataSourceURLs.dmClusterServerName + "=(" + ip + ":" + port + ")";
                    break;
                }
                url = "jdbc:dm://" + ip + ":" + port + "/" + instance;
                break;
            }
            case KingBase: {
                url = "jdbc:kingbase8://" + ip + ":" + port + "/" + instance;
                break;
            }
            case TDSQL: {
                if (DBHelper.isCluster(ip)) {
                    url = "jdbc:tdsql-mysql:loadbalance://" + ip + ":" + port + "/" + instance;
                    break;
                }
                url = "jdbc:tdsql-mysql://" + ip + ":" + port + "/" + instance;
                break;
            }
            case Vastbase: {
                url = "jdbc:vastbase://" + ip + ":" + port + "/" + instance;
                break;
            }
            case YasDB: {
                return "jdbc:yasdb://" + ip + ":" + port + "/" + instance;
            }
            case GaussDB: {
                return "jdbc:opengauss://" + ip + ":" + port + "/" + instance;
            }
            case OceanBase_Oracle: {
                return "jdbc:oceanbase://" + ip + ":" + port + "/" + instance;
            }
            default: {
                url = "jdbc:mysql://" + ip + ":" + port + "/" + instance;
            }
        }
        return url;
    }

    private static boolean isCluster(String ip) {
        return ip.contains(",");
    }

    public static String getDbUrl(DBConfig dbConfig) {
        DBType dbType = dbConfig.getEnumDbType();
        String ip = dbConfig.getIp();
        int port = dbConfig.getPort();
        String db = dbConfig.getDbName();
        boolean isCluster = DBHelper.isCluster(dbConfig.getIp());
        if (isCluster) {
            String clusterDbUrl = ip + ":" + port;
            return DataSourceURLs.genClusterUrl((DBType)dbType, (String)clusterDbUrl, (String)db);
        }
        return DataSourceURLs.genURL((DBType)dbType, (String)ip, (int)port, (String)db);
    }

    public static void clearCache() {
        dbConfigMap.clear();
    }
}

