/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.reporter;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.armor.transport.command.vo.NodeVo;
import kd.bos.govern.ExtensionGovernPoJo;
import kd.bos.govern.GovernPoJo;
import kd.bos.govern.StorageReporter;
import kd.bos.govern.StorageType;
import kd.bos.govern.eventdata.EventData;
import kd.bos.government.Constant;
import kd.bos.government.storage.StorageRequest;
import kd.bos.government.storage.StorageService;
import kd.bos.government.storage.impl.elasticsearch.ElasticsearchInsertStorageRequest;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.government.util.ElasticSearchUtil;
import kd.bos.metric.reporter.elasticsearch.MetricsPoJo;
import kd.bos.trace.reporter.apicall.APICallData;
import kd.bos.trace.reporter.sword.SwordSpan;
import kd.bos.trace.reporter.topology.TopologyData;
import kd.bos.trace.reporter.topology.TopologyServiceData;

public class ESReporter
implements StorageReporter {
    private static final String TYPE = "doc";
    private static final ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig();
    private static final Set<String> extendIndexPreSet = new HashSet<String>(2);

    public static Set<String> getExtendIndexPreSet() {
        return Collections.unmodifiableSet(extendIndexPreSet);
    }

    public void reporter(GovernPoJo object) {
        this.reporter(new ArrayList<GovernPoJo>(Collections.singletonList(object)));
    }

    public void reporter(List<GovernPoJo> objects) {
        ArrayList<StorageRequest> storageRequestList = new ArrayList<StorageRequest>(objects.size());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = dateFormat.format(new Date());
        int version = ElasticSearchUtil.getVersion(elasticsearchConfig);
        for (GovernPoJo obj : objects) {
            String indexPre;
            ElasticsearchInsertStorageRequest request;
            if (obj instanceof TopologyServiceData) {
                request = new ElasticsearchInsertStorageRequest(Constant.TOPOLOGY_SERVICE_PRE + format, version <= 6 ? TYPE : null).source(obj.data2map());
            } else if (obj instanceof TopologyData) {
                request = new ElasticsearchInsertStorageRequest(Constant.TOPOLOGY_PRE + format, version <= 6 ? TYPE : null).source(obj.data2map());
            } else if (obj instanceof APICallData) {
                request = new ElasticsearchInsertStorageRequest(Constant.API_CALL_DATA + format, version <= 6 ? TYPE : null).source(obj.data2map());
            } else if (obj instanceof NodeVo) {
                request = new ElasticsearchInsertStorageRequest(Constant.ARMOR_LINK_DATA + format, version <= 6 ? TYPE : null).source(obj.data2map());
            } else if (obj instanceof SwordSpan) {
                indexPre = System.getProperty("trace.sword.es.index", Constant.SWORD_SPAN_DATA);
                request = new ElasticsearchInsertStorageRequest(indexPre + format, version <= 6 ? TYPE : null).source(obj.data2map());
            } else if (obj instanceof MetricsPoJo) {
                request = new ElasticsearchInsertStorageRequest(Constant.METRIC_INDEX_PRE + format, version <= 6 ? TYPE : null).source(obj.data2map());
            } else if (obj instanceof ExtensionGovernPoJo) {
                indexPre = ((ExtensionGovernPoJo)obj).getIndexPrefix();
                extendIndexPreSet.add(indexPre);
                request = new ElasticsearchInsertStorageRequest(indexPre + format, version <= 6 ? TYPE : null).source(obj.data2map());
            } else {
                if (!(obj instanceof EventData)) continue;
                request = new ElasticsearchInsertStorageRequest(Constant.EVENT_DATA_INDEX_PRE + format, version <= 6 ? TYPE : null).source(obj.data2map());
            }
            storageRequestList.add(request);
        }
        StorageService.addRequest(StorageType.ELASTICSEARCH, storageRequestList);
    }
}

