/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.reporter;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.encrypt.Encrypters;
import kd.bos.govern.GovernPoJo;
import kd.bos.govern.StorageReporter;
import kd.bos.instance.Instance;
import kd.bos.kafka.IKafkaSender;
import kd.bos.kafka.KafkaFactory;
import kd.bos.kafka.enums.SerializerType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.reporter.sword.SwordSpan;
import kd.bos.util.JSONUtils;

public class KafkaReporter
implements StorageReporter {
    private static final Log log = LogFactory.getLog(KafkaReporter.class);
    private static final Map<String, IKafkaSender> senderMap = new ConcurrentHashMap<String, IKafkaSender>(1);
    private static final String LOG_KAFKA_URL = System.getProperty("bootstrap.servers");
    private static final String LOG_KAFKA_USER = System.getProperty("logKafkaUser");
    private static final String LOG_KAFKA_PWD = System.getProperty("logKafkaPwd");

    public void reporter(GovernPoJo object) {
        if (object instanceof SwordSpan) {
            this.reportSwordSpanToKafka(object);
        }
    }

    public void reporter(List<GovernPoJo> objects) {
        for (GovernPoJo object : objects) {
            if (!(object instanceof SwordSpan)) continue;
            this.reportSwordSpanToKafka(object);
        }
    }

    private void reportSwordSpanToKafka(Object object) {
        try {
            IKafkaSender swordSpanSender = senderMap.computeIfAbsent("swordSender", key -> {
                String swordUrl = System.getProperty("trace.reporter.sword.kafka.url", LOG_KAFKA_URL);
                String swordTopic = System.getProperty("trace.reporter.sword.kafka.topic", Instance.getClusterName() + "_trace_sword");
                String swordUser = this.getEncrypterStr(System.getProperty("trace.reporter.sword.kafka.user", LOG_KAFKA_USER));
                String swordPwd = this.getEncrypterStr(System.getProperty("trace.reporter.sword.kafka.pwd", LOG_KAFKA_PWD));
                return KafkaFactory.getSender((SerializerType)SerializerType.STRING, (String)swordUrl, (String)swordTopic, (String)swordUser, (String)swordPwd);
            });
            swordSpanSender.send((Object)JSONUtils.toString((Object)object));
        }
        catch (Exception e) {
            log.warn("KafkaReporter.reportSwordSpanToKafka error:", (Throwable)e);
        }
    }

    private String getEncrypterStr(String str) {
        if (str != null) {
            str = Encrypters.decode((String)str);
        }
        return str;
    }
}

