/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.reporter;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.exception.KDException;
import kd.bos.govern.GovernPoJo;
import kd.bos.govern.StorageReporter;
import kd.bos.government.metadata.db.DBConfig;
import kd.bos.instance.Instance;
import kd.bos.trace.reporter.apicall.APIMetaData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MCReporter
implements StorageReporter {
    private static final Log log = LogFactory.getLog(MCReporter.class);
    private static final String CLUSTER_NAME = Instance.getClusterName() + "apiMetadata";

    public void reporter(GovernPoJo object) {
        if (object instanceof APIMetaData) {
            this.saveAPIMetaData((APIMetaData)object);
        } else if (object instanceof DBConfig) {
            this.saveMonitorDbConfig((DBConfig)object);
        }
    }

    public void reporter(List<GovernPoJo> objects) {
        for (GovernPoJo object : objects) {
            if (object instanceof APIMetaData) {
                this.saveAPIMetaData((APIMetaData)object);
                continue;
            }
            if (!(object instanceof DBConfig)) continue;
            this.saveMonitorDbConfig((DBConfig)object);
        }
    }

    private void saveMonitorDbConfig(DBConfig dbConfig) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("DCID", Instance.getClusterName());
        map.put("key", "/runtime/monitor/config/dbConfig");
        map.put("value", JSON.toJSONString((Object)((Object)dbConfig)));
        try {
            MCApiUtil.getMCAPIInfo((String)"/kapi/app/mc/DataSaveSetService", (boolean)true, null, map);
        }
        catch (Exception e) {
            if (e instanceof KDException) {
                log.error((Object)("The apiMetadata's signature saving db error,errorMessage:" + ((KDException)e).getArgs()));
            } else {
                log.error((Object)("The apiMetadata's signature saving db error,errorMessage:" + e.getMessage()));
            }
            return;
        }
        log.info((Object)"The MCReporter.saveMonitorDbConfig saved mc successfully");
    }

    private void saveAPIMetaData(APIMetaData apiMetaData) {
        String signature = apiMetaData.getSignature();
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("DCID", CLUSTER_NAME);
        map.put("key", signature);
        Object obj = null;
        try {
            obj = MCApiUtil.getMCAPIInfo((String)"/kapi/app/mc/DataSaveGetService", (boolean)true, null, map);
        }
        catch (Exception e) {
            if (e instanceof KDException) {
                if (!"626".equals(((KDException)e).getErrorCode().getCode())) {
                    log.error((Object)("The apiMetadata's signature query db error,errorMessage:" + ((KDException)e).getArgs()));
                    return;
                }
            }
            log.error((Object)("The apiMetadata's signature query db error,errorMessage:" + e.getMessage()));
            return;
        }
        if (obj == null) {
            map.put("value", JSON.toJSONString((Object)apiMetaData));
            try {
                MCApiUtil.getMCAPIInfo((String)"/kapi/app/mc/DataSaveSetService", (boolean)true, null, map);
            }
            catch (Exception e) {
                if (e instanceof KDException) {
                    log.error((Object)("The apiMetadata's signature saving db error,errorMessage:" + ((KDException)e).getArgs()));
                } else {
                    log.error((Object)("The apiMetadata's signature saving db error,errorMessage:" + e.getMessage()));
                }
                return;
            }
            log.info((Object)("The apiMetadata's signature saved mc successfully, signature:" + signature));
        }
    }
}

