/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.storage.impl.elasticsearch;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TreeSet;
import kd.bos.government.Constant;
import kd.bos.government.storage.Storage;

public interface ElasticsearchClient
extends Storage {
    public static String[] getIndices(Date sdate, Date edate, String indexPre) {
        ImmutableSet betweenTime = new TreeSet();
        try {
            SimpleDateFormat outformat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar sCalendar = Calendar.getInstance();
            sCalendar.setTime(sdate);
            int year = sCalendar.get(1);
            int month = sCalendar.get(2);
            int day = sCalendar.get(5);
            sCalendar.set(year, month, day, 0, 0, 0);
            Calendar eCalendar = Calendar.getInstance();
            eCalendar.setTime(edate);
            year = eCalendar.get(1);
            month = eCalendar.get(2);
            day = eCalendar.get(5);
            eCalendar.set(year, month, day, 0, 0, 0);
            while (sCalendar.before(eCalendar)) {
                betweenTime.add(indexPre + outformat.format(sCalendar.getTime()));
                sCalendar.add(6, 1);
            }
            betweenTime.add(indexPre + outformat.format(eCalendar.getTime()));
            if (betweenTime.size() > Constant.SEARCH_RANGE_MAX) {
                betweenTime = ImmutableSet.copyOf((Iterable)Iterables.limit(betweenTime, (int)Constant.SEARCH_RANGE_MAX));
            }
        }
        catch (Exception e) {
            return betweenTime.toArray(new String[0]);
        }
        return betweenTime.toArray(new String[0]);
    }
}

