/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.storage.impl.elasticsearch;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import kd.bos.government.storage.StorageRequest;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.government.util.ElasticSearchUtil;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.VersionType;

public class ElasticsearchInsertStorageRequest
extends IndexRequest
implements StorageRequest {
    private static final ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig();

    public ElasticsearchInsertStorageRequest(String index, String type) {
        super(index, type);
    }

    public ElasticsearchInsertStorageRequest source(Map source) throws ElasticsearchGenerationException {
        super.source(source);
        return this;
    }

    public ElasticsearchInsertStorageRequest source(XContentBuilder sourceBuilder) {
        super.source(sourceBuilder);
        return this;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError((String)"index is missing", validationException);
        }
        if (ElasticSearchUtil.getVersion(elasticsearchConfig) <= 6 && this.type() == null) {
            validationException = ValidateActions.addValidationError((String)"type is missing", (ActionRequestValidationException)validationException);
        }
        if (this.source() == null) {
            validationException = ValidateActions.addValidationError((String)"source is missing", (ActionRequestValidationException)validationException);
        }
        if (this.getContentType() == null) {
            validationException = ValidateActions.addValidationError((String)"content type is missing", (ActionRequestValidationException)validationException);
        }
        long resolvedVersion = this.version();
        if (this.opType() == DocWriteRequest.OpType.CREATE) {
            if (this.versionType() != VersionType.INTERNAL) {
                validationException = ValidateActions.addValidationError((String)"create operations only support internal versioning. use index instead", (ActionRequestValidationException)validationException);
                return validationException;
            }
            if (resolvedVersion != -4L) {
                validationException = ValidateActions.addValidationError((String)"create operations do not support explicit versions. use index instead", (ActionRequestValidationException)validationException);
                return validationException;
            }
            if (this.ifSeqNo() != -2L || this.ifPrimaryTerm() != 0L) {
                validationException = ValidateActions.addValidationError((String)"create operations do not support compare and set. use index instead", (ActionRequestValidationException)validationException);
                return validationException;
            }
        }
        if (this.opType() != DocWriteRequest.OpType.INDEX && this.id() == null) {
            ValidateActions.addValidationError((String)("an id is required for a " + this.opType() + " operation"), (ActionRequestValidationException)validationException);
        }
        validationException = DocWriteRequest.validateSeqNoBasedCASParams((DocWriteRequest)this, (ActionRequestValidationException)validationException);
        if (this.id() != null && this.id().getBytes(StandardCharsets.UTF_8).length > 512) {
            validationException = ValidateActions.addValidationError((String)("id is too long, must be no longer than 512 bytes but was: " + this.id().getBytes(StandardCharsets.UTF_8).length), (ActionRequestValidationException)validationException);
        }
        if (this.id() == null && (this.versionType() != VersionType.INTERNAL || resolvedVersion != -3L)) {
            validationException = ValidateActions.addValidationError((String)"an id must be provided if version type or value are set", (ActionRequestValidationException)validationException);
        }
        if (this.getPipeline() != null && this.getPipeline().isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"pipeline cannot be an empty string", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

