/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.storage.impl.elasticsearch.client;

import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class ElasticsearchConfig {
    private static Log logger = LogFactory.getLog(ElasticsearchConfig.class);
    private String clusterName;
    private String ip;
    private int port;
    private String userName;
    private String password;
    private String type;
    private String schema;
    private String certPath;
    private String certPassword;

    public ElasticsearchConfig() {
        this.init();
    }

    public ElasticsearchConfig(String ip, int port, String userName, String password, String schema, String certPath, String certPassword) {
        this.ip = ip;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.schema = schema;
        this.certPath = certPath;
        this.certPassword = certPassword;
    }

    private final void init() {
        int portIdx;
        String url = this.getAndSetESConfig();
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        if (StringUtils.isNotEmpty((String)this.password)) {
            this.password = Encrypters.decode((String)this.password);
        }
        String text = "";
        int schemeIdx = url.indexOf("://");
        if (schemeIdx > 0) {
            text = url.substring(schemeIdx + 3);
        }
        if ((portIdx = text.lastIndexOf(":")) > 0) {
            try {
                this.port = Integer.parseInt(text.substring(portIdx + 1));
            }
            catch (NumberFormatException e) {
                logger.error("monitor.es.url parse exception ,check it ", (Throwable)e);
            }
            this.ip = text.substring(0, portIdx);
        }
        this.type = System.getProperty("monitor.es.client.type", "highLevel");
        if (!"highLevel".equalsIgnoreCase(this.type)) {
            this.clusterName = System.getProperty("monitor.es.clustername");
        }
    }

    private String getAndSetESConfig() {
        String url = System.getProperty("gov.reporter.es.url");
        this.schema = "http";
        if (StringUtils.isNotEmpty((String)url)) {
            if (url.endsWith("/")) {
                url = url.substring(0, url.lastIndexOf(47));
            }
            this.userName = System.getProperty("gov.reporter.es.user");
            this.password = System.getProperty("gov.reporter.es.pwd");
            boolean sslEnable = Boolean.getBoolean("gov.reporter.es.ssl.enable");
            if (sslEnable) {
                this.schema = "https";
                this.certPath = System.getProperty("gov.reporter.es.certificate.path");
                this.certPassword = System.getProperty("gov.reporter.es.certificate.password");
                if (StringUtils.isNotEmpty((String)this.certPassword)) {
                    this.certPassword = Encrypters.decode((String)this.certPassword);
                }
            }
            return url;
        }
        url = System.getProperty("monitor.es.url");
        if (StringUtils.isEmpty((String)url)) {
            logger.error("monitor elasticsearch url is empty.");
            return "";
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.lastIndexOf(47));
        }
        this.userName = System.getProperty("monitor.es.user");
        this.password = System.getProperty("monitor.es.password");
        boolean sslEnable = Boolean.getBoolean("monitor.es.ssl.enable");
        if (sslEnable) {
            this.schema = "https";
            this.certPath = System.getProperty("monitor.es.certificate.path");
            this.certPassword = System.getProperty("monitor.es.certificate.password");
            if (StringUtils.isNotEmpty((String)this.certPassword)) {
                this.certPassword = Encrypters.decode((String)this.certPassword);
            }
        }
        return url;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getType() {
        return this.type;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public String getCertPassword() {
        return this.certPassword;
    }
}

