/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.storage.impl.elasticsearch.client;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.framework.instance.ClusterInstances;
import kd.bos.government.Constant;
import kd.bos.government.reporter.ESReporter;
import kd.bos.government.storage.StorageRequest;
import kd.bos.government.storage.impl.elasticsearch.ElasticsearchClient;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.government.util.ElasticSearchUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.AvgAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.ParsedAvg;
import org.elasticsearch.search.aggregations.metrics.max.ParsedMax;
import org.elasticsearch.search.aggregations.metrics.sum.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.tophits.ParsedTopHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class HighLevelAccessClient
implements ElasticsearchClient {
    private static final String AGG_SRC_SERVICE = "agg_srcService";
    private static final String AGG_DESC_SERVICE = "agg_descService";
    private static final String AGG_SRC_SERVICE_TYPE = "agg_srcServiceType";
    private static final String AGG_DESC_SERVICE_TYPE = "agg_descServiceType";
    private static final String DURATION_MICROS = "durationMicros";
    private static final String APP_ID = "appId";
    private static final String TIMESTAMP = "timestamp";
    private static final String CLOUD = "cloud";
    private static final String SIGNATURE_KEYWORD = "signature.keyword";
    private static final String COLLECTION_TIME = "collectionTime";
    private static final String DURATION = "duration";
    private static final String CHILDREN = "children";
    private static final String PARENT_ID = "parentId";
    private static final String ID = "id";
    private static final String METRIC_SPLIT_SYMBOL = "-";
    private static final String METRIC_JVM = "kd.metrics.jvm.";
    private static final String METRIC_MEMORY_PRE = "kd.metrics.jvm.memory.";
    private static final String METRIC_GC = "kd.metrics.jvm.gc.";
    private static final String METRIC_SYSTEM = "kd.metrics.jvm.system.";
    private static final String USED = "used";
    private static final String MAX = "max";
    private static final String COMMITTED = "committed";
    private static final String NODE_PLACEHOLDER = "{#node#}";
    private static final String ONE_NODE_PLACEHOLDER = "1{#node#}";
    private static final String INSTANCE_PLACEHOLDER = "{#instance#}";
    private static final int AGG_QUERY_SIZE = 2000;
    private static final long unit = 0x100000L;
    private static final Log logger = LogFactory.getLog(HighLevelAccessClient.class);
    private static ElasticsearchConfig elasticsearchConfig;
    protected RestHighLevelClient esClient;
    private BulkProcessor bulkProcessor;
    private float position = 0.0f;

    public HighLevelAccessClient(ElasticsearchConfig elasticsearchConfig) {
        HighLevelAccessClient.elasticsearchConfig = elasticsearchConfig;
        this.init(elasticsearchConfig);
    }

    private void init(ElasticsearchConfig elasticsearchConfig) {
        try {
            SSLContext sslContext;
            String userName = elasticsearchConfig.getUserName();
            String password = elasticsearchConfig.getPassword();
            IOReactorConfig.Builder custom = IOReactorConfig.custom();
            IOReactorConfig.Builder.setDefaultMaxIoThreadCount((int)2);
            custom.setIoThreadCount(2);
            if ("https".equals(elasticsearchConfig.getSchema())) {
                if (StringUtils.isEmpty((String)elasticsearchConfig.getCertPath())) {
                    SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy());
                    sslContext = sslContextBuilder.build();
                } else {
                    Path trustStorePath = Paths.get(FileUtils.checkFileUrl((String)elasticsearchConfig.getCertPath()), new String[0]);
                    KeyStore trustStore = KeyStore.getInstance("pkcs12");
                    try (InputStream inputStream = Files.newInputStream(trustStorePath, new OpenOption[0]);){
                        trustStore.load(inputStream, elasticsearchConfig.getCertPassword().toCharArray());
                        SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial(trustStore, null);
                        sslContext = sslContextBuilder.build();
                    }
                }
            } else {
                sslContext = null;
            }
            if (userName != null && password != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
                this.esClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(elasticsearchConfig.getIp(), elasticsearchConfig.getPort(), elasticsearchConfig.getSchema())}).setHttpClientConfigCallback(arg_0 -> HighLevelAccessClient.lambda$init$0(sslContext, (CredentialsProvider)credentialsProvider, custom, arg_0)));
            } else {
                this.esClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(elasticsearchConfig.getIp(), elasticsearchConfig.getPort(), elasticsearchConfig.getSchema())}).setHttpClientConfigCallback(httpClientBuilder -> {
                    httpClientBuilder.disableAuthCaching();
                    httpClientBuilder.setSSLContext(sslContext);
                    httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    return httpClientBuilder.setDefaultIOReactorConfig(custom.build());
                }));
            }
            this.createBulkProcess();
        }
        catch (Exception e) {
            logger.error("init highLevelAccessClient error", (Throwable)e);
        }
    }

    private void createBulkProcess() {
        BulkProcessor.Listener listener = new BulkProcessor.Listener(){

            public void beforeBulk(long l, BulkRequest bulkRequest) {
            }

            public void afterBulk(long l, BulkRequest bulkRequest, BulkResponse bulkResponse) {
            }

            public void afterBulk(long l, BulkRequest bulkRequest, Throwable throwable) {
            }
        };
        BiConsumer<BulkRequest, ActionListener> consumer = (bulkRequest, bulkLister) -> this.esClient.bulkAsync(bulkRequest, RequestOptions.DEFAULT, bulkLister);
        this.bulkProcessor = BulkProcessor.builder(consumer, (BulkProcessor.Listener)listener).setBulkActions(1000).setBulkSize(new ByteSizeValue(10L, ByteSizeUnit.MB)).setFlushInterval(TimeValue.timeValueSeconds((long)3L)).setConcurrentRequests(3).setBackoffPolicy(BackoffPolicy.constantBackoff((TimeValue)TimeValue.timeValueMillis((long)100L), (int)0)).build();
    }

    @Override
    public void execute(List<StorageRequest> storageRequests) {
        BulkRequest bulkRequest = new BulkRequest();
        for (StorageRequest storageRequest : storageRequests) {
            bulkRequest.add((IndexRequest)storageRequest);
        }
        try {
            this.esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void asyncExecute(List<StorageRequest> storageRequests) {
        try {
            for (StorageRequest storageRequest : storageRequests) {
                this.bulkProcessor.add((IndexRequest)storageRequest);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<Map<String, Object>> queryTopology(Date from, Date to, String instance) {
        try {
            if (StringUtils.isEmpty((String)instance)) {
                return this.queryServices(from, to);
            }
        }
        catch (Exception e) {
            return Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    private List<Map<String, Object>> queryServices(Date from, Date to) {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(32);
        try {
            SearchRequest searchRequest = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            TermsAggregationBuilder componentBuilder = (TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)AGG_SRC_SERVICE).field("srcService.keyword")).size(100).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)AGG_DESC_SERVICE).field("descService.keyword")).size(100).subAggregation((AggregationBuilder)AggregationBuilders.avg((String)"avg_time").field(DURATION_MICROS)));
            sourceBuilder.aggregation((AggregationBuilder)componentBuilder);
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)from.getTime()).lte((Object)to.getTime()));
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            sourceBuilder.size(0);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(from, to, Constant.TOPOLOGY_SERVICE_PRE));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            RestStatus status = searchResponse.status();
            if (status.getStatus() == 200) {
                Aggregations aggregations = searchResponse.getAggregations();
                HashSet<String> child = new HashSet<String>(8);
                if (aggregations != null) {
                    Terms agg_srcService = (Terms)aggregations.get(AGG_SRC_SERVICE);
                    for (Terms.Bucket bucket : agg_srcService.getBuckets()) {
                        String key = bucket.getKeyAsString();
                        Terms agg_descService = (Terms)bucket.getAggregations().get(AGG_DESC_SERVICE);
                        HashMap<String, Object> parentNode = new HashMap<String, Object>(8);
                        parentNode.put("name", key);
                        parentNode.put("type", CLOUD);
                        ArrayList<Map<Object, Object>> childrens = new ArrayList<Map<Object, Object>>(32);
                        for (Terms.Bucket bucket1 : agg_descService.getBuckets()) {
                            HashMap<String, Object> childNode = new HashMap<String, Object>(8);
                            String keyAsString = bucket1.getKeyAsString();
                            childNode.put("name", keyAsString);
                            childNode.put("type", CLOUD);
                            ParsedAvg avg_time = (ParsedAvg)bucket1.getAggregations().get("avg_time");
                            childNode.put("cost", avg_time.getValue());
                            childrens.add(childNode);
                            child.add(keyAsString);
                        }
                        childrens.addAll(this.queryComponent(from, to, key));
                        parentNode.put(CHILDREN, childrens);
                        ret.add(parentNode);
                    }
                }
                for (String name : child) {
                    if (this.contain(ret, name)) continue;
                    HashMap<String, Object> node = new HashMap<String, Object>(8);
                    node.put("name", name);
                    node.put("type", CLOUD);
                    node.put(CHILDREN, this.queryComponent(from, to, name));
                    ret.add(node);
                }
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return ret;
    }

    private boolean contain(List<Map<String, Object>> list, String name) {
        for (Map<String, Object> map : list) {
            String nodeName = (String)map.get("name");
            if (!name.equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSONObject queryInvokeDetail(Date from, Date to, String source, String target, String orderType, int topLine, int usedTime, String rangeOrder) {
        JSONObject topoData = new JSONObject();
        try {
            SearchHit[] hits;
            SearchRequest searchRequest = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)DURATION_MICROS).gte((Object)usedTime));
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)from.getTime()).lte((Object)to.getTime()));
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"srcServiceInstanceId.keyword", (String[])new String[]{source}));
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"descServiceInstanceId.keyword", (String[])new String[]{target}));
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            if (rangeOrder.equals(SortOrder.DESC.toString())) {
                sourceBuilder.sort(orderType, SortOrder.DESC);
            } else if (rangeOrder.equals(SortOrder.ASC.toString())) {
                sourceBuilder.sort(orderType, SortOrder.ASC);
            }
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(from, to, Constant.TOPOLOGY_SERVICE_PRE));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            sourceBuilder.size(topLine);
            ArrayList<Map> apis = new ArrayList<Map>(32);
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            for (SearchHit hit : hits = searchResponse.getHits().getHits()) {
                apis.add(hit.getSourceAsMap());
            }
            topoData.put("data", apis);
        }
        catch (Exception e) {
            logger.error("query topo error,", (Throwable)e);
            topoData.put("data", Collections.emptyList());
        }
        return topoData;
    }

    private List<Map<String, Object>> queryComponent(Date from, Date to, String instance) {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(32);
        try {
            Aggregations aggregations;
            SearchRequest searchRequest = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            TermsAggregationBuilder componentBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGG_SRC_SERVICE).field("srcService.keyword")).size(100);
            TermsAggregationBuilder descService = ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGG_DESC_SERVICE).field("descService.keyword")).size(100);
            descService.subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"doc_Source").size(1));
            descService.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)"avg_time").field(DURATION_MICROS));
            componentBuilder.subAggregation((AggregationBuilder)descService);
            sourceBuilder.aggregation((AggregationBuilder)componentBuilder);
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"srcService.keyword", (String)instance));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)from.getTime()).lte((Object)to.getTime()));
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            sourceBuilder.size(0);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(from, to, Constant.TOPOLOGY_PRE));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            RestStatus status = searchResponse.status();
            if (status.getStatus() == 200 && (aggregations = searchResponse.getAggregations()) != null) {
                Terms agg_srcService = (Terms)aggregations.get(AGG_SRC_SERVICE);
                for (Terms.Bucket bucket : agg_srcService.getBuckets()) {
                    Terms agg_descService = (Terms)bucket.getAggregations().get(AGG_DESC_SERVICE);
                    ArrayList childrens = new ArrayList(32);
                    for (Terms.Bucket bucket1 : agg_descService.getBuckets()) {
                        ParsedTopHits topHits = (ParsedTopHits)bucket1.getAggregations().get("doc_Source");
                        SearchHit[] hits = topHits.getHits().getHits();
                        HashMap<String, Object> childNode = new HashMap<String, Object>(8);
                        String keyAsString = bucket1.getKeyAsString();
                        Map sourceAsMap = hits[0].getSourceAsMap();
                        String protocol = (String)sourceAsMap.get("protocol");
                        String destComponent = (String)sourceAsMap.get("destComponent");
                        if (keyAsString.indexOf(protocol) < 0) {
                            keyAsString = destComponent + ":" + keyAsString;
                        }
                        if ("MService".equals(destComponent)) continue;
                        childNode.put("name", keyAsString);
                        childNode.put("type", destComponent);
                        ParsedAvg avg_time = (ParsedAvg)bucket1.getAggregations().get("avg_time");
                        childNode.put("cost", avg_time.getValue());
                        childrens.add(childNode);
                    }
                    ret.addAll(childrens);
                }
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return ret;
    }

    @Override
    public List<Map<String, Object>> queryServiceInstTopology(Date from, Date to, String instance) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(10);
        try {
            Aggregations aggregations;
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            SearchRequest searchRequest = new SearchRequest();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"srcService.keyword", (String)instance));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)from.getTime()).lte((Object)to.getTime()));
            TermsAggregationBuilder componentBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg_ssi").field("srcServiceInstanceId.keyword")).size(100);
            TermsAggregationBuilder descService = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg_dsi").field("descServiceInstanceId.keyword")).size(100);
            descService.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)"avg_time").field(DURATION_MICROS));
            componentBuilder.subAggregation((AggregationBuilder)descService);
            sourceBuilder.aggregation((AggregationBuilder)componentBuilder);
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            sourceBuilder.size(0);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(from, to, Constant.TOPOLOGY_SERVICE_PRE));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            if (searchResponse.status().getStatus() == 200 && (aggregations = searchResponse.getAggregations()) != null) {
                Terms agg_srcService = (Terms)aggregations.get("agg_ssi");
                for (Terms.Bucket bucket : agg_srcService.getBuckets()) {
                    Terms agg_descService = (Terms)bucket.getAggregations().get("agg_dsi");
                    String srcServiceInstanceId = bucket.getKeyAsString();
                    for (Terms.Bucket bucket1 : agg_descService.getBuckets()) {
                        HashMap<String, Object> childNode = new HashMap<String, Object>(4);
                        childNode.put("srcServiceInstanceId", srcServiceInstanceId);
                        childNode.put("descServiceInstanceId", bucket1.getKeyAsString());
                        ParsedAvg avg_time = (ParsedAvg)bucket1.getAggregations().get("avg_time");
                        Double value = avg_time.getValue() / 1000.0;
                        childNode.put("cost", value.intValue());
                        childNode.put("count", bucket1.getDocCount());
                        retList.add(childNode);
                    }
                }
            }
        }
        catch (IOException e) {
            return retList;
        }
        return retList;
    }

    @Override
    public void clearHistoryData(int days) {
        try {
            try {
                days = Integer.parseInt(System.getProperty("apm.gov.storage.days", "1"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            ArrayList<String> deleteIndices = new ArrayList<String>(32);
            Calendar instance = Calendar.getInstance();
            instance.add(5, -days);
            Date before = instance.getTime();
            GetAliasesResponse alias = this.esClient.indices().getAlias(new GetAliasesRequest(), RequestOptions.DEFAULT);
            Map aliases = alias.getAliases();
            Iterator items = aliases.entrySet().iterator();
            String traceIndex = System.getProperty("trace.sword.es.index", Constant.SWORD_SPAN_DATA);
            while (items.hasNext()) {
                Date parse;
                String dateString;
                String dateString2;
                Map.Entry next = items.next();
                String indexName = (String)next.getKey();
                if (indexName.contains(Constant.TOPOLOGY_SERVICE_PRE)) {
                    try {
                        dateString2 = indexName.replace(Constant.TOPOLOGY_SERVICE_PRE, "");
                        Date parse2 = dateFormat.parse(dateString2);
                        if (!parse2.before(before)) continue;
                        deleteIndices.add(indexName);
                    }
                    catch (ParseException e) {
                        this.errorLog("serviceinstancerelation", e);
                    }
                    continue;
                }
                if (indexName.contains(Constant.TOPOLOGY_PRE)) {
                    try {
                        dateString2 = indexName.replace(Constant.TOPOLOGY_PRE, "");
                        Date parse3 = dateFormat.parse(dateString2);
                        if (!parse3.before(before)) continue;
                        deleteIndices.add(indexName);
                    }
                    catch (ParseException e) {
                        this.errorLog("servicerelation", e);
                    }
                    continue;
                }
                if (indexName.contains(Constant.API_CALL_DATA)) {
                    try {
                        dateString2 = indexName.replace(Constant.API_CALL_DATA, "");
                        Date parse4 = dateFormat.parse(dateString2);
                        if (!parse4.before(before)) continue;
                        deleteIndices.add(indexName);
                    }
                    catch (ParseException e) {
                        this.errorLog("apicalldata", e);
                    }
                    continue;
                }
                if (indexName.contains(Constant.ARMOR_LINK_DATA)) {
                    try {
                        Calendar armorDataInstance = Calendar.getInstance();
                        int armorDataDays = Integer.parseInt(System.getProperty("apm.gov.armor.storage.days", "7"));
                        armorDataInstance.add(5, -armorDataDays);
                        Date armorDataBefore = armorDataInstance.getTime();
                        dateString = indexName.replace(Constant.ARMOR_LINK_DATA, "");
                        parse = dateFormat.parse(dateString);
                        if (!parse.before(armorDataBefore)) continue;
                        deleteIndices.add(indexName);
                    }
                    catch (ParseException e) {
                        this.errorLog("armorlinkdata", e);
                    }
                    continue;
                }
                if (indexName.contains(traceIndex)) {
                    try {
                        dateString2 = indexName.replace(traceIndex, "");
                        Date parse5 = dateFormat.parse(dateString2);
                        if (!parse5.before(before)) continue;
                        deleteIndices.add(indexName);
                    }
                    catch (ParseException e) {
                        this.errorLog("trace", e);
                    }
                    continue;
                }
                if (indexName.contains(Constant.METRIC_INDEX_PRE)) {
                    try {
                        dateString2 = indexName.replace(Constant.METRIC_INDEX_PRE, "");
                        Date parse6 = dateFormat.parse(dateString2);
                        if (!parse6.before(before)) continue;
                        deleteIndices.add(indexName);
                    }
                    catch (ParseException e) {
                        this.errorLog("metrics", e);
                    }
                    continue;
                }
                if (indexName.contains(Constant.EVENT_DATA_INDEX_PRE)) {
                    Calendar eventDataInstance = Calendar.getInstance();
                    int eventDataDays = Integer.parseInt(System.getProperty("apm.gov.eventdata.storage.days", "15"));
                    eventDataInstance.add(5, -eventDataDays);
                    Date eventDataBefore = eventDataInstance.getTime();
                    try {
                        dateString = indexName.replace(Constant.EVENT_DATA_INDEX_PRE, "");
                        parse = dateFormat.parse(dateString);
                        if (!parse.before(eventDataBefore)) continue;
                        deleteIndices.add(indexName);
                    }
                    catch (ParseException e) {
                        this.errorLog("event_data", e);
                    }
                    continue;
                }
                if (indexName.contains(Constant.MULTI_TENANT_INDEX_PRE)) {
                    try {
                        dateString2 = indexName.replace(Constant.MULTI_TENANT_INDEX_PRE, "");
                        Date parse7 = dateFormat.parse(dateString2);
                        if (!parse7.before(before)) continue;
                        deleteIndices.add(indexName);
                    }
                    catch (ParseException e) {
                        this.errorLog("multitenant", e);
                    }
                    continue;
                }
                try {
                    Set<String> extendIndexPreSet = ESReporter.getExtendIndexPreSet();
                    for (String extendIndexPre : extendIndexPreSet) {
                        if (!indexName.contains(extendIndexPre) || !(parse = dateFormat.parse(dateString = indexName.replace(extendIndexPre, ""))).before(before)) continue;
                        deleteIndices.add(indexName);
                    }
                }
                catch (ParseException e) {
                    this.errorLog("extendIndexPreSet", e);
                }
            }
            if (deleteIndices.size() > 0) {
                for (int i = 0; i < deleteIndices.size(); i += 30) {
                    List currentBatch = deleteIndices.subList(i, Math.min(i + 30, deleteIndices.size()));
                    this.esClient.indices().delete(new DeleteIndexRequest().indices(currentBatch.toArray(new String[0])).indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false)), RequestOptions.DEFAULT);
                }
            }
        }
        catch (Exception e) {
            logger.error("remove index error", (Throwable)e);
        }
    }

    private void errorLog(String type, Exception e) {
        logger.error("remove {} index error", (Object)type, (Object)e);
    }

    @Override
    public Map<String, Map<String, Object>> apiCallStats(Date from, Date to, String apiName, String apiType) {
        HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>(32);
        try {
            Aggregations aggregations;
            SearchRequest searchRequest = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            TermsAggregationBuilder componentBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg_signature").field(SIGNATURE_KEYWORD)).size(Integer.getInteger("monitor.apicall.limit.es.count", 2000).intValue());
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"sum_time").field(DURATION_MICROS));
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)APP_ID).size(1));
            sourceBuilder.aggregation((AggregationBuilder)componentBuilder);
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)COLLECTION_TIME).gte((Object)from.getTime()).lte((Object)to.getTime()));
            if (StringUtils.isNotEmpty((String)apiName)) {
                BoolQueryBuilder boolQueryBuilder1 = QueryBuilders.boolQuery();
                if (apiName.contains("@@")) {
                    String[] appNames = apiName.split("@@");
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)SIGNATURE_KEYWORD, (String[])appNames));
                } else {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)SIGNATURE_KEYWORD, (String)("*" + apiName + "*")));
                }
            }
            if (StringUtils.isNotEmpty((String)apiType)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type.keyword", (String)apiType));
            }
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            sourceBuilder.size(0);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(from, to, Constant.API_CALL_DATA));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            RestStatus status = searchResponse.status();
            if (status.getStatus() == 200 && (aggregations = searchResponse.getAggregations()) != null) {
                Terms signature = (Terms)aggregations.get("agg_signature");
                for (Terms.Bucket bucket : signature.getBuckets()) {
                    Map sourceAsMap = ((ParsedTopHits)bucket.getAggregations().get(APP_ID)).getHits().getHits()[0].getSourceAsMap();
                    String appId = (String)sourceAsMap.get(APP_ID);
                    String type = (String)sourceAsMap.get("type");
                    HashMap<String, Object> statsMap = new HashMap<String, Object>(2);
                    long docCount = bucket.getDocCount();
                    statsMap.put("count", docCount);
                    ParsedSum sum_time = (ParsedSum)bucket.getAggregations().get("sum_time");
                    double sum = sum_time.getValue() / 1000.0;
                    double avg = sum / (double)docCount;
                    statsMap.put("time", avg);
                    statsMap.put(APP_ID, appId);
                    statsMap.put("type", type);
                    ret.put(bucket.getKeyAsString(), statsMap);
                }
            }
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        return ret;
    }

    @Override
    public List<Map<String, Object>> apiCallDetail(Date from, Date to, String apiName) {
        ArrayList<Map> ret = null;
        try {
            SearchRequest searchRequest = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)COLLECTION_TIME).gte((Object)from.getTime()).lte((Object)to.getTime()));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)SIGNATURE_KEYWORD, (String)apiName));
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            sourceBuilder.size(Integer.getInteger("monitor.apicall.limit.es.count", 2000).intValue());
            sourceBuilder.sort(COLLECTION_TIME, SortOrder.DESC);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(from, to, Constant.API_CALL_DATA));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            RestStatus status = searchResponse.status();
            if (status.getStatus() == 200) {
                SearchHit[] searchHits = searchResponse.getHits().getHits();
                ret = new ArrayList<Map>((int)searchResponse.getHits().totalHits);
                for (SearchHit searchHit : searchHits) {
                    ret.add(searchHit.getSourceAsMap());
                }
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return ret;
    }

    @Override
    public List<Map<String, Object>> eventData(Date from, Date to, Map<String, String> params) {
        ArrayList<Map> eventDataList = null;
        try {
            String keyword;
            String userName;
            String userId;
            String accountId;
            String tenantId;
            String traceId;
            String ip;
            String instanceId;
            String appId;
            String appName;
            String clusterName;
            String secondEventType;
            SearchRequest searchRequest = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)from.getTime()).lte((Object)to.getTime()));
            String firstEventType = params.get("firstEventType");
            if (StringUtils.isNotEmpty((String)firstEventType)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"firstEventType.keyword", (String)firstEventType));
            }
            if (StringUtils.isNotEmpty((String)(secondEventType = params.get("secondEventType")))) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"secondEventType.keyword", (String)secondEventType));
            }
            if (StringUtils.isNotEmpty((String)(clusterName = params.get("clusterName")))) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"clusterName.keyword", (String)clusterName));
            }
            if (StringUtils.isNotEmpty((String)(appName = params.get("appName")))) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"appName.keyword", (String)appName));
            }
            if (StringUtils.isNotEmpty((String)(appId = params.get(APP_ID)))) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"appId.keyword", (String)appId));
            }
            if (StringUtils.isNotEmpty((String)(instanceId = params.get("instanceId")))) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"instanceId.keyword", (String)instanceId));
            }
            if (StringUtils.isNotEmpty((String)(ip = params.get("ip")))) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ip.keyword", (String)ip));
            }
            if (StringUtils.isNotEmpty((String)(traceId = params.get("traceId")))) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"traceId.keyword", (String)traceId));
            }
            if (StringUtils.isNotEmpty((String)(tenantId = params.get("tenantId")))) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId.keyword", (String)tenantId));
            }
            if (StringUtils.isNotEmpty((String)(accountId = params.get("accountId")))) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"accountId.keyword", (String)accountId));
            }
            if (StringUtils.isNotEmpty((String)(userId = params.get("userId")))) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"userId.keyword", (String)userId));
            }
            if (StringUtils.isNotEmpty((String)(userName = params.get("userName")))) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"userName.keyword", (String)userName));
            }
            if (StringUtils.isNotEmpty((String)(keyword = params.get("keyword")))) {
                BoolQueryBuilder keywordQuery = QueryBuilders.boolQuery();
                keywordQuery.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"message.keyword", (String)("*" + keyword + "*")));
                keywordQuery.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"message2.keyword", (String)("*" + keyword + "*")));
                boolQueryBuilder.must((QueryBuilder)keywordQuery);
            }
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            int size = 0;
            if (params.containsKey("size")) {
                size = Integer.parseInt(params.get("size"));
            }
            sourceBuilder.size(size);
            sourceBuilder.sort(TIMESTAMP, SortOrder.DESC);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(from, to, Constant.EVENT_DATA_INDEX_PRE));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            RestStatus status = searchResponse.status();
            if (status.getStatus() == 200) {
                SearchHit[] searchHits = searchResponse.getHits().getHits();
                eventDataList = new ArrayList<Map>((int)searchResponse.getHits().totalHits);
                for (SearchHit searchHit : searchHits) {
                    eventDataList.add(searchHit.getSourceAsMap());
                }
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return eventDataList;
    }

    @Override
    public Map<String, Map<String, Object>> queryArmorLinkData(Map<String, Object> map) {
        HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>(32);
        try {
            Aggregations aggregations;
            Date startDate = (Date)map.get("startDate");
            Date endDate = (Date)map.get("endDate");
            long seconds = (endDate.getTime() - startDate.getTime()) / 1000L;
            long minutes = seconds / 60L;
            minutes = minutes > 0L ? minutes : 1L;
            String tenantId = (String)map.get("tenantId");
            String appName = (String)map.get("appName");
            String instanceId = (String)map.get("instanceId");
            String resource = (String)map.get("resource");
            SearchRequest searchRequest = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            TermsAggregationBuilder componentBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg_resource").field("resource.keyword")).size(Integer.getInteger("monitor.armorlink.limit.es.count", 20000).intValue());
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"sum_averageRt").field("averageRt"));
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.max((String)"max_averageRt").field("averageRt"));
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"sum_blockQps").field("blockQps"));
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.max((String)"max_blockQps").field("blockQps"));
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"sum_exceptionQps").field("exceptionQps"));
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.max((String)"max_exceptionQps").field("exceptionQps"));
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"sum_passQps").field("passQps"));
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.max((String)"max_passQps").field("passQps"));
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"sum_totalQps").field("totalQps"));
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"sum_threadNum").field("threadNum"));
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.max((String)"max_threadNum").field("threadNum"));
            sourceBuilder.aggregation((AggregationBuilder)componentBuilder);
            DateHistogramAggregationBuilder dateHistogramAgg = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"by_second").field(TIMESTAMP)).interval(1000L).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"total_success_sum").field("successQps"));
            sourceBuilder.aggregation((AggregationBuilder)dateHistogramAgg);
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)startDate.getTime()).lte((Object)endDate.getTime()));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"appName.keyword", (String)appName));
            if (StringUtils.isNotEmpty((String)tenantId)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId.keyword", (String)tenantId));
            }
            if (StringUtils.isNotEmpty((String)instanceId)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"instanceId.keyword", (String)instanceId));
            }
            if (StringUtils.isNotEmpty((String)resource)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"resource.keyword", (String)("*" + resource + "*")));
            }
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            sourceBuilder.size(0);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(startDate, endDate, Constant.ARMOR_LINK_DATA));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            RestStatus status = searchResponse.status();
            if (status.getStatus() == 200 && (aggregations = searchResponse.getAggregations()) != null) {
                Terms signature = (Terms)aggregations.get("agg_resource");
                for (Terms.Bucket bucket : signature.getBuckets()) {
                    HashMap<String, Number> statsMap = new HashMap<String, Number>(12);
                    long docCount = bucket.getDocCount();
                    docCount = docCount > 0L ? docCount : 1L;
                    statsMap.put("count", docCount);
                    ParsedSum sum_averageRt = (ParsedSum)bucket.getAggregations().get("sum_averageRt");
                    ParsedMax maxAverageRt = (ParsedMax)bucket.getAggregations().get("max_averageRt");
                    Double averageRt = sum_averageRt.getValue() / (double)docCount;
                    ParsedSum sum_blockQps = (ParsedSum)bucket.getAggregations().get("sum_blockQps");
                    ParsedMax maxBlockQps = (ParsedMax)bucket.getAggregations().get("max_blockQps");
                    Double blockQps = sum_blockQps.getValue() / (double)seconds;
                    ParsedSum totalQps = (ParsedSum)bucket.getAggregations().get("sum_totalQps");
                    ParsedSum sum_passQps = (ParsedSum)bucket.getAggregations().get("sum_passQps");
                    ParsedMax maxPassQps = (ParsedMax)bucket.getAggregations().get("max_passQps");
                    Double passQps = sum_passQps.getValue() / (double)seconds;
                    ParsedSum sum_threadNum = (ParsedSum)bucket.getAggregations().get("sum_threadNum");
                    ParsedMax maxThreadNum = (ParsedMax)bucket.getAggregations().get("max_threadNum");
                    Double threadNum = sum_threadNum.getValue() / (double)seconds;
                    statsMap.put("averageRt", averageRt.longValue());
                    statsMap.put("maxAverageRt", new Double(maxAverageRt.getValue()).longValue());
                    statsMap.put("blockQps", blockQps.longValue());
                    statsMap.put("maxBlockQps", new Double(maxBlockQps.getValue()).longValue());
                    statsMap.put("passQps", passQps.longValue());
                    statsMap.put("maxPassQps", new Double(maxPassQps.getValue()).longValue());
                    statsMap.put("totalQps", new Double(totalQps.getValue()).longValue());
                    statsMap.put("threadNum", threadNum == 0.0 ? 0 : (threadNum < 1.0 ? 1 : threadNum.intValue()));
                    statsMap.put("maxThreadNum", new Double(maxThreadNum.getValue()).intValue());
                    ret.put(bucket.getKeyAsString(), statsMap);
                }
            }
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        return ret;
    }

    @Override
    public Map<String, Object> traceList(Date from, Date to, Map<String, String> params) {
        try {
            String appId;
            String instanceId;
            String userName;
            String traceId;
            HashMap<String, Object> retMap = new HashMap<String, Object>(8);
            ArrayList treeList = new ArrayList(32);
            String indexPre = System.getProperty("trace.sword.es.index", Constant.SWORD_SPAN_DATA);
            String[] indices = ElasticsearchClient.getIndices(from, to, indexPre);
            SearchRequest searchRequest = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            String serviceName = params.get("serviceName");
            if (StringUtils.isNotEmpty((String)serviceName)) {
                boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"serviceName.keyword", (String)serviceName));
            }
            if (StringUtils.isNotEmpty((String)(traceId = params.get("traceId")))) {
                boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"traceId.keyword", (String)traceId));
            }
            if (StringUtils.isNotEmpty((String)(userName = params.get("userName")))) {
                boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"tags.userName.keyword", (String)userName));
            }
            if (StringUtils.isNotEmpty((String)(instanceId = params.get("instanceId")))) {
                boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"instanceId.keyword", (String)instanceId));
            }
            if (StringUtils.isNotEmpty((String)(appId = params.get(APP_ID)))) {
                boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"tags.appId.keyword", (String)appId));
            }
            boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp_millis").gte((Object)params.get("from")).lte((Object)params.get("to")));
            String duration = params.get(DURATION);
            if (duration != null) {
                Long aLong = Long.valueOf(duration.toString());
                boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)DURATION).gte((Object)(aLong * 1000L)));
            }
            boolQuery.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)PARENT_ID));
            int traceSortType = 0;
            if (params.containsKey("traceSortType")) {
                traceSortType = Integer.parseInt(params.get("traceSortType"));
            }
            int traceRequestCount = 1000;
            if (params.containsKey("traceRequestCount")) {
                traceRequestCount = Integer.parseInt(params.get("traceRequestCount"));
            }
            switch (traceSortType) {
                case 1: {
                    sourceBuilder.query((QueryBuilder)boolQuery).size(traceRequestCount).sort("timestamp_millis", SortOrder.DESC);
                    break;
                }
                case 2: {
                    sourceBuilder.query((QueryBuilder)boolQuery).size(traceRequestCount).sort("timestamp_millis", SortOrder.ASC);
                    break;
                }
                case 3: {
                    sourceBuilder.query((QueryBuilder)boolQuery).size(traceRequestCount).sort(DURATION, SortOrder.DESC);
                    break;
                }
                case 4: {
                    sourceBuilder.query((QueryBuilder)boolQuery).size(traceRequestCount).sort(DURATION, SortOrder.ASC);
                    break;
                }
                default: {
                    sourceBuilder.query((QueryBuilder)boolQuery).size(traceRequestCount).sort("timestamp_millis", SortOrder.DESC);
                }
            }
            IndicesOptions indicesOptions = IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false);
            searchRequest.indices(indices);
            if (ElasticSearchUtil.getVersion(elasticsearchConfig) <= 6) {
                searchRequest.types(new String[]{"type", "doc"});
            }
            searchRequest.source(sourceBuilder).indicesOptions(indicesOptions);
            SearchHit[] hits = this.esClient.search(searchRequest, RequestOptions.DEFAULT).getHits().getHits();
            JSONArray array = new JSONArray();
            boolean onlyOne = false;
            String appIdFilter = params.get("APPID");
            String apiNameFilter = params.get("apiName");
            for (SearchHit hit : hits) {
                String apiNameFilter1;
                String appIdFilter1;
                int durationT;
                Map source = hit.getSourceAsMap();
                String traceIdStr = source.get("traceId").toString();
                HashMap<String, Object> treeNode = new HashMap<String, Object>(8);
                Map tags = new HashMap(10);
                tags = (Map)source.get("tags");
                if (!tags.isEmpty()) {
                    String appId1;
                    if (tags.containsKey(APP_ID) && tags.containsKey("APICall.signature")) {
                        appId1 = tags.get(APP_ID).toString();
                        treeNode.put(APP_ID, appId1);
                        String api = tags.get("APICall.signature").toString();
                        treeNode.put("api", api);
                    } else if (tags.containsKey("APICall.appId") && tags.containsKey("APICall.signature")) {
                        appId1 = tags.get("APICall.appId").toString();
                        treeNode.put(APP_ID, appId1);
                        String api = tags.get("APICall.signature").toString();
                        treeNode.put("api", api);
                    } else {
                        String[] splitTemp;
                        String[] apiTemp;
                        appId1 = tags.containsKey(APP_ID) ? tags.get(APP_ID).toString() : "web";
                        treeNode.put(APP_ID, appId1);
                        String api = source.get("name").toString();
                        if (api.contains("//") && (apiTemp = (splitTemp = api.split("//"))[1].split("/")).length > 1) {
                            StringBuilder api1 = new StringBuilder();
                            for (int i = 1; i < apiTemp.length; ++i) {
                                api1.append("/").append(apiTemp[i]);
                            }
                            api = api1.toString();
                        }
                        treeNode.put("api", api);
                    }
                }
                String name = (durationT = ((Integer)source.get(DURATION)).intValue()) > 1000 ? "[" + durationT / 1000 + "ms]" : "[" + durationT + "\u03bcs]";
                double duration1 = (double)durationT / 1000.0;
                duration1 = (double)Math.round(duration1 * 100.0) / 100.0;
                treeNode.put(ID, source.get(ID));
                treeNode.put("label", source.get("serviceName") + name);
                treeNode.put("value", traceIdStr);
                treeNode.put("serviceName", source.get("name"));
                treeNode.put(DURATION, duration1);
                treeNode.put(TIMESTAMP, source.get("timestamp_millis"));
                if (StringUtils.isNotEmpty((String)appIdFilter) && !(appIdFilter1 = (String)treeNode.get(APP_ID)).toLowerCase().contains(appIdFilter.toLowerCase()) || StringUtils.isNotEmpty((String)apiNameFilter) && !(apiNameFilter1 = (String)treeNode.get("api")).toLowerCase().contains(apiNameFilter.toLowerCase())) continue;
                treeList.add(treeNode);
                if (onlyOne) continue;
                SearchRequest request = new SearchRequest();
                SearchSourceBuilder builder = new SearchSourceBuilder();
                BoolQueryBuilder filter = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"traceId.keyword", (String)traceIdStr));
                String maskServiceName = params.get("maskServiceName");
                String minDuration = params.get("minDuration");
                float filterSpan = 0.0f;
                if (StringUtils.isNotEmpty((String)minDuration)) {
                    filterSpan = Float.parseFloat(minDuration) * 1000.0f;
                }
                if (StringUtils.isNotEmpty((String)maskServiceName)) {
                    String[] split = maskServiceName.split(",");
                    filter.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"serviceName", (String[])split));
                }
                builder.query((QueryBuilder)filter).size(2000).sort("timestamp_millis", SortOrder.ASC).collapse(new CollapseBuilder("id.keyword"));
                request.source(builder).indices(indices);
                if (ElasticSearchUtil.getVersion(elasticsearchConfig) <= 6) {
                    request.types(new String[]{"type", "doc"});
                }
                request.indicesOptions(indicesOptions);
                SearchHit[] searchHits = this.esClient.search(request, RequestOptions.DEFAULT).getHits().getHits();
                String optimize = System.getProperty("monitor.trace.query.optimize", "true");
                if (Boolean.parseBoolean(optimize)) {
                    JSONObject optimizeTree = this.optimizeTree(searchHits, filterSpan);
                    array.add((Object)optimizeTree.getJSONObject("invokeTree"));
                    retMap.put("statMap", optimizeTree.get((Object)"stat"));
                } else {
                    JSONObject node = this.getTreeNode(searchHits, filterSpan);
                    array.add((Object)node);
                    retMap.put("list", searchHits);
                }
                onlyOne = true;
            }
            retMap.put("tree", array);
            retMap.put("treeList", treeList);
            return retMap;
        }
        catch (Error | Exception e) {
            return Collections.EMPTY_MAP;
        }
    }

    private JSONObject optimizeTree(SearchHit[] searchHits, float minDuration) {
        JSONObject ret = new JSONObject();
        ArrayList<JSONObject> nodes = new ArrayList<JSONObject>(searchHits.length);
        JSONObject rootNode = null;
        HashMap treeMap = new HashMap(16);
        HashMap<String, Integer> statMap = new HashMap<String, Integer>(16);
        for (SearchHit searchHit : searchHits) {
            JSONObject node2 = JSONObject.parseObject((String)searchHit.getSourceAsString());
            node2.getJSONObject("tags").remove((Object)"cookies");
            node2.getJSONObject("tags").remove((Object)"sessionId");
            String serviceName = node2.getString("serviceName");
            String parentId = node2.getString(PARENT_ID);
            if (parentId == null) {
                rootNode = node2;
            } else if ((float)node2.getIntValue(DURATION) > minDuration) {
                nodes.add(node2);
                if (treeMap.containsKey(parentId)) {
                    ((List)treeMap.get(parentId)).add(node2);
                } else {
                    ArrayList<JSONObject> childs = new ArrayList<JSONObject>();
                    childs.add(node2);
                    treeMap.put(parentId, childs);
                }
            }
            if (statMap.containsKey(serviceName)) {
                Integer integer = (Integer)statMap.get(serviceName);
                integer = integer + 1;
                statMap.put(serviceName, integer);
                continue;
            }
            statMap.put(serviceName, 1);
        }
        if (rootNode == null) {
            rootNode = (JSONObject)nodes.remove(0);
        }
        rootNode.put("startPercent", (Object)Float.valueOf(0.0f));
        rootNode.put("midPercent", (Object)Float.valueOf(100.0f));
        nodes.forEach(node -> {
            String id = node.getString(ID);
            List child = (List)treeMap.get(id);
            if (child != null) {
                node.put(CHILDREN, (Object)child);
            }
        });
        String traceId = rootNode.getString(ID);
        List childs = (List)treeMap.get(traceId);
        float totalDuration = rootNode.getFloatValue(DURATION);
        if (childs != null) {
            rootNode.put(CHILDREN, (Object)childs);
            this.position = totalDuration - this.sumChildDuration(childs);
            for (JSONObject obj : childs) {
                this.setPosition(rootNode, obj, totalDuration);
            }
        }
        ret.put("invokeTree", (Object)rootNode);
        ret.put("stat", statMap);
        return ret;
    }

    private void setPosition(JSONObject root, JSONObject treeNode, float totalDuration) {
        float nodeDuration = treeNode.getFloatValue(DURATION);
        this.computerNodePosition(root, treeNode, totalDuration);
        List childes = (List)treeNode.getObject(CHILDREN, List.class);
        if (childes != null) {
            this.position += nodeDuration - this.sumChildDuration(childes);
            childes.forEach(child -> this.setPosition(root, (JSONObject)child, totalDuration));
        } else {
            this.position += nodeDuration;
        }
    }

    private float sumChildDuration(List<JSONObject> childes) {
        int size = childes.size();
        float sum = 0.0f;
        for (int i = 0; i < size; ++i) {
            JSONObject object = childes.get(i);
            sum += object.getFloatValue(DURATION);
        }
        return sum;
    }

    private JSONObject getTreeNode(SearchHit[] searchHits, float minDuration) {
        JSONObject rootNode = null;
        for (SearchHit searchHit : searchHits) {
            JSONObject nodeSource = JSONObject.parseObject((String)searchHit.getSourceAsString());
            nodeSource.getJSONObject("tags").remove((Object)"cookies");
            nodeSource.getJSONObject("tags").remove((Object)"sessionId");
            if (!StringUtils.isEmpty((String)nodeSource.getString(PARENT_ID))) continue;
            rootNode = nodeSource;
            rootNode.put("startPercent", (Object)0);
            rootNode.put("midPercent", (Object)100);
            String id = nodeSource.getString(ID);
            JSONArray child = this.findChildes(searchHits, id, minDuration);
            nodeSource.put(CHILDREN, (Object)child);
            float duration = rootNode.getFloatValue(DURATION);
            this.position = duration - this.sumChildDuration(child);
            this.formatTree(rootNode, searchHits, duration, minDuration);
            break;
        }
        if (rootNode == null && searchHits.length > 0) {
            rootNode = JSONObject.parseObject((String)searchHits[0].getSourceAsString());
            float duration = rootNode.getFloatValue(DURATION);
            String id = rootNode.getString(ID);
            JSONArray child = this.findChildes(searchHits, id, minDuration);
            this.position = duration - this.sumChildDuration(child);
            this.formatTree(rootNode, searchHits, duration, minDuration);
        }
        return rootNode;
    }

    private float computerNodePosition(JSONObject rootNode, JSONObject object, float rootDuration) {
        float childDuration = object.getFloatValue(DURATION);
        float midPercent = childDuration / rootDuration * 100.0f;
        float start = this.position / rootDuration * 100.0f;
        Long startTime = rootNode.getLongValue("timestamp_millis");
        Long nodeStartTime = object.getLongValue("timestamp_millis");
        float useTime = (float)(nodeStartTime - startTime) / (rootDuration / 1000.0f) * 100.0f;
        object.put("startPercent", (Object)Float.valueOf(useTime));
        object.put("midPercent", (Object)Float.valueOf(midPercent + useTime));
        return childDuration;
    }

    private float sumChildDuration(JSONArray childes) {
        int size = childes.size();
        float sum = 0.0f;
        for (int i = 0; i < size; ++i) {
            JSONObject object = childes.getJSONObject(i);
            sum += object.getFloatValue(DURATION);
        }
        return sum;
    }

    private JSONArray findChildes(SearchHit[] searchHits, String id, float minDuration) {
        JSONArray array = new JSONArray();
        for (SearchHit searchHit : searchHits) {
            String parentId;
            JSONObject nodeSource = JSONObject.parseObject((String)searchHit.getSourceAsString());
            int duration = nodeSource.getIntValue(DURATION);
            if (!((float)duration > minDuration) || !StringUtils.isNotEmpty((String)(parentId = nodeSource.getString(PARENT_ID))) || !parentId.equals(id)) continue;
            array.add((Object)nodeSource);
        }
        return array;
    }

    private void formatTree(JSONObject rootNode, SearchHit[] searchHits, float rootDuration, float minDuration) {
        JSONArray children = rootNode.getJSONArray(CHILDREN);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = children.getJSONObject(i);
            this.computerNodePosition(rootNode, jsonObject, rootDuration);
            String id = jsonObject.getString(ID);
            JSONArray childes = this.findChildes(searchHits, id, minDuration);
            if (childes.size() > 0) {
                this.position += jsonObject.getFloatValue(DURATION) - this.sumChildDuration(childes);
                jsonObject.put(CHILDREN, (Object)childes);
                this.formatTree(jsonObject, searchHits, rootDuration, minDuration);
                continue;
            }
            this.position += jsonObject.getFloatValue(DURATION);
        }
    }

    @Override
    public JSONObject queryMetrics(Map<String, Object> params) {
        JSONObject ret = new JSONObject();
        try {
            int querySize = Integer.getInteger("monitor.query.metrics.size", 5000);
            querySize = Math.min(querySize, 10000);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            String start = params.get("start").toString();
            Object endStr = params.get("end");
            Date end = endStr == null || StringUtils.isEmpty((String)endStr.toString()) ? new Date() : dateFormat.parse(endStr.toString());
            Date startDate = dateFormat.parse(start);
            String[] indices = ElasticsearchClient.getIndices(startDate, end, Constant.METRIC_INDEX_PRE);
            ret.put("instanceList", (Object)this.getAllInstance(indices));
            if (((Boolean)params.get("init")).booleanValue()) {
                return ret;
            }
            List metrics = (List)params.get("metrics");
            HashSet<String> ips = new HashSet<String>(16);
            HashSet<String> sources = new HashSet<String>(16);
            for (String metric : metrics) {
                String[] strings = metric.split(METRIC_SPLIT_SYMBOL);
                ips.add(strings[0]);
                sources.add(strings[1]);
            }
            SearchRequest searchRequest = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.sort(TIMESTAMP, SortOrder.DESC);
            sourceBuilder.size(querySize);
            searchRequest.source(sourceBuilder).indices(indices).indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            for (String ip : ips) {
                try {
                    BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
                    boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"metrics_type.keyword", (String)"gauge"));
                    boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)(startDate.getTime() + 28800000L)).lte((Object)(end.getTime() + 28800000L)));
                    boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)"ip.keyword", (String[])new String[]{ip}));
                    sourceBuilder.postFilter((QueryBuilder)boolQuery);
                    Object[] searchHits = this.esClient.search(searchRequest, RequestOptions.DEFAULT).getHits().getHits();
                    ArrayUtils.reverse((Object[])searchHits);
                    ret.putAll((Map)this.formatData(ip, sources, (SearchHit[])searchHits));
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            ret.put("queryErrorMessage", (Object)e.getMessage());
        }
        return ret;
    }

    @Override
    public JSONArray queryTenantMetrics(Map<String, Object> params) {
        JSONArray array = new JSONArray();
        try {
            SearchHit[] searchHits;
            int querySize = Integer.getInteger("monitor.query.metrics.size", 2000);
            querySize = Math.min(querySize, 10000);
            Object dimension = params.get("dimension");
            String queryDimension = "resource";
            if (dimension != null) {
                queryDimension = String.valueOf(dimension);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            String start = params.get("start").toString();
            Object endStr = params.get("end");
            Date end = endStr == null || StringUtils.isEmpty((String)endStr.toString()) ? new Date() : dateFormat.parse(endStr.toString());
            Date startDate = dateFormat.parse(start);
            String[] indices = ElasticsearchClient.getIndices(startDate, end, Constant.MULTI_TENANT_INDEX_PRE);
            List metrics = (List)params.get("metrics");
            HashSet<String> ips = new HashSet<String>(16);
            HashSet<String> sources = new HashSet<String>(16);
            for (String metric : metrics) {
                String[] strings = metric.split(METRIC_SPLIT_SYMBOL);
                ips.add(strings[0]);
                sources.add(strings[1]);
            }
            SearchRequest searchRequest = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.sort(TIMESTAMP, SortOrder.DESC);
            sourceBuilder.size(querySize);
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)(startDate.getTime() + 28800000L)).lte((Object)(end.getTime() + 28800000L)));
            BoolQueryBuilder ipQuery = QueryBuilders.boolQuery();
            ips.forEach(ip -> ipQuery.should((QueryBuilder)QueryBuilders.matchQuery((String)"ip", (Object)ip)));
            BoolQueryBuilder sourceQuery = QueryBuilders.boolQuery();
            if ("resource".equals(queryDimension)) {
                sources.forEach(source -> sourceQuery.should((QueryBuilder)QueryBuilders.matchQuery((String)"resourceName", (Object)source)));
            } else {
                sources.forEach(source -> sourceQuery.should((QueryBuilder)QueryBuilders.matchQuery((String)"accountId", (Object)source)));
            }
            boolQuery.must((QueryBuilder)ipQuery);
            boolQuery.must((QueryBuilder)sourceQuery);
            sourceBuilder.postFilter((QueryBuilder)boolQuery);
            searchRequest.source(sourceBuilder).indices(indices).indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            for (SearchHit searchHit : searchHits = this.esClient.search(searchRequest, RequestOptions.DEFAULT).getHits().getHits()) {
                JSONObject source2 = JSONObject.parseObject((String)searchHit.getSourceAsString());
                array.add((Object)source2);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return array;
    }

    private JSONObject formatData(String ip, Set<String> metrics, SearchHit[] searchHits) {
        JSONObject ret = new JSONObject();
        for (SearchHit searchHit : searchHits) {
            JSONObject source = JSONObject.parseObject((String)searchHit.getSourceAsString());
            for (String metric : metrics) {
                String key = ip + METRIC_SPLIT_SYMBOL + metric;
                if (ret.containsKey((Object)key)) {
                    this.series(source, metric, ret.getJSONObject(key));
                    continue;
                }
                JSONObject data = new JSONObject();
                this.series(source, metric, data);
                ret.put(key, (Object)data);
            }
        }
        return ret;
    }

    private void series(JSONObject source, String metric, JSONObject data) {
        String xAxisValue = source.getString("xAxis");
        data.put("appName", (Object)source.getString("appName"));
        switch (metric) {
            case "heapMemory": {
                this.fillMemoryData(source, "heap", data);
                break;
            }
            case "nonHeapMemory": {
                this.fillMemoryData(source, "non-heap", data);
                break;
            }
            case "metaspace": {
                this.fillMemoryData(source, "pools.Metaspace", data);
                break;
            }
            case "codeCache": {
                this.fillMemoryData(source, "pools.Code-Cache", data);
                break;
            }
            case "GCDuration": {
                Integer youngCount;
                Integer youngValue;
                Integer fullCount;
                Integer fullValue;
                JSONArray fullGc = data.getJSONArray("fullGc");
                if (source.containsKey((Object)"kd.metrics.jvm.gc.G1-Old-Generation.time")) {
                    fullValue = source.getIntValue("kd.metrics.jvm.gc.G1-Old-Generation.time");
                    fullCount = source.getIntValue("kd.metrics.jvm.gc.G1-Old-Generation.count");
                    youngValue = source.getIntValue("kd.metrics.jvm.gc.G1-Young-Generation.time");
                    youngCount = source.getIntValue("kd.metrics.jvm.gc.G1-Young-Generation.count");
                } else {
                    fullValue = source.getIntValue("kd.metrics.jvm.gc.PS-MarkSweep.time");
                    fullCount = source.getIntValue("kd.metrics.jvm.gc.PS-MarkSweep.count");
                    youngValue = source.getIntValue("kd.metrics.jvm.gc.PS-Scavenge.time");
                    youngCount = source.getIntValue("kd.metrics.jvm.gc.PS-Scavenge.count");
                }
                if (fullGc != null) {
                    data.getJSONArray("xAxis").add((Object)xAxisValue);
                    data.getJSONArray("fullGc").add((Object)fullValue);
                    data.getJSONArray("fullGcCount").add((Object)fullCount);
                    data.getJSONArray("youngGc").add((Object)youngValue);
                    data.getJSONArray("youngGcCount").add((Object)youngCount);
                    break;
                }
                JSONArray fullGcData = new JSONArray();
                fullGcData.add((Object)fullValue);
                JSONArray fullGcCount = new JSONArray();
                fullGcCount.add((Object)fullCount);
                JSONArray yongGcData = new JSONArray();
                yongGcData.add((Object)youngValue);
                JSONArray yongGcCount = new JSONArray();
                yongGcCount.add((Object)youngCount);
                JSONArray xAxisData = new JSONArray();
                xAxisData.add((Object)xAxisValue);
                data.put("fullGc", (Object)fullGcData);
                data.put("fullGcCount", (Object)fullGcCount);
                data.put("youngGc", (Object)yongGcData);
                data.put("youngGcCount", (Object)yongGcCount);
                data.put("xAxis", (Object)xAxisData);
                break;
            }
            case "class": {
                JSONArray classData = data.getJSONArray("value");
                Object classValue = source.get((Object)"kd.metrics.jvm.system.LoadedClassCount.value");
                if (classData != null) {
                    classData.add(classValue);
                    data.getJSONArray("xAxis").add((Object)xAxisValue);
                    break;
                }
                JSONArray array = new JSONArray();
                array.add(classValue);
                JSONArray xAxisData = new JSONArray();
                data.put("value", (Object)array);
                xAxisData.add((Object)xAxisValue);
                data.put("xAxis", (Object)xAxisData);
                break;
            }
            case "cpuLoadAvg": {
                JSONArray value = data.getJSONArray("value");
                Object cpu = source.get((Object)"kd.metrics.jvm.system.cpuLoadAvg.mean");
                if (value != null) {
                    value.add(cpu);
                    data.getJSONArray("xAxis").add((Object)xAxisValue);
                    break;
                }
                JSONArray array = new JSONArray();
                array.add(cpu);
                JSONArray xAxisData = new JSONArray();
                data.put("value", (Object)array);
                xAxisData.add((Object)xAxisValue);
                data.put("xAxis", (Object)xAxisData);
                break;
            }
            case "systemMem": {
                this.fillPhysicalMemory(source, "physicalMemory", data);
                break;
            }
            case "swapMem": {
                this.fillPhysicalMemory(source, "swapSpace", data);
                break;
            }
            case "sqlExecTime": {
                JSONArray mean = data.getJSONArray("mean");
                Object meanValue = source.get((Object)"kd.metrics.sql.execute.mean");
                Object maxValue = source.get((Object)"kd.metrics.sql.execute.max");
                if (mean != null) {
                    mean.add(meanValue);
                    data.getJSONArray(MAX).add(maxValue);
                    data.getJSONArray("xAxis").add((Object)xAxisValue);
                    break;
                }
                JSONArray meanData = new JSONArray();
                meanData.add(meanValue);
                JSONArray maxData = new JSONArray();
                maxData.add(maxValue);
                JSONArray xAxisData = new JSONArray();
                xAxisData.add((Object)xAxisValue);
                data.put(MAX, (Object)maxData);
                data.put("mean", (Object)meanData);
                data.put("xAxis", (Object)xAxisData);
                break;
            }
            case "webReqTime": {
                this.fillSingerData(source, "kd.metrics.servletfilter.requestTimer", data);
                break;
            }
            case "dubboWaitTime": {
                this.fillSingerData(source, "kd.metrics.dubbo.thread.queuewait", data);
                break;
            }
            case "discardCount": {
                this.fillSingerData(source, "kd.metrics.log.kafka.discardCount", data);
                break;
            }
            case "heapMemoryUsage": {
                this.fillSingerData(source, "kd.metrics.jvm.memory.heap.usage", data);
                break;
            }
            case "nonHeapMemoryUsage": {
                this.fillSingerData(source, "kd.metrics.jvm.memory.non-heap.usage", data);
                break;
            }
            case "oomcount": {
                this.fillSingerData(source, "kd.metrics.jvm.oomcount", data);
                break;
            }
            case "slow30second": {
                this.fillSingerData(source, "kd.metrics.sql.execute.slow30second", data);
                break;
            }
            case "slow60second": {
                this.fillSingerData(source, "kd.metrics.sql.execute.slow60second", data);
                break;
            }
            case "pigeonPublishMessage": {
                this.fillSingerData(source, "kd.metrics.mq.pigeon.publish.message.size", data);
                break;
            }
            case "pigeonReceivedMessage": {
                this.fillSingerData(source, "kd.metrics.mq.pigeon.received.message.size", data);
                break;
            }
            case "pigeonAckMessage": {
                this.fillSingerData(source, "kd.metrics.mq.pigeon.ack.message.size", data);
                break;
            }
        }
    }

    private void fillSingerData(JSONObject source, String metric, JSONObject data) {
        String xAxis = source.getString("xAxis");
        JSONArray value = data.getJSONArray("value");
        Object meanVa = source.get((Object)metric);
        if (value != null) {
            if (metric.equals("kd.metrics.log.kafka.discardCount")) {
                value.add(meanVa == null ? Integer.valueOf(0) : meanVa);
            } else if (metric.equals("kd.metrics.jvm.memory.heap.usage") || metric.equals("kd.metrics.jvm.memory.non-heap.usage")) {
                value.add((Object)(meanVa == null ? Integer.valueOf(0) : new BigDecimal(meanVa.toString()).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP)));
            } else {
                value.add(meanVa);
            }
            data.getJSONArray("xAxis").add((Object)xAxis);
        } else {
            JSONArray array = new JSONArray();
            if (metric.equals("kd.metrics.log.kafka.discardCount")) {
                array.add(meanVa == null ? Integer.valueOf(0) : meanVa);
            } else if (metric.equals("kd.metrics.jvm.memory.heap.usage") || metric.equals("kd.metrics.jvm.memory.non-heap.usage")) {
                array.add((Object)(meanVa == null ? Integer.valueOf(0) : new BigDecimal(meanVa.toString()).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP)));
            } else {
                array.add(meanVa);
            }
            JSONArray xAxisData = new JSONArray();
            data.put("value", (Object)array);
            xAxisData.add((Object)xAxis);
            data.put("xAxis", (Object)xAxisData);
        }
    }

    private void fillMemoryData(JSONObject source, String metric, JSONObject data) {
        JSONArray max = data.getJSONArray(MAX);
        long maxValue = source.getLongValue(METRIC_MEMORY_PRE + metric + "." + MAX) / 0x100000L;
        long usedValue = source.getLongValue(METRIC_MEMORY_PRE + metric + "." + USED) / 0x100000L;
        long committedValue = source.getLongValue(METRIC_MEMORY_PRE + metric + "." + COMMITTED) / 0x100000L;
        String xAxis = source.getString("xAxis");
        if (max != null) {
            max.add((Object)maxValue);
            data.getJSONArray(USED).add((Object)usedValue);
            data.getJSONArray(COMMITTED).add((Object)committedValue);
            data.getJSONArray("xAxis").add((Object)xAxis);
        } else {
            JSONArray maxData = new JSONArray();
            JSONArray usedData = new JSONArray();
            JSONArray committedData = new JSONArray();
            JSONArray xAxisData = new JSONArray();
            maxData.add((Object)maxValue);
            usedData.add((Object)usedValue);
            committedData.add((Object)committedValue);
            xAxisData.add((Object)xAxis);
            data.put(MAX, (Object)maxData);
            data.put(USED, (Object)usedData);
            data.put(COMMITTED, (Object)committedData);
            data.put("xAxis", (Object)xAxisData);
        }
    }

    private void fillPhysicalMemory(JSONObject source, String metric, JSONObject data) {
        String xAxisValue = source.getString("xAxis");
        JSONArray total = data.getJSONArray("total");
        long totalValue = source.getLongValue(METRIC_SYSTEM + metric + ".total") / 0x100000L;
        long freeValue = source.getLongValue(METRIC_SYSTEM + metric + ".free") / 0x100000L;
        long usedValue = source.getLongValue(METRIC_SYSTEM + metric + ".used") / 0x100000L;
        if (total != null) {
            total.add((Object)totalValue);
            data.getJSONArray("xAxis").add((Object)xAxisValue);
            data.getJSONArray("free").add((Object)freeValue);
            data.getJSONArray(USED).add((Object)usedValue);
        } else {
            JSONArray totalData = new JSONArray();
            JSONArray freeData = new JSONArray();
            JSONArray usedData = new JSONArray();
            totalData.add((Object)totalValue);
            freeData.add((Object)freeValue);
            usedData.add((Object)usedValue);
            JSONArray xAxisData = new JSONArray();
            xAxisData.add((Object)xAxisValue);
            data.put("total", (Object)totalData);
            data.put("free", (Object)freeData);
            data.put(USED, (Object)usedData);
            data.put("xAxis", (Object)xAxisData);
        }
    }

    private JSONObject getAllInstance(String[] indices) {
        JSONObject ret = new JSONObject();
        try {
            Aggregations aggregations;
            SearchRequest searchRequest = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            TermsAggregationBuilder componentBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg_instanceId").field("instanceId.keyword")).size(1000);
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"doc_Source").size(1));
            sourceBuilder.aggregation((AggregationBuilder)componentBuilder);
            sourceBuilder.size(0);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(indices);
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            RestStatus status = searchResponse.status();
            if (status.getStatus() == 200 && (aggregations = searchResponse.getAggregations()) != null) {
                Terms agg_srcService = (Terms)aggregations.get("agg_instanceId");
                for (Terms.Bucket bucket : agg_srcService.getBuckets()) {
                    ParsedTopHits topHits = (ParsedTopHits)bucket.getAggregations().get("doc_Source");
                    SearchHit[] hits = topHits.getHits().getHits();
                    Map sourceAsMap = hits[0].getSourceAsMap();
                    ret.put(sourceAsMap.get("appName") + "\n" + sourceAsMap.get("ip"), (Object)"dead");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public JSONObject queryTopoServiceInstances(Date from, Date to, String source, String target, String minDuration) {
        JSONObject topoData = new JSONObject();
        try {
            SearchRequest searchRequest = new SearchRequest();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)DURATION_MICROS).gte((Object)(Integer.parseInt(minDuration) * 1000)));
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)from.getTime()).lte((Object)to.getTime()));
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"srcService.keyword", (String[])new String[]{source}));
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"descService.keyword", (String[])new String[]{target}));
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            TermsAggregationBuilder componentBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGG_SRC_SERVICE).field("srcServiceInstanceId.keyword")).size(2000);
            TermsAggregationBuilder componentBuilder2 = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"destInstances").field("descServiceInstanceId.keyword")).size(2000);
            TermsAggregationBuilder destInstanceType = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"destInstanceType").field("destServiceType.keyword")).size(1);
            TermsAggregationBuilder destComponentType = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"destComponentType").field("destComponent.keyword")).size(1);
            TermsAggregationBuilder destInstanceConponent = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"destInstanceProtocol").field("protocol.keyword")).size(1);
            componentBuilder2.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)"avg_time").field(DURATION_MICROS));
            componentBuilder2.subAggregation((AggregationBuilder)destInstanceType);
            componentBuilder2.subAggregation((AggregationBuilder)destInstanceConponent);
            componentBuilder2.subAggregation((AggregationBuilder)destComponentType);
            componentBuilder.subAggregation((AggregationBuilder)componentBuilder2);
            sourceBuilder.aggregation((AggregationBuilder)componentBuilder);
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            sourceBuilder.size(0);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(from, to, Constant.TOPOLOGY_SERVICE_PRE));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            Aggregations aggregations = searchResponse.getAggregations();
            HashSet nodes = new HashSet(32);
            HashSet edges = new HashSet(32);
            topoData.put("nodes", nodes);
            topoData.put("edges", edges);
            if (aggregations != null) {
                Terms agg_srcService = (Terms)aggregations.get(AGG_SRC_SERVICE);
                boolean added = false;
                for (Terms.Bucket bucket : agg_srcService.getBuckets()) {
                    String key = bucket.getKeyAsString();
                    HashMap<String, String> node = new HashMap<String, String>(8);
                    node.put(ID, key);
                    node.put("node_type", CLOUD);
                    if (this.isUserNodeForTopo(key)) {
                        node.put("label", key);
                    } else {
                        node.put("label", "{#instance#}\n" + key);
                    }
                    nodes.add(node);
                    Aggregations destInstancesAgg = bucket.getAggregations();
                    Terms destInstancesTerms = (Terms)destInstancesAgg.get("destInstances");
                    for (Terms.Bucket bucketDest : destInstancesTerms.getBuckets()) {
                        String tipCost;
                        BigDecimal bigDecimal;
                        String destInstanceId = bucketDest.getKeyAsString();
                        ParsedAvg avg_time = (ParsedAvg)bucketDest.getAggregations().get("avg_time");
                        Terms destServiceInstanceTypeTerm = (Terms)bucketDest.getAggregations().get("destInstanceType");
                        String destServiceInstanceType = ((Terms.Bucket)destServiceInstanceTypeTerm.getBuckets().get(0)).getKeyAsString();
                        Terms destServiceInstanceProtocolTerm = (Terms)bucketDest.getAggregations().get("destInstanceProtocol");
                        String destServiceInstanceProtocol = ((Terms.Bucket)destServiceInstanceProtocolTerm.getBuckets().get(0)).getKeyAsString();
                        Terms destComponentTypeTerm = (Terms)bucketDest.getAggregations().get("destComponentType");
                        String destComponentTypeStr = ((Terms.Bucket)destComponentTypeTerm.getBuckets().get(0)).getKeyAsString();
                        bucketDest.getAggregations().get("avg_time");
                        double value = avg_time.getValue();
                        HashMap<String, Object> edge = new HashMap<String, Object>(8);
                        edge.put("source", key);
                        edge.put("target", destInstanceId);
                        if (destServiceInstanceType.equals("component")) {
                            edge.put("edge_type", destComponentTypeStr);
                        } else {
                            edge.put("edge_type", CLOUD);
                        }
                        edge.put("level", 4);
                        edge.put("avg_time", value);
                        if (value >= 1000.0) {
                            bigDecimal = BigDecimal.valueOf(value / 1000.0);
                            tipCost = bigDecimal.setScale(0, RoundingMode.HALF_UP).doubleValue() + "ms";
                        } else {
                            bigDecimal = BigDecimal.valueOf(value);
                            tipCost = bigDecimal.setScale(2, RoundingMode.HALF_UP).doubleValue() + "\u03bcs";
                        }
                        edge.put("label", "Cost:" + tipCost);
                        edge.put("tipCalls", bucketDest.getDocCount());
                        edge.put("tipCost", tipCost);
                        edges.add(edge);
                        if (added) continue;
                        node = new HashMap(8);
                        node.put(ID, destInstanceId);
                        if (destServiceInstanceType.equals("component")) {
                            node.put("node_type", destComponentTypeStr);
                            node.put("label", destInstanceId);
                        } else {
                            node.put("label", "{#instance#}\n" + destInstanceId);
                            node.put("node_type", CLOUD);
                        }
                        nodes.add(node);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("query topo error,", (Throwable)e);
        }
        return topoData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject queryTopo(Date from, Date to, String source, String target, String minDuration) {
        JSONObject topoData = new JSONObject();
        try {
            SearchRequest searchRequest = new SearchRequest();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)DURATION_MICROS).gte((Object)(Integer.parseInt(minDuration) * 1000)));
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)from.getTime()).lte((Object)to.getTime()));
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            TermsAggregationBuilder aggSrcServiceBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGG_SRC_SERVICE).executionHint("map").field("srcService.keyword")).collectMode(Aggregator.SubAggCollectionMode.BREADTH_FIRST).size(2000);
            TermsAggregationBuilder aggSrcServiceTypeBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGG_SRC_SERVICE_TYPE).executionHint("map").field("srcServiceType.keyword")).collectMode(Aggregator.SubAggCollectionMode.BREADTH_FIRST).size(2000);
            TermsAggregationBuilder aggSrcServiceInstancesBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"srcServiceInstances").executionHint("map").field("srcServiceInstanceId.keyword")).collectMode(Aggregator.SubAggCollectionMode.BREADTH_FIRST).size(2000);
            TermsAggregationBuilder destServiceBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"destService").executionHint("map").field("descService.keyword")).collectMode(Aggregator.SubAggCollectionMode.BREADTH_FIRST).size(2000);
            aggSrcServiceBuilder.subAggregation((AggregationBuilder)aggSrcServiceTypeBuilder);
            aggSrcServiceBuilder.subAggregation((AggregationBuilder)destServiceBuilder);
            aggSrcServiceBuilder.subAggregation((AggregationBuilder)aggSrcServiceInstancesBuilder);
            TermsAggregationBuilder destServiceTypeBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGG_DESC_SERVICE_TYPE).executionHint("map").field("destServiceType.keyword")).collectMode(Aggregator.SubAggCollectionMode.BREADTH_FIRST).size(1);
            TermsAggregationBuilder destServiceProtocolBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"protocol").executionHint("map").field("protocol.keyword")).collectMode(Aggregator.SubAggCollectionMode.BREADTH_FIRST).size(2000);
            TermsAggregationBuilder destInstancesBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"destInstances").executionHint("map").field("descServiceInstanceId.keyword")).collectMode(Aggregator.SubAggCollectionMode.BREADTH_FIRST).size(100);
            AvgAggregationBuilder avgDescServiceBuilder = (AvgAggregationBuilder)AggregationBuilders.avg((String)"avg_time").field(DURATION_MICROS);
            destServiceBuilder.subAggregation((AggregationBuilder)destServiceTypeBuilder);
            destServiceBuilder.subAggregation((AggregationBuilder)avgDescServiceBuilder);
            destServiceBuilder.subAggregation((AggregationBuilder)destInstancesBuilder);
            destServiceBuilder.subAggregation((AggregationBuilder)destServiceProtocolBuilder);
            sourceBuilder.aggregation((AggregationBuilder)aggSrcServiceBuilder);
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            sourceBuilder.size(0);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(from, to, Constant.TOPOLOGY_SERVICE_PRE));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            long startTime = System.currentTimeMillis();
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            Aggregations aggregations = searchResponse.getAggregations();
            HashSet<String> componentExist = new HashSet<String>(16);
            HashSet nodes = new HashSet(10);
            HashSet edges = new HashSet(10);
            topoData.put("nodes", nodes);
            topoData.put("edges", edges);
            if (aggregations != null) {
                Terms agg_srcService = (Terms)aggregations.get(AGG_SRC_SERVICE);
                for (Terms.Bucket bucket : agg_srcService.getBuckets()) {
                    String key = bucket.getKeyAsString();
                    if (key.contains("User-")) {
                        System.out.println(1);
                    }
                    Terms srcServiceTypeTerm = (Terms)bucket.getAggregations().get(AGG_SRC_SERVICE_TYPE);
                    String srcServiceType = ((Terms.Bucket)srcServiceTypeTerm.getBuckets().get(0)).getKeyAsString();
                    HashMap<String, Object> node = new HashMap<String, Object>(8);
                    if (!componentExist.contains(key)) {
                        node = new HashMap(8);
                        node.put(ID, key);
                        if (this.isUserNodeForTopo(key)) {
                            node.put("label", key);
                        } else {
                            Terms srcInstances = (Terms)bucket.getAggregations().get("srcServiceInstances");
                            node.put("label", srcInstances.getBuckets().size() + NODE_PLACEHOLDER + "\n" + key);
                            node.put("node_type", CLOUD);
                            ArrayList<String> instances = new ArrayList<String>(10);
                            for (Terms.Bucket bucketInstance : srcInstances.getBuckets()) {
                                instances.add(bucketInstance.getKeyAsString());
                            }
                            node.put("instances", instances);
                        }
                        nodes.add(node);
                        componentExist.add(key);
                    }
                    Terms agg_descService = (Terms)bucket.getAggregations().get("destService");
                    for (Terms.Bucket bucket1 : agg_descService.getBuckets()) {
                        String tipCost;
                        BigDecimal bigDecimal;
                        Terms destServiceTypeTerm = (Terms)bucket1.getAggregations().get(AGG_DESC_SERVICE_TYPE);
                        String destServiceType = ((Terms.Bucket)destServiceTypeTerm.getBuckets().get(0)).getKeyAsString();
                        HashMap<String, Object> edge = new HashMap<String, Object>(8);
                        edge.put("source", key);
                        String keyAsString = bucket1.getKeyAsString();
                        Terms destInstances = (Terms)bucket1.getAggregations().get("destInstances");
                        edge.put("target", keyAsString);
                        String destServiceProtocol = "";
                        if (destServiceType.equals("component")) {
                            Terms destServiceProtocolTerm = (Terms)bucket1.getAggregations().get("protocol");
                            destServiceProtocol = ((Terms.Bucket)destServiceProtocolTerm.getBuckets().get(0)).getKeyAsString();
                            edge.put("level", 3);
                            edge.put("edge_type", keyAsString);
                        } else {
                            edge.put("level", 1);
                            edge.put("edge_type", CLOUD);
                        }
                        ParsedAvg avg_time = (ParsedAvg)bucket1.getAggregations().get("avg_time");
                        double value = avg_time.getValue();
                        edge.put("avg_time", value);
                        if (value >= 1000.0) {
                            bigDecimal = BigDecimal.valueOf(value / 1000.0);
                            tipCost = bigDecimal.setScale(2, RoundingMode.HALF_UP).doubleValue() + "ms";
                        } else {
                            bigDecimal = BigDecimal.valueOf(value);
                            tipCost = bigDecimal.setScale(2, RoundingMode.HALF_UP).doubleValue() + "\u03bcs";
                        }
                        edge.put("tipCalls", bucket1.getDocCount());
                        edge.put("tipCost", tipCost);
                        edge.put("label", "Cost:" + tipCost);
                        if (!componentExist.contains(keyAsString)) {
                            node = new HashMap();
                            ArrayList<String> instances = new ArrayList<String>(10);
                            for (Terms.Bucket bucketInstance : destInstances.getBuckets()) {
                                instances.add(bucketInstance.getKeyAsString());
                            }
                            if (destServiceType.equals("component")) {
                                node.put("protocol", destServiceProtocol);
                                node.put("node_type", keyAsString);
                            } else {
                                node.put("node_type", CLOUD);
                            }
                            node.put("instances", instances);
                            node.put(ID, keyAsString);
                            Integer integer = destInstances.getBuckets().size();
                            node.put("label", integer + NODE_PLACEHOLDER + "\n" + keyAsString);
                            nodes.add(node);
                            componentExist.add(keyAsString);
                        }
                        edges.add(edge);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("query topo error,", (Throwable)e);
        }
        finally {
            List<String> activeNodes = this.activeNodesJson();
            topoData.put("activeNodes", activeNodes);
        }
        return topoData;
    }

    private boolean isUserNodeForTopo(String nodeId) {
        return "User-mobile".equals(nodeId) || "User-api".equals(nodeId) || "User-web".equals(nodeId);
    }

    @Override
    public JSONObject queryApiInvoker(Date from, Date to, String source, String target, String apiName) {
        JSONObject topoData = new JSONObject();
        try {
            SearchRequest searchRequest = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)COLLECTION_TIME).gte((Object)from.getTime()).lte((Object)to.getTime()));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"appName.keyword", (String[])new String[]{source.contains("User-") ? "gateway" : source}));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"destInstance.keyword", (String[])new String[]{target}));
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(from, to, Constant.API_CALL_DATA));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            ArrayList<Map> apis = new ArrayList<Map>(32);
            if (StringUtils.isEmpty((String)apiName)) {
                TermsAggregationBuilder componentBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg_signature").field(SIGNATURE_KEYWORD)).size(Integer.getInteger("monitor.apicall.limit.es.count", 2000).intValue());
                componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)"avg_time").field(DURATION_MICROS));
                sourceBuilder.aggregation((AggregationBuilder)componentBuilder);
                sourceBuilder.size(0);
                SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
                Aggregations aggregations = searchResponse.getAggregations();
                if (aggregations != null) {
                    Terms signature = (Terms)aggregations.get("agg_signature");
                    for (Terms.Bucket bucket : signature.getBuckets()) {
                        HashMap<String, Object> statsMap = new HashMap<String, Object>(3);
                        statsMap.put("count", bucket.getDocCount());
                        ParsedAvg avg_time = (ParsedAvg)bucket.getAggregations().get("avg_time");
                        statsMap.put("time", avg_time.getValue());
                        statsMap.put("apiName", bucket.getKeyAsString());
                        apis.add(statsMap);
                    }
                }
            } else {
                SearchHit[] hits;
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)SIGNATURE_KEYWORD, (String[])new String[]{apiName}));
                sourceBuilder.size(2000);
                SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
                for (SearchHit hit : hits = searchResponse.getHits().getHits()) {
                    apis.add(hit.getSourceAsMap());
                }
            }
            topoData.put("data", apis);
        }
        catch (Exception e) {
            logger.error("query topo error,", (Throwable)e);
            topoData.put("data", Collections.emptyList());
        }
        return topoData;
    }

    @Override
    public JSONObject queryComponentTopo(Date from, Date to, String source, String target, String type) {
        JSONObject topoData = new JSONObject();
        try {
            SearchRequest searchRequest = new SearchRequest();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)from.getTime()).lte((Object)to.getTime()));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"srcService.keyword", (String[])new String[]{source}));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"destComponent.keyword", (String[])new String[]{type}));
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            TermsAggregationBuilder componentBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGG_SRC_SERVICE).field("srcServiceInstanceId.keyword")).size(2000);
            TermsAggregationBuilder componentBuilder2 = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"destInstances").field("descService.keyword")).size(2000);
            componentBuilder2.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)"avg_time").field(DURATION_MICROS));
            componentBuilder.subAggregation((AggregationBuilder)componentBuilder2);
            sourceBuilder.aggregation((AggregationBuilder)componentBuilder);
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            sourceBuilder.size(0);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(from, to, Constant.TOPOLOGY_PRE));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            Aggregations aggregations = searchResponse.getAggregations();
            HashSet nodes = new HashSet(32);
            HashSet edges = new HashSet(32);
            topoData.put("nodes", nodes);
            topoData.put("edges", edges);
            String componentId = type + target;
            if (aggregations != null) {
                Terms agg_srcService = (Terms)aggregations.get(AGG_SRC_SERVICE);
                boolean added = false;
                for (Terms.Bucket bucket : agg_srcService.getBuckets()) {
                    String key = bucket.getKeyAsString();
                    HashMap<String, String> node = new HashMap<String, String>(8);
                    node.put(ID, key);
                    node.put("node_type", CLOUD);
                    if (this.isUserNodeForTopo(key)) {
                        node.put("label", key);
                    } else {
                        node.put("label", "{#instance#}\n" + key);
                    }
                    nodes.add(node);
                    Aggregations destInstancesAgg = bucket.getAggregations();
                    Terms destInstancesTerms = (Terms)destInstancesAgg.get("destInstances");
                    for (Terms.Bucket bucketDest : destInstancesTerms.getBuckets()) {
                        String tipCost;
                        BigDecimal bigDecimal;
                        componentId = bucketDest.getKeyAsString();
                        ParsedAvg avg_time = (ParsedAvg)bucketDest.getAggregations().get("avg_time");
                        double value = avg_time.getValue();
                        HashMap<String, Object> edge = new HashMap<String, Object>(8);
                        edge.put("source", key);
                        edge.put("target", componentId);
                        edge.put("edge_type", type);
                        edge.put("level", 4);
                        edge.put("avg_time", value);
                        if (value > 1000.0) {
                            bigDecimal = BigDecimal.valueOf(value / 1000.0);
                            tipCost = bigDecimal.setScale(2, RoundingMode.HALF_UP).doubleValue() + "ms";
                        } else {
                            bigDecimal = BigDecimal.valueOf(value);
                            tipCost = bigDecimal.setScale(2, RoundingMode.HALF_UP).doubleValue() + "\u03bcs";
                        }
                        edge.put("label", "Cost:" + tipCost);
                        edge.put("tipCalls", bucketDest.getDocCount());
                        edge.put("tipCost", tipCost);
                        edges.add(edge);
                        if (added) continue;
                        node = new HashMap(8);
                        node.put(ID, componentId);
                        node.put("label", componentId);
                        node.put("node_type", type);
                        nodes.add(node);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("query topo error,", (Throwable)e);
        }
        return topoData;
    }

    @Override
    public JSONObject queryComponentInvoker(Date from, Date to, String source, String target, String type, String apiName) {
        JSONObject topoData = new JSONObject();
        try {
            SearchRequest searchRequest = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp_millis").gte((Object)from.getTime()).lte((Object)to.getTime()));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"instanceId.keyword", (String)source));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tags.topology.destComponent.keyword", (String)type));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tags.topology.descService.keyword", (String)target));
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(from, to, Constant.SWORD_SPAN_DATA));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            ArrayList apis = new ArrayList(32);
            if (StringUtils.isEmpty((String)apiName)) {
                TermsAggregationBuilder componentBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"type_signature").field("serviceName.keyword")).size(2000);
                TermsAggregationBuilder name_signature = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"name_signature").field("name.keyword")).size(2000);
                name_signature.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)"avg_time").field(DURATION));
                componentBuilder.subAggregation((AggregationBuilder)name_signature);
                sourceBuilder.aggregation((AggregationBuilder)componentBuilder);
                sourceBuilder.size(0);
                SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
                Aggregations aggregations = searchResponse.getAggregations();
                if (aggregations != null) {
                    Terms type_signature = (Terms)aggregations.get("type_signature");
                    for (Terms.Bucket bucket : type_signature.getBuckets()) {
                        String typeName = bucket.getKeyAsString();
                        Terms name_agg = (Terms)bucket.getAggregations().get("name_signature");
                        for (Terms.Bucket aggBucket : name_agg.getBuckets()) {
                            String methodName = aggBucket.getKeyAsString();
                            HashMap<String, Object> statsMap = new HashMap<String, Object>(3);
                            statsMap.put("count", aggBucket.getDocCount());
                            ParsedAvg avg_time = (ParsedAvg)aggBucket.getAggregations().get("avg_time");
                            statsMap.put("time", avg_time.getValue());
                            statsMap.put("apiName", typeName + "#" + methodName);
                            apis.add(statsMap);
                        }
                    }
                }
            } else {
                SearchHit[] hits;
                String[] strings = apiName.split("#");
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"serviceName.keyword", (String)strings[0]));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"name.keyword", (String)strings[1]));
                sourceBuilder.size(2000);
                SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
                for (SearchHit hit : hits = searchResponse.getHits().getHits()) {
                    HashMap apiData = new HashMap(8);
                    Map sourceAsMap = hit.getSourceAsMap();
                    apiData.put("traceId", sourceAsMap.get("traceId"));
                    apiData.put(COLLECTION_TIME, sourceAsMap.get("timestamp_millis"));
                    Map tags = (Map)sourceAsMap.get("tags");
                    apiData.put(CLOUD, tags.get(APP_ID));
                    apiData.put("srcIp", source);
                    apiData.put("destIp", target);
                    apiData.put(DURATION_MICROS, sourceAsMap.get(DURATION));
                    apis.add(apiData);
                }
            }
            topoData.put("data", apis);
        }
        catch (Exception e) {
            logger.error("query topo error,", (Throwable)e);
            topoData.put("data", Collections.emptyList());
        }
        return topoData;
    }

    private JSONObject queryComponent(Date from, Date to) {
        JSONObject ret = new JSONObject();
        HashSet<String> exsitNodes = new HashSet<String>(10);
        try {
            SearchRequest searchRequest = new SearchRequest();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)from.getTime()).lte((Object)to.getTime()));
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            TermsAggregationBuilder srcService = ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGG_SRC_SERVICE).field("srcService.keyword")).size(2000);
            TermsAggregationBuilder componentBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGG_DESC_SERVICE).field("destComponent.keyword")).size(2000);
            componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)"avg_time").field(DURATION_MICROS));
            componentBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"protocol").field("protocol.keyword")).size(2000));
            componentBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"componentInstances").field("descService.keyword")).size(2000));
            srcService.subAggregation((AggregationBuilder)componentBuilder);
            srcService.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"srcServiceInstances").field("srcServiceInstanceId.keyword")).size(2000));
            sourceBuilder.aggregation((AggregationBuilder)srcService);
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            sourceBuilder.size(0);
            searchRequest.source(sourceBuilder);
            searchRequest.indices(ElasticsearchClient.getIndices(from, to, Constant.TOPOLOGY_PRE));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
            long start = System.currentTimeMillis();
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            logger.info("Topo component es used time={}", (Object)(System.currentTimeMillis() - start));
            Aggregations aggregations = searchResponse.getAggregations();
            HashSet nodes = new HashSet(32);
            HashSet edges = new HashSet(32);
            ret.put("nodes", nodes);
            ret.put("edges", edges);
            if (aggregations != null) {
                Terms srcServiceBucket = (Terms)aggregations.get(AGG_SRC_SERVICE);
                for (Terms.Bucket bucket : srcServiceBucket.getBuckets()) {
                    String serviceKey = bucket.getKeyAsString();
                    Terms descServiceBucket = (Terms)bucket.getAggregations().get(AGG_DESC_SERVICE);
                    Terms srcServiceInstBucket = (Terms)bucket.getAggregations().get("srcServiceInstances");
                    HashMap<String, Object> node = new HashMap<String, Object>(8);
                    if (exsitNodes.contains(serviceKey)) continue;
                    node = new HashMap(8);
                    node.put(ID, serviceKey);
                    if (this.isUserNodeForTopo(serviceKey)) {
                        node.put("label", serviceKey);
                        continue;
                    }
                    node.put("label", srcServiceInstBucket.getBuckets().size() + NODE_PLACEHOLDER + "\n" + serviceKey);
                    node.put("node_type", CLOUD);
                    ArrayList<String> instances = new ArrayList<String>(10);
                    for (Terms.Bucket bucketInstance : srcServiceInstBucket.getBuckets()) {
                        instances.add(bucketInstance.getKeyAsString());
                    }
                    node.put("instances", instances);
                    for (Terms.Bucket bucketComponent : descServiceBucket.getBuckets()) {
                        String tipCost;
                        BigDecimal bigDecimal;
                        HashMap<String, Object> componentNode = new HashMap<String, Object>(8);
                        String componentKey = bucketComponent.getKeyAsString();
                        long callNums = bucketComponent.getDocCount();
                        ParsedAvg avg_time = (ParsedAvg)bucketComponent.getAggregations().get("avg_time");
                        double value = avg_time.getValue();
                        if (!exsitNodes.contains(componentKey)) {
                            componentNode.put(ID, componentKey);
                            componentNode.put("label", componentKey);
                            ArrayList<String> instancesComponent = new ArrayList<String>(10);
                            Terms descServiceInstanceBucket = (Terms)bucketComponent.getAggregations().get("componentInstances");
                            Terms protocolBucket = (Terms)bucketComponent.getAggregations().get("protocol");
                            String protocol = ((Terms.Bucket)protocolBucket.getBuckets().get(0)).getKeyAsString();
                            componentNode.put("protocol", protocol);
                            for (Terms.Bucket bucketComponentInst : descServiceInstanceBucket.getBuckets()) {
                                String key = bucketComponentInst.getKeyAsString().replace("redis:", "");
                                key = key.replace("/", "");
                                instancesComponent.add(key);
                            }
                            componentNode.put("instances", instancesComponent);
                            componentNode.put("node_type", componentKey);
                            exsitNodes.add(componentKey);
                            nodes.add(componentNode);
                        }
                        if (value > 1000.0) {
                            bigDecimal = BigDecimal.valueOf(value / 1000.0);
                            tipCost = bigDecimal.setScale(2, RoundingMode.HALF_UP).doubleValue() + "ms";
                        } else {
                            bigDecimal = BigDecimal.valueOf(value);
                            tipCost = bigDecimal.setScale(2, RoundingMode.HALF_UP).doubleValue() + "\u03bcs";
                        }
                        HashMap<String, Object> edge = new HashMap<String, Object>(8);
                        edge.put("source", serviceKey);
                        edge.put("target", componentKey);
                        edge.put("level", 3);
                        edge.put("edge_type", componentKey);
                        edge.put("avg_time", value);
                        edge.put("label", "Cost:" + tipCost);
                        edge.put("tipCalls", bucket.getDocCount());
                        edge.put("tipCost", tipCost);
                        edges.add(edge);
                    }
                    exsitNodes.add(serviceKey);
                    nodes.add(node);
                }
                ret.put("existNodes", exsitNodes);
            }
        }
        catch (Exception e) {
            logger.error("query component topo error");
        }
        return ret;
    }

    public Map<String, Integer> getAppNameStat() {
        ConcurrentHashMap<String, Integer> appNamesCounts = new ConcurrentHashMap<String, Integer>(8);
        try {
            Map nodesMap = ClusterInstances.getAllOriginNodesString();
            for (Map.Entry entry : nodesMap.entrySet()) {
                Map serviceInfo = (Map)JSONUtils.cast((String)((String)entry.getValue()), Map.class, (boolean)true);
                String appName = (String)serviceInfo.get("appName");
                if (appNamesCounts.containsKey(appName)) {
                    int count = (Integer)appNamesCounts.get(appName);
                    appNamesCounts.put(appName, ++count);
                    continue;
                }
                appNamesCounts.put(appName, 1);
            }
        }
        catch (Exception e) {
            logger.error("get nodes error from zookeeper", (Throwable)e);
        }
        return appNamesCounts;
    }

    public List<String> activeNodesJson() {
        ArrayList<String> nodeList = new ArrayList<String>(10);
        try {
            Map nodesMap = ClusterInstances.getAllOriginNodesString();
            for (Map.Entry entry : nodesMap.entrySet()) {
                nodeList.add((String)entry.getKey());
            }
        }
        catch (Exception e) {
            logger.error("get nodes error from zookeeper", (Throwable)e);
        }
        return nodeList;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$init$0(SSLContext sslContext, CredentialsProvider credentialsProvider, IOReactorConfig.Builder custom, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.disableAuthCaching();
        httpClientBuilder.setSSLContext(sslContext);
        httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setDefaultIOReactorConfig(custom.build());
    }
}

