/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.util.FileUtils;
import kd.bos.util.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.action.main.MainResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchUtil {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchUtil.class);
    private static final Map<String, Byte> versionMap = new ConcurrentHashMap<String, Byte>();
    private static final Map<String, AtomicInteger> errorTimes = new HashMap<String, AtomicInteger>();

    public static int getVersion(ElasticsearchConfig elasticsearchConfig) {
        String esId = elasticsearchConfig.getIp() + ":" + elasticsearchConfig.getPort();
        Byte version = versionMap.get(esId);
        if (version != null) {
            return version.byteValue();
        }
        try {
            ElasticSearchUtil.initVersion(elasticsearchConfig);
        }
        catch (Exception e) {
            AtomicInteger atomicInteger = errorTimes.get(esId);
            if (atomicInteger == null) {
                errorTimes.putIfAbsent(esId, new AtomicInteger(1));
            } else {
                if (atomicInteger.get() >= 3) {
                    versionMap.putIfAbsent(esId, Byte.valueOf("6"));
                    return 6;
                }
                atomicInteger.incrementAndGet();
            }
            logger.error("init version error", (Throwable)e);
            throw new KDException(BosErrorCode.systemError, new Object[]{e.getMessage()});
        }
        return versionMap.get(esId).byteValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initVersion(String ip, int port, String userName, String np) throws IOException {
        byte version = 0;
        try (RestHighLevelClient esClient = null;){
            IOReactorConfig.Builder custom = IOReactorConfig.custom();
            IOReactorConfig.Builder.setDefaultMaxIoThreadCount((int)2);
            custom.setIoThreadCount(2);
            if (userName != null && np != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, np));
                esClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(ip, port)}).setHttpClientConfigCallback(arg_0 -> ElasticSearchUtil.lambda$initVersion$0((CredentialsProvider)credentialsProvider, custom, arg_0)));
            } else {
                esClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(ip, port, "http")}).setHttpClientConfigCallback(httpClientBuilder -> {
                    httpClientBuilder.disableAuthCaching();
                    return httpClientBuilder.setDefaultIOReactorConfig(custom.build());
                }));
            }
            MainResponse info = esClient.info(RequestOptions.DEFAULT);
            version = info.getVersion().major;
            versionMap.put(ip + ":" + port, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initVersion(ElasticsearchConfig elasticsearchConfig) throws Exception {
        byte version = 0;
        try (RestHighLevelClient esClient = null;){
            SSLContext sslContext;
            String userName = elasticsearchConfig.getUserName();
            String password = elasticsearchConfig.getPassword();
            IOReactorConfig.Builder custom = IOReactorConfig.custom();
            IOReactorConfig.Builder.setDefaultMaxIoThreadCount((int)2);
            custom.setIoThreadCount(2);
            if ("https".equals(elasticsearchConfig.getSchema())) {
                if (StringUtils.isEmpty((String)elasticsearchConfig.getCertPath())) {
                    SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy());
                    sslContext = sslContextBuilder.build();
                } else {
                    Path trustStorePath = Paths.get(FileUtils.checkFileUrl((String)elasticsearchConfig.getCertPath()), new String[0]);
                    KeyStore trustStore = KeyStore.getInstance("pkcs12");
                    trustStore.load(Files.newInputStream(trustStorePath, new OpenOption[0]), elasticsearchConfig.getCertPassword().toCharArray());
                    SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial(trustStore, null);
                    sslContext = sslContextBuilder.build();
                }
            } else {
                sslContext = null;
            }
            if (userName != null && password != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
                esClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(elasticsearchConfig.getIp(), elasticsearchConfig.getPort(), elasticsearchConfig.getSchema())}).setHttpClientConfigCallback(arg_0 -> ElasticSearchUtil.lambda$initVersion$2(sslContext, (CredentialsProvider)credentialsProvider, custom, arg_0)));
            } else {
                esClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(elasticsearchConfig.getIp(), elasticsearchConfig.getPort(), elasticsearchConfig.getSchema())}).setHttpClientConfigCallback(httpClientBuilder -> {
                    httpClientBuilder.disableAuthCaching();
                    httpClientBuilder.setSSLContext(sslContext);
                    httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    return httpClientBuilder.setDefaultIOReactorConfig(custom.build());
                }));
            }
            MainResponse info = esClient.info(RequestOptions.DEFAULT);
            version = info.getVersion().major;
            versionMap.putIfAbsent(elasticsearchConfig.getIp() + ":" + elasticsearchConfig.getPort(), version);
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$initVersion$2(SSLContext sslContext, CredentialsProvider credentialsProvider, IOReactorConfig.Builder custom, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.disableAuthCaching();
        httpClientBuilder.setSSLContext(sslContext);
        httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setDefaultIOReactorConfig(custom.build());
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$initVersion$0(CredentialsProvider credentialsProvider, IOReactorConfig.Builder custom, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.disableAuthCaching();
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setDefaultIOReactorConfig(custom.build());
    }

    static {
        try {
            ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig();
            ElasticSearchUtil.initVersion(elasticsearchConfig);
        }
        catch (Throwable e) {
            logger.error("get elasticsearch server version error", e);
        }
    }
}

