/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.orm.datasync.ColumnInfo;
import kd.bos.orm.datasync.UpsertDataSyncValue;

public class InsertDataSyncValue
extends UpsertDataSyncValue {
    private static final long serialVersionUID = 6408625411865394893L;
    Map<String, List<Object>> hasInitEntityOids = new ConcurrentHashMap<String, List<Object>>(1);

    public InsertDataSyncValue(String tableName, String entityNumber, boolean isLocal) {
        super(tableName, entityNumber, isLocal);
    }

    public void setColumnsLs(DbMetadataColumn[] columns, String pkstr, String parentPkStr) {
        ArrayList<ColumnInfo> columnsLs = new ArrayList<ColumnInfo>();
        for (DbMetadataColumn column : columns) {
            ColumnInfo ci = new ColumnInfo();
            ci.setFiledName(column.getName());
            ci.setDbtype(column.getDbType());
            ci.setColumnIndex(column.getColumnIndex());
            if (column.getName().equalsIgnoreCase(pkstr)) {
                this.tablePkField = ci;
                this.tablePkFieldStr = pkstr;
                if (this.entityPkField == null) {
                    this.entityPkField = ci;
                    this.entitPkFieldStr = pkstr;
                }
            }
            if (column.getName().equalsIgnoreCase(parentPkStr)) {
                this.entityPkField = ci;
                this.entitPkFieldStr = parentPkStr;
            }
            columnsLs.add(ci);
        }
        this.setColumnsLs(columnsLs);
    }

    @Override
    public List<Object> getEntityOids() {
        this.hasInitEntityOids.computeIfAbsent("EntityOids", k -> {
            this.entityOids = new ArrayList();
            ColumnInfo cp = this.getEntityPkField();
            if (cp != null) {
                for (Object[] row : this.getRows()) {
                    this.entityOids.add(row[cp.getColumnIndex()]);
                }
            }
            return this.entityOids;
        });
        return this.entityOids;
    }

    @Override
    public List<Object> getTableOids() {
        this.hasInitEntityOids.computeIfAbsent("TableOids", k -> {
            this.tableOids = new ArrayList();
            ColumnInfo cp = this.getTablePkField();
            if (cp != null) {
                for (Object[] row : this.getRows()) {
                    this.tableOids.add(row[cp.getColumnIndex()]);
                }
            }
            return this.tableOids;
        });
        return this.tableOids;
    }
}

