/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync.agent;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.DataCacheReader;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datasync.agent.TableInfo;

public class CollectEntityTableUtil {
    private static final Log log = LogFactory.getLog(CollectEntityTableUtil.class);
    private static Class<?> linkEntryType;
    private static Class<?> mulBasedataPropType;

    public static IDataEntityType getDataEntityType(String entityNumber) {
        DynamicObjectType dt;
        String[] entityNames = entityNumber.split("\\.");
        try {
            dt = DataCacheReader.get().getDataEntityType(entityNames[0]);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{"collectEntityTables getDataEntityType error"});
        }
        if (entityNames.length == 1) {
            return dt;
        }
        DynamicObjectType ret = dt;
        for (int i = 1; i < entityNames.length; ++i) {
            String entityName = entityNames[i].trim();
            IDataEntityProperty dp = (IDataEntityProperty)ret.getProperties().get((Object)entityName);
            if (dp instanceof ICollectionProperty) {
                ret = ((ICollectionProperty)dp).getItemType();
                continue;
            }
            if (dp instanceof IComplexProperty) {
                ret = ((IComplexProperty)dp).getComplexType();
                continue;
            }
            throw new IllegalArgumentException(entityName + " is not an entity.");
        }
        return ret;
    }

    public static Set<TableInfo> collectEntityTables(String entitynumber) {
        IDataEntityType dt = CollectEntityTableUtil.getDataEntityType(entitynumber);
        HashSet<TableInfo> ret = new HashSet<TableInfo>(1);
        String pkField = dt.getPrimaryKey().getAlias();
        TableInfo rootTable = new TableInfo(dt.getName().toLowerCase(), dt.getAlias(), pkField, pkField, pkField, null);
        ret.add(rootTable);
        CollectEntityTableUtil.collectEntityTables(dt, true, rootTable, ret);
        return ret;
    }

    private static void collectEntityTables(IDataEntityType dt, boolean rootDT, TableInfo parent, Set<TableInfo> set) {
        TableInfo currentTableInfo = parent;
        if (!rootDT) {
            String pkField = dt.getParent().getPrimaryKey().getAlias();
            String relationField = null;
            if (IEntryType.class.isAssignableFrom(dt.getClass()) && dt.getParent().getProperties().get((Object)dt.getName()) instanceof ICollectionProperty) {
                relationField = ((ICollectionProperty)dt.getParent().getProperties().get((Object)dt.getName())).getFkFieldName();
            }
            if (relationField == null) {
                relationField = pkField;
            }
            String childrenName = parent.getName() + '.' + dt.getName().toLowerCase();
            TableInfo children = new TableInfo(childrenName, dt.getAlias(), CollectEntityTableUtil.getDataEntityType(childrenName).getPrimaryKey().getAlias(), relationField, pkField, parent);
            set.add(children);
            currentTableInfo = children;
        }
        HashSet<TableInfo> childList = new HashSet<TableInfo>();
        HashSet<String> tableGroupSet = new HashSet<String>();
        DataEntityPropertyCollection dps = dt.getProperties();
        int n = dps.size();
        for (int i = 0; i < n; ++i) {
            IDataEntityProperty dp = (IDataEntityProperty)dps.get(i);
            CollectEntityTableUtil.collectEntityTables(dp, tableGroupSet, currentTableInfo, childList);
        }
        String pkField = dt.getPrimaryKey().getAlias();
        String name = rootDT ? dt.getName().toLowerCase() : parent.getName() + '.' + dt.getName().toLowerCase();
        for (String ext : tableGroupSet) {
            String currentPkField = ext.equalsIgnoreCase("l") ? "fpkid" : CollectEntityTableUtil.getDataEntityType(name).getPrimaryKey().getAlias();
            TableInfo extConfig = new TableInfo(name, dt.getAlias() + '_' + ext.toLowerCase(), currentPkField, pkField, pkField, currentTableInfo);
            set.add(extConfig);
        }
        if (!childList.isEmpty()) {
            set.addAll(childList);
        }
    }

    private static void collectEntityTables(IDataEntityProperty dp, Set<String> tableGroupSet, TableInfo currentTableInfo, Set<TableInfo> childList) {
        String tableGroup;
        String alias;
        if (dp instanceof ICollectionProperty) {
            if (dp instanceof DynamicLocaleProperty) {
                tableGroupSet.add("L");
            } else {
                IDataEntityType itemDT = ((ICollectionProperty)dp).getItemType();
                if (IEntryType.class.isAssignableFrom(itemDT.getClass()) && itemDT.getAlias() != null && itemDT.getAlias().trim().length() > 0 && !itemDT.isDbIgnore()) {
                    Class<?> cls = itemDT.getClass();
                    if (linkEntryType.isAssignableFrom(cls)) {
                        String pkField = itemDT.getParent().getPrimaryKey().getAlias();
                        String childrenName = currentTableInfo.getName() + '.' + itemDT.getName().toLowerCase();
                        TableInfo children = new TableInfo(childrenName, itemDT.getAlias(), CollectEntityTableUtil.getDataEntityType(childrenName).getPrimaryKey().getAlias(), pkField, pkField, currentTableInfo);
                        childList.add(children);
                    } else {
                        CollectEntityTableUtil.collectEntityTables(itemDT, false, currentTableInfo, childList);
                    }
                }
                if (mulBasedataPropType.isAssignableFrom(dp.getClass()) && itemDT.getAlias() != null && itemDT.getAlias().trim().length() > 0) {
                    CollectEntityTableUtil.collectEntityTables(itemDT, false, currentTableInfo, childList);
                }
            }
        } else if (!(dp instanceof IComplexProperty) && (alias = dp.getAlias()) != null && alias.length() > 0 && (tableGroup = dp.getTableGroup()) != null && tableGroup.length() > 0) {
            tableGroupSet.add(tableGroup.toUpperCase());
        }
    }

    static {
        try {
            linkEntryType = Class.forName("kd.bos.entity.LinkEntryType");
            mulBasedataPropType = Class.forName("kd.bos.entity.property.MulBasedataProp");
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{"kd.bos.orm.datasync.agent.CollectEntityTable linkEntryType error"});
        }
    }
}

