/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync.agent;

import java.util.Locale;
import kd.bos.db.DBRoute;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DestinationType;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.AgentEmptyImpl;
import kd.bos.orm.datasync.agent.DataSyncAgentImpl;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;

public interface DataSyncAgent {
    public static final DataSyncAgentImpl _instance = new DataSyncAgentImpl();
    public static final AgentEmptyImpl _emptyinstance = new AgentEmptyImpl();

    public static DataSyncAgent get() {
        if (DtsAccountPower.isAccountDtsEnable() && !DtsExcludeSyncContext.isExclude()) {
            return _instance;
        }
        return _emptyinstance;
    }

    public static boolean checkTable(String tableName) {
        return tableName != null && !tableName.toLowerCase(Locale.ENGLISH).startsWith("t_meta");
    }

    public static boolean checkEntity(String entityNumer) {
        if (entityNumer == null || DtsExcludeSyncContext.isExclude()) {
            return false;
        }
        if ("data_sync_config".equals(entityNumer)) {
            return true;
        }
        DestinationTransRule[] destinationRule = DataSyncConfigCache.get().getEntitySyncDestinationType(entityNumer);
        return destinationRule != null && destinationRule.length > 0;
    }

    public static boolean isQueryEnable(String entityNumber) {
        return DataSyncAgent.isQueryEnable(entityNumber, "quicksearch", DestinationType.FULLTEXT);
    }

    public static boolean isQueryEnable(String entityNumber, String businessType, DestinationType destinationType) {
        DestinationTransRule[] destinationRule;
        boolean paramEnable;
        boolean bl = paramEnable = DtsAccountPower.isAccountDtsEnable() && Boolean.parseBoolean(System.getProperty("dts.query.enable", "true"));
        if (paramEnable && (destinationRule = DataSyncConfigCache.get().getWorkingDestinationType(entityNumber)) != null && destinationRule.length > 0) {
            for (DestinationTransRule rule : destinationRule) {
                if (destinationType != rule.getType() || !businessType.equals(rule.getBusinessType())) continue;
                return true;
            }
        }
        return false;
    }

    public void send(DBRoute var1, OperationType var2, DataSyncValue var3);
}

