/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync.agent;

import java.util.HashMap;
import kd.bos.db.DBRoute;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.log.DtsStatusReporterFactory;
import kd.bos.dts.log.DtsStatusType;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DestinationType;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.DataSyncAgent;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import kd.bos.orm.datasync.agent.DataSyncInitConfigAgent;
import kd.bos.orm.datasync.send.MessageSender;

public class DataSyncAgentImpl
implements DataSyncAgent {
    @Override
    public void send(DBRoute dbRoute, OperationType operationType, DataSyncValue value) {
        if ("data_sync_config".equals(value.getEntityNumber())) {
            DataSyncInitConfigAgent.get().send(dbRoute, operationType, value);
            DtsStatusReporterFactory.get().confInitReport(operationType.getName(), DtsStatusType.CONFIG_CHANGED);
            return;
        }
        DestinationTransRule[] destinationRule = DataSyncConfigCache.get().getEntitySyncDestinationType(value.getEntityNumber());
        if (destinationRule == null || destinationRule.length == 0) {
            return;
        }
        for (DestinationTransRule rule : destinationRule) {
            if (operationType == OperationType.DDL && rule.getType() != DestinationType.BUSINESSDB) continue;
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("destination", rule);
            m.put("optype", operationType.getName());
            m.put("datasyncvalue", value);
            MessageSender.get().send("dts", "kd.bos.service.dts.sync_data_queue", m, dbRoute.getRouteKey());
            DestinationRuleConfig entityRuleConfig = DestinationRuleConfig.get((String)value.getEntityNumber(), (DestinationTransRule)rule);
            DtsStatusReporterFactory.get().realtimeReport(value.getGid(), entityRuleConfig, operationType.getName(), value.getCount(), DtsStatusType.DATA_SEND, 0L);
        }
    }
}

