/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync.agent;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datasync.ConfigureItemStatus;
import kd.bos.orm.datasync.DataSyncConfigItem;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DestinationType;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.orm.datasync.agent.BusinessTypeEnable;
import kd.bos.orm.datasync.agent.CollectEntityTableUtil;
import kd.bos.orm.datasync.agent.RelationTablesCache;
import kd.bos.orm.datasync.agent.SyncConfigVersion;
import kd.bos.orm.datasync.agent.TableInfo;
import kd.bos.orm.datasync.agent.UpgraderStatus;

public class DataSyncConfigCache {
    private static LocalMemoryCache cache;
    private static Log logger;
    private static Map<String, DataSyncConfigCache> instances;
    private static int hearttime;
    private SyncConfigVersion syncConfigVersion;
    private AtomicLong version = new AtomicLong(0L);
    private long lastUpdateTimes = 0L;
    private Map<String, List<DataSyncConfigItem>> dataSyncConfigMap = new ConcurrentHashMap<String, List<DataSyncConfigItem>>(16);
    private final String hasInitConfig;
    private String accountId;
    private Map<String, AtomicBoolean> configChangedStatus = new ConcurrentHashMap<String, AtomicBoolean>(8);

    private DataSyncConfigCache() {
        this.hasInitConfig = "hasInitConfig";
    }

    private DataSyncConfigCache(String accountId) {
        this.accountId = accountId;
        this.hasInitConfig = "hasInitConfig" + this.accountId;
        this.syncConfigVersion = new SyncConfigVersion();
        this.lastUpdateTimes = System.currentTimeMillis();
        this.version.set(this.syncConfigVersion.getLastVersion());
    }

    public static DataSyncConfigCache get() {
        String accountId = RequestContext.get().getAccountId();
        return instances.computeIfAbsent(accountId, v -> new DataSyncConfigCache((String)v));
    }

    public void initConfig() {
        this.initConfig(this.dataSyncConfigMap);
    }

    public void initConfig(final Map<String, List<DataSyncConfigItem>> dataSyncConfigMap) {
        String sql = "select fid,fentitynumber,fentityfields,fdestinationtype,fregion,fmappingrule,fstatus,ftables,fbusinesstype from t_dts_datasyncconfig where fenable='1'  and fstatus in ('prepare','working','suspend')";
        try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();){
            try (TXHandle h = TX.requiresNew();){
                DB.query((DBRoute)DBRoute.basedata, (String)"select fid,fentitynumber,fentityfields,fdestinationtype,fregion,fmappingrule,fstatus,ftables,fbusinesstype from t_dts_datasyncconfig where fenable='1'  and fstatus in ('prepare','working','suspend')", (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<Map<String, DataSyncConfigItem>>(){

                    public Map<String, DataSyncConfigItem> handle(ResultSet rs) throws Exception {
                        DataSyncConfigItem configItem = null;
                        try {
                            while (rs.next()) {
                                String bussinesstype = rs.getString("fbusinesstype");
                                if (!BusinessTypeEnable.instance.isBusinessTypeEnable(bussinesstype)) continue;
                                configItem = new DataSyncConfigItem();
                                DestinationTransRule rule = new DestinationTransRule();
                                configItem.setDestinationRule(rule);
                                configItem.setId(rs.getLong("fid"));
                                configItem.setEntityNumber(rs.getString("fentitynumber"));
                                configItem.setEntityfields(rs.getString("fentityfields"));
                                rule.setType(DestinationType.getType((String)rs.getString("fdestinationtype")));
                                rule.setRegion(this.getRegion(rs.getString("fregion")));
                                rule.setMappingrule(rs.getString("fmappingrule"));
                                rule.setBusinessType(bussinesstype);
                                configItem.setStatus(rs.getString("fstatus"));
                                String entityNumber = configItem.getEntityNumber();
                                ArrayList<DataSyncConfigItem> ls = (ArrayList<DataSyncConfigItem>)dataSyncConfigMap.get(entityNumber);
                                if (ls == null) {
                                    ls = new ArrayList<DataSyncConfigItem>(2);
                                    dataSyncConfigMap.put(entityNumber, ls);
                                    Set<String> tableNames = DataSyncConfigCache.this.getTableNamesByEntityNumber(entityNumber);
                                    for (String tableName : tableNames) {
                                        RelationTablesCache.get().putTableNameEntityNumber(tableName, entityNumber);
                                    }
                                }
                                ls.add(configItem);
                            }
                        }
                        catch (SQLException e) {
                            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                        }
                        return null;
                    }

                    private String getRegion(String region) {
                        if (region == null) {
                            return null;
                        }
                        String[] details = region.split(",");
                        ArrayList<String> detailSet = new ArrayList<String>();
                        for (String detail : details) {
                            if (detail.trim().length() <= 0) continue;
                            detailSet.add(detail.trim());
                        }
                        return detailSet.stream().collect(Collectors.joining(","));
                    }
                });
            }
            cache.put(this.hasInitConfig, (Object)this.hasInitConfig);
            this.configChangedStatus.computeIfAbsent(this.hasInitConfig, k -> new AtomicBoolean(false));
        }
        catch (Exception e) {
            String msg = String.format("dtserror:%s;  sql:%s", e.getMessage(), "select fid,fentitynumber,fentityfields,fdestinationtype,fregion,fmappingrule,fstatus,ftables,fbusinesstype from t_dts_datasyncconfig where fenable='1'  and fstatus in ('prepare','working','suspend')");
            logger.error(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataSyncConfigItem> getConfig(String entityNumber) {
        long currentTimes = System.currentTimeMillis();
        if (currentTimes - this.lastUpdateTimes > (long)hearttime) {
            this.lastUpdateTimes = currentTimes;
            long lastVersion = -1L;
            lastVersion = this.syncConfigVersion.getLastVersion();
            if (this.version.get() != lastVersion) {
                this.doRemoveCache();
                this.version.set(lastVersion);
            }
        }
        if (!cache.contains(this.hasInitConfig)) {
            AtomicBoolean isGettingConfig = this.configChangedStatus.get(this.hasInitConfig);
            if (isGettingConfig != null) {
                if (isGettingConfig.compareAndSet(false, true)) {
                    try {
                        ConcurrentHashMap<String, List<DataSyncConfigItem>> _dataSyncConfigMap = new ConcurrentHashMap<String, List<DataSyncConfigItem>>(16);
                        this.initConfig(_dataSyncConfigMap);
                        this.dataSyncConfigMap = _dataSyncConfigMap;
                    }
                    finally {
                        isGettingConfig.set(false);
                    }
                }
            } else {
                DataSyncConfigCache dataSyncConfigCache = this;
                synchronized (dataSyncConfigCache) {
                    if (cache.contains(this.hasInitConfig)) {
                        return this.dataSyncConfigMap.get(entityNumber);
                    }
                    if (UpgraderStatus.status.isUpgradering()) {
                        cache.put(this.hasInitConfig, (Object)this.hasInitConfig);
                    } else {
                        this.dataSyncConfigMap.clear();
                        this.initConfig();
                    }
                }
            }
        }
        return this.dataSyncConfigMap.get(entityNumber);
    }

    public void removeCache() {
        this.doRemoveCache();
        this.incVersion();
    }

    public void removeCache(String entityNumber) {
        this.doRemoveCache();
        this.incVersion();
    }

    private void doRemoveCache() {
        cache.remove(new String[]{this.hasInitConfig});
    }

    private void incVersion() {
        this.version.incrementAndGet();
        this.syncConfigVersion.incVersion();
    }

    public DestinationTransRule[] getEntitySyncDestinationType(String entityNumber) {
        return this.getDestinationType(entityNumber, false);
    }

    public DestinationTransRule[] getWorkingDestinationType(String entityNumber) {
        return this.getDestinationType(entityNumber, true);
    }

    private DestinationTransRule[] getDestinationType(String entityNumber, boolean isOnlyWorking) {
        List<DataSyncConfigItem> items = this.getConfig(entityNumber);
        ArrayList dtype = new ArrayList();
        if (items != null && items.size() > 0) {
            items.forEach(v -> {
                DestinationTransRule rule = v.getDestinationRule();
                if (isOnlyWorking) {
                    if (ConfigureItemStatus.working == v.getStatus()) {
                        dtype.add(rule);
                    }
                } else {
                    dtype.add(rule);
                }
            });
        }
        return dtype.toArray(new DestinationTransRule[0]);
    }

    public DestinationTransRule[] getTransRuleByTableName(String tableName) {
        String entityNumber = this.getEntityNumberByTableName(tableName);
        if (entityNumber == null) {
            return null;
        }
        return this.getEntitySyncDestinationType(entityNumber);
    }

    public boolean isContainBDSyncRule(String tableName) {
        DestinationTransRule[] rules = this.getTransRuleByTableName(tableName);
        if (rules != null) {
            for (DestinationTransRule rule : rules) {
                if (rule.getType() != DestinationType.BUSINESSDB) continue;
                return true;
            }
        }
        return false;
    }

    public String getEntityNumberByTableName(String tableName) {
        if (tableName == null) {
            return null;
        }
        if (!cache.contains(this.hasInitConfig)) {
            this.getConfig(tableName);
        }
        return RelationTablesCache.get().getEntityNumberByTableName(tableName.toLowerCase());
    }

    public String getFieldsByEntityName(String entityName) {
        if (entityName == null || "".equals(entityName)) {
            return null;
        }
        List<DataSyncConfigItem> dataSyncConfigItems = this.getConfig(entityName.toLowerCase());
        if (dataSyncConfigItems != null && !dataSyncConfigItems.isEmpty()) {
            for (DataSyncConfigItem dataSyncConfigItem : dataSyncConfigItems) {
                if (DestinationType.FULLTEXT != dataSyncConfigItem.getDestinationRule().getType()) continue;
                return dataSyncConfigItem.getEntityfields();
            }
        }
        return null;
    }

    public String getFieldsByEntityName(String entityName, String region) {
        if (entityName == null || "".equals(entityName)) {
            return null;
        }
        List<DataSyncConfigItem> dataSyncConfigItems = this.getConfig(entityName.toLowerCase());
        if (dataSyncConfigItems != null && !dataSyncConfigItems.isEmpty()) {
            for (DataSyncConfigItem dataSyncConfigItem : dataSyncConfigItems) {
                if (DestinationType.FULLTEXT != dataSyncConfigItem.getDestinationRule().getType() || !region.equalsIgnoreCase(dataSyncConfigItem.getDestinationRule().getRegion())) continue;
                return dataSyncConfigItem.getEntityfields();
            }
        }
        return null;
    }

    public Set<String> getTableNamesByEntityNumber(String entityNumber) {
        return RelationTablesCache.get().getTableNamesByEntityNumber(entityNumber);
    }

    public Set<TableInfo> getEntityTableInfos(String entityNumber) {
        return RelationTablesCache.get().getEntityTableInfos(entityNumber);
    }

    public Set<TableInfo> getDefaultTableInfosForPlugin(String entityNumber) {
        return CollectEntityTableUtil.collectEntityTables(entityNumber);
    }

    public String getRelationField(String entityNumber, String tableName) {
        for (TableInfo info : this.getEntityTableInfos(entityNumber)) {
            if (!info.getTableName().equalsIgnoreCase(tableName)) continue;
            return info.getRelationField();
        }
        for (TableInfo info : this.getRelationTableInfos(entityNumber)) {
            if (!info.getTableName().equalsIgnoreCase(tableName)) continue;
            return info.getRelationField();
        }
        return null;
    }

    public String getPrimaryField(String entityNumber, String tableName) {
        for (TableInfo info : this.getEntityTableInfos(entityNumber)) {
            if (!info.getTableName().equalsIgnoreCase(tableName)) continue;
            return info.getPrimaryKey();
        }
        for (TableInfo info : this.getRelationTableInfos(entityNumber)) {
            if (!info.getTableName().equalsIgnoreCase(tableName)) continue;
            return info.getPrimaryKey();
        }
        return null;
    }

    public Set<TableInfo> getRelationTableInfos(String entityNumber) {
        return RelationTablesCache.get().getRelationTableInfos(entityNumber);
    }

    public boolean isRelationtable(String tableName) {
        String entityNumber = this.getEntityNumberByTableName(tableName);
        if (entityNumber != null) {
            Set<TableInfo> tableInfos = this.getRelationTableInfos(entityNumber);
            for (TableInfo info : tableInfos) {
                if (!info.getTableName().equalsIgnoreCase(tableName)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        logger = LogFactory.getLog(DataSyncConfigCache.class);
        instances = new ConcurrentHashMap<String, DataSyncConfigCache>(2);
        hearttime = 120000;
        try {
            CacheConfigInfo cc = new CacheConfigInfo();
            cc.setMaxItemSize(5000);
            cc.setTimeout(300);
            cc.setTimeToLive(true);
            cache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("bos", "dts", cc);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }
}

