/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync.agent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.db.DBRoute;
import kd.bos.orm.datasync.ColumnInfo;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import kd.bos.orm.datasync.send.MessageSender;

public class DataSyncInitConfigAgent {
    private static DataSyncInitConfigAgent instance = new DataSyncInitConfigAgent();

    public static DataSyncInitConfigAgent get() {
        return instance;
    }

    public void send(DBRoute dbRoute, OperationType operationType, List<Object> pkls, DbMetadataColumn[] columns, List<Object[]> rows) {
        ArrayList<ColumnInfo> columnsLs = new ArrayList<ColumnInfo>(columns.length);
        for (DbMetadataColumn column : columns) {
            ColumnInfo ci = new ColumnInfo();
            ci.setFiledName(column.getName());
            ci.setDbtype(column.getDbType());
            ci.setColumnIndex(column.getColumnIndex());
            columnsLs.add(ci);
        }
        HashMap<String, Object> m = new HashMap<String, Object>(4);
        m.put("optype", operationType.getName());
        m.put("ids", pkls);
        m.put("fields", columnsLs);
        m.put("data", rows);
        MessageSender.get().send("dts", "kd.bos.service.dts.init_config_queue", m, dbRoute.getRouteKey());
        DataSyncConfigCache.get().removeCache();
    }

    public void send(DBRoute dbRoute, OperationType operationType, DataSyncValue value) {
        HashMap<String, Object> m = new HashMap<String, Object>(2);
        m.put("optype", operationType.getName());
        m.put("datasyncvalue", value);
        MessageSender.get().send("dts", "kd.bos.service.dts.init_config_queue", m, dbRoute.getRouteKey());
    }
}

