/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync.agent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.hint.NoShardingHint;

public class UpgraderColumnParenttable {
    private static final Log log = LogFactory.getLog(UpgraderColumnParenttable.class);
    private static final Map<String, DtsUpgradedCache> upgradMap = new ConcurrentHashMap<String, DtsUpgradedCache>();

    private static boolean existColName(String tableName, String colName) {
        String sql = NoShardingHint.genNoShardingSQL((String)("SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME='" + tableName + "' AND KSQL_COL_NAME ='" + colName + "'"));
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, rs -> {
            if (rs.next()) {
                return true;
            }
            return false;
        });
    }

    public static boolean isUpgraded() {
        String accountId = RequestContextInfo.get().getAccountId();
        return upgradMap.computeIfAbsent(accountId, key -> new DtsUpgradedCache()).isUpgraded();
    }

    public static void clean() {
        String accountId = RequestContextInfo.get().getAccountId();
        upgradMap.remove(accountId);
    }

    static class DtsUpgradedCache {
        private boolean loaded = false;
        private boolean upgraded = false;

        DtsUpgradedCache() {
        }

        public boolean isUpgraded() {
            if (!this.loaded) {
                this.upgraded = UpgraderColumnParenttable.existColName("t_dts_table_config_entry", "fparenttable");
                this.loaded = true;
            }
            return this.upgraded;
        }
    }
}

