/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync.query;

import kd.bos.fulltext.FullTextQuery;
import kd.bos.fulltext.impl.FullTextQueryImpl;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DestinationType;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;

public class DtsQueryFactory {
    private static final String DESTINATION_DEFAULT_REGION = "quicksearch";

    public static FullTextQuery getFullTextQuery(String entityNumber) {
        DestinationTransRule[] destinationRule = DataSyncConfigCache.get().getWorkingDestinationType(entityNumber);
        if (destinationRule != null && destinationRule.length > 0) {
            for (DestinationTransRule rule : destinationRule) {
                if (DestinationType.FULLTEXT != rule.getType() || !DESTINATION_DEFAULT_REGION.equals(rule.getBusinessType())) continue;
                String region = rule.getRegion();
                if (region == null || region.length() == 0) {
                    region = DESTINATION_DEFAULT_REGION;
                }
                String r = region;
                return new FullTextQueryImpl(r);
            }
        }
        return null;
    }
}

