/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.action.tx.impl;

import kd.bos.context.KdtxRequestContext;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.entity.TxInfo;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.exception.TxBeginException;
import kd.bos.kdtx.common.util.AssertUtils;
import kd.bos.kdtx.server.action.tx.TxAction;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.dao.BranchDao;
import kd.bos.kdtx.server.state.impl.NotFoundState;
import kd.bos.kdtx.server.xid.XIDGenerator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class BeginTxAction
implements TxAction {
    private static final Log LOG = LogFactory.getLog(BeginTxAction.class);

    @Override
    public void handle(Object ... paras) throws Exception {
        this.txNestCheck();
        NotFoundState notFoundState = new NotFoundState();
        String xid = XIDGenerator.getXIDGenerator().generate();
        if (StringUtils.isEmpty((String)xid)) {
            throw new KdtxException(DtxErrorCodeConstants.XID_EMPTY);
        }
        TcContext.getOrCreate().setXid(xid);
        notFoundState.saveTx();
        int dtxType = Integer.parseInt(TcContext.get().getTxType());
        KdtxRequestContext.get().setXid(xid);
        KdtxRequestContext.get().setDtxType(dtxType);
        KdtxRequestContext.get().pushXidStack(xid);
    }

    private void txNestCheck() {
        if (KdtxRequestContext.get().getBranchId() != null) {
            int nextNestSize = this.getNestTxSize() + 1;
            AssertUtils.assertTrueAndLog((nextNestSize <= TransCoordinatorConfig.getTransactionLevel() ? 1 : 0) != 0, (String)("KdtxMonitorLog nest level is too much,support " + TransCoordinatorConfig.getTransactionLevel() + " level but found " + nextNestSize), (RuntimeException)new TxBeginException(DtxErrorCodeConstants.DTX_NEST_LEVEL_TOO_MUCH));
            int curTxType = Integer.parseInt(TcContext.get().getTxType());
            TxInfo parentTxInfo = BranchDao.getTxInfoByBranchId(KdtxRequestContext.get().getBranchId());
            AssertUtils.assertTrueAndLog((parentTxInfo != null ? 1 : 0) != 0, (String)("KdtxMonitorLog can't find tx by parent branch id " + KdtxRequestContext.get().getBranchId()), (RuntimeException)new TxBeginException(DtxErrorCodeConstants.BRANCH_ID_NOT_MATCH_TRANSACTION));
            TcContext.getOrCreate().setParentXid(parentTxInfo.getFxid());
            int parentTxType = parentTxInfo.getFtxType();
            AssertUtils.assertTrueAndLog((curTxType != DtxType.TCC.getCode() && parentTxType != DtxType.TCC.getCode() ? 1 : 0) != 0, (String)("KdtxMonitorLog nesting is not supported,parent branch_id=" + KdtxRequestContext.get().getBranchId()), (RuntimeException)new TxBeginException(DtxErrorCodeConstants.NOT_SUPPORT_NEST_TCC));
        }
    }
}

