/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.action.tx.impl;

import kd.bos.context.KdtxRequestContext;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.constant.LocalTxLogStatus;
import kd.bos.kdtx.common.exception.TxCommitFailException;
import kd.bos.kdtx.server.action.tx.TxAction;
import kd.bos.kdtx.server.async.ActionAsyncServiceImpl;
import kd.bos.kdtx.server.async.AsyncServiceImpl;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.service.impl.TxCommonService;
import kd.bos.kdtx.server.state.TcState;
import kd.bos.kdtx.server.state.impl.CommitFailedState;
import kd.bos.kdtx.server.state.impl.CommittingState;
import kd.bos.kdtx.server.state.impl.PreparingState;
import kd.bos.kdtx.server.tasks.homeless.CompensateStrategyScheduler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class CommitTxAction
implements TxAction {
    private static final Log LOG = LogFactory.getLog(CommitTxAction.class);
    private static final CompensateStrategyScheduler compensateStrategyScheduler = new CompensateStrategyScheduler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Object ... paras) throws Exception {
        block13: {
            TcState tcState = null;
            try {
                tcState = this.getStateObject();
                if ((!(tcState instanceof PreparingState) || TcContext.get().isRetry()) && (!(tcState instanceof CommitFailedState) && !(tcState instanceof CommittingState) && !(tcState instanceof PreparingState) || !TcContext.get().isRetry())) break block13;
                boolean updated = tcState.updateTx(GlobalTxStatus.COMMITTING, null);
                if (!updated && !(tcState instanceof CommittingState)) {
                    return;
                }
                if (TcContext.get().isRunMqModel()) {
                    return;
                }
                if (TcContext.get().isAsyncCommit() && this.getNestTxSize() == 1) {
                    String curDealXid = KdtxRequestContext.get().getXid();
                    try {
                        if (TransCoordinatorConfig.isStandardThreadPool()) {
                            LOG.info("This KDTX committing is using the Java Standard ThreadPool.");
                            AsyncServiceImpl.executeAction(() -> this.commit());
                        } else {
                            ActionAsyncServiceImpl.asyncExecuteAfterlCopyContext(() -> this.commit());
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        LOG.error("execute Async Service ERROR.", (Throwable)e);
                        break block13;
                    }
                    finally {
                        KdtxRequestContext.popDealedTx((String)curDealXid);
                    }
                }
                this.commit();
            }
            catch (Exception e) {
                if (tcState != null) {
                    tcState.updateTx(GlobalTxStatus.COMMIT_FAILED, null);
                }
                LOG.error("KdtxMonitorLog tx commit err -- xid: " + this.getXid(), (Throwable)e);
                throw new TxCommitFailException((Throwable)e);
            }
        }
    }

    private void commit() throws Exception {
        TcState tcState = null;
        String curDealXid = KdtxRequestContext.get().getXid();
        try {
            tcState = this.getStateObject();
            tcState.commit(null);
            tcState.deleteBusinessInfo();
            TxCommonService.callback(TcContext.get().getXid(), true, false);
            compensateStrategyScheduler.autoCompensateComplete(TcContext.get().getXid());
            tcState.updateTx(GlobalTxStatus.COMMITTED, LocalTxLogStatus.PUBLISHED);
        }
        catch (Exception e) {
            if (tcState != null) {
                tcState.updateTx(GlobalTxStatus.COMMIT_FAILED, null);
            }
            LOG.error("KdtxMonitorLog tx commit err -- xid: " + this.getXid(), (Throwable)e);
            throw e;
        }
        finally {
            KdtxRequestContext.popDealedTx((String)curDealXid);
        }
    }

    private String getXid() {
        TcContext tcContext = TcContext.get();
        String xid = tcContext != null && StringUtils.isNotEmpty((String)TcContext.get().getXid()) ? TcContext.get().getXid() : KdtxRequestContext.get().getXid();
        return xid;
    }
}

