/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.async;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.server.async.ActionRunnable;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;

public class ActionAsyncServiceImpl {
    public static final String ACTION_THREAD_POOL_NAME = "kdtx-action-pool";
    private static final Log LOG = LogFactory.getLog(ActionAsyncServiceImpl.class);
    private static ExecutorService executorService = ThreadPools.newCachedExecutorService((String)"kdtx-action-pool", (int)TransCoordinatorConfig.getThreadCoreNum(), (int)TransCoordinatorConfig.getThreadMaxNum());

    public static void asyncExecute(final AsyncHandler asyncHandler) {
        executorService.execute(new ActionRunnable(TcContext.get(), KdtxRequestContext.get(), RequestContext.get().getTraceId()){

            @Override
            protected void execute() {
                try {
                    asyncHandler.handle();
                }
                catch (Exception e) {
                    ExceptionLogger.error(ActionAsyncServiceImpl.class, (String)"KdtxMonitorLog start async execute {} fail {}", (Object[])new Object[]{TcContext.get().getActionType().getName(), e.getMessage()});
                }
            }
        });
    }

    public static void asyncExecuteAfterlCopyContext(final AsyncHandler asyncHandler) {
        CountDownLatch latch = new CountDownLatch(1);
        executorService.execute(new ActionRunnable(TcContext.get(), KdtxRequestContext.get(), RequestContext.get().getTraceId(), latch){

            @Override
            protected void execute() {
                try {
                    asyncHandler.handle();
                }
                catch (Exception e) {
                    ExceptionLogger.error(ActionAsyncServiceImpl.class, (String)"KdtxMonitorLog start async execute {} fail {}", (Object[])new Object[]{TcContext.get().getActionType().getName(), e.getMessage()});
                }
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error("KdtxMonitorLog asyncExecuteUtilCopyContext error:", (Throwable)e);
        }
    }

    public static interface AsyncHandler {
        public void handle() throws Exception;
    }
}

