/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.async;

import java.util.concurrent.CountDownLatch;
import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.util.StringUtils;

public abstract class ActionRunnable
implements Runnable {
    private TcContext tcContext;
    private KdtxRequestContext krc;
    private String traceId;
    private CountDownLatch latch;

    public ActionRunnable(TcContext tcContext, KdtxRequestContext krc, String traceId) {
        this.tcContext = tcContext;
        this.krc = krc;
        this.traceId = traceId;
    }

    public ActionRunnable(TcContext tcContext, KdtxRequestContext krc, String traceId, CountDownLatch latch) {
        this.tcContext = tcContext;
        this.krc = krc;
        this.traceId = traceId;
        this.latch = latch;
    }

    @Override
    public void run() {
        try {
            TcContext.copyAndSet(this.tcContext);
            KdtxRequestContext.copyAndSet((KdtxRequestContext)this.krc);
            if (StringUtils.isNotEmpty((String)this.traceId)) {
                RequestContext.get().setTraceId(this.traceId);
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
            this.execute();
        }
        finally {
            TcContext.remove();
        }
    }

    protected abstract void execute();
}

