/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.async;

import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.util.StringUtils;

public abstract class AsyncRunnable
implements Runnable {
    private TcContext tcContext;
    private KdtxRequestContext krc;
    private String traceId;

    public AsyncRunnable(TcContext tcContext, KdtxRequestContext krc, String traceId) {
        this.tcContext = TcContext.copy(tcContext);
        this.krc = KdtxRequestContext.copy((KdtxRequestContext)krc);
        if (StringUtils.isNotEmpty((String)traceId)) {
            this.traceId = traceId;
        }
    }

    @Override
    public void run() {
        try {
            TcContext.set(this.tcContext);
            KdtxRequestContext.set((KdtxRequestContext)this.krc);
            if (StringUtils.isNotEmpty((String)this.traceId)) {
                RequestContext.get().setTraceId(this.traceId);
            }
            this.execute();
        }
        finally {
            TcContext.remove();
        }
    }

    protected abstract void execute();
}

