/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.factory;

import java.util.HashMap;
import java.util.Map;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.server.action.branch.BranchAction;
import kd.bos.kdtx.server.action.branch.impl.BranchCommitAction;
import kd.bos.kdtx.server.action.branch.impl.BranchRegisterAction;
import kd.bos.kdtx.server.action.branch.impl.BranchReportAction;
import kd.bos.kdtx.server.action.tx.TxAction;
import kd.bos.kdtx.server.action.tx.impl.BeginTxAction;
import kd.bos.kdtx.server.action.tx.impl.CommitTxAction;
import kd.bos.kdtx.server.action.tx.impl.RollbackTxAction;
import kd.bos.kdtx.server.action.tx.impl.SetBusinessInfoAction;

public class ActionFactory {
    private static Map<String, TxAction> txActionMap = new HashMap<String, TxAction>();
    private static Map<String, BranchAction> BranchActionMap = new HashMap<String, BranchAction>();

    public static TxAction getTxActionInstance(ActionType type) {
        if (type == null) {
            throw new KdtxException("action type can not be null");
        }
        return txActionMap.get(type.getName());
    }

    public static BranchAction getBranchActionInstance(ActionType type) {
        if (type == null) {
            throw new KdtxException("action type can not be null");
        }
        return BranchActionMap.get(type.getName());
    }

    static {
        txActionMap.put(ActionType.TX_BEGIN.getName(), new BeginTxAction());
        txActionMap.put(ActionType.SET_BUSINESS_INFO.getName(), new SetBusinessInfoAction());
        txActionMap.put(ActionType.TX_COMMIT.getName(), new CommitTxAction());
        txActionMap.put(ActionType.TX_ROLLBACK.getName(), new RollbackTxAction());
        BranchActionMap.put(ActionType.BRANCH_REGISTER.getName(), new BranchRegisterAction());
        BranchActionMap.put(ActionType.BRANCH_REPORT.getName(), new BranchReportAction());
        BranchActionMap.put(ActionType.BRANCH_COMMIT.getName(), new BranchCommitAction());
        BranchActionMap.put(ActionType.CASCADE_BRANCH_REGISTER.getName(), new BranchRegisterAction());
        BranchActionMap.put(ActionType.CASCADE_BRANCH_COMMIT.getName(), new BranchCommitAction());
    }
}

