/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.monitor.alarm;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.kdtx.server.monitor.alarm.AlarmActionService;
import kd.bos.kdtx.server.monitor.alarm.impl.EmailActionServiceImpl;
import kd.bos.kdtx.server.monitor.alarm.impl.SmsActionServiceImpl;

public class AlarmActionServiceFactory {
    private static AlarmActionService instance;
    private static String alarmType;
    private static final String ALARM_TYPE = "tcc.alarm.actiontype";

    public static AlarmActionService getAlarmService() {
        String type = System.getProperty(ALARM_TYPE, "sms");
        if (!alarmType.equals(type)) {
            AlarmActionServiceFactory.init();
        }
        return instance;
    }

    private static void init() {
        String type = System.getProperty(ALARM_TYPE, "sms");
        String className = AlarmActionServiceFactory.getClassName(type);
        try {
            AlarmActionService alarmActionService = (AlarmActionService)Class.forName(className).newInstance();
            alarmType = type;
            instance = alarmActionService;
        }
        catch (Exception var3) {
            throw new KDException(BosErrorCode.bOSNotImplemented, className, (Throwable)var3);
        }
    }

    private static String getClassName(String alarmType) {
        String className;
        switch (alarmType) {
            case "sms": {
                className = SmsActionServiceImpl.class.getName();
                break;
            }
            case "email": {
                className = EmailActionServiceImpl.class.getName();
                break;
            }
            default: {
                className = SmsActionServiceImpl.class.getName();
            }
        }
        return className;
    }

    static {
        AlarmActionServiceFactory.init();
    }
}

