/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.mq;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kd.bos.kdtx.common.invoke.DtxResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;

public class CallbackConsumer
implements MessageConsumer {
    private static final String METHOD_NAME = "callback";
    private Log logger = LogFactory.getLog(CallbackConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        DtxResult result = (DtxResult)body;
        String callbackClassName = result.getCallbackClassName();
        String xid = result.getXid();
        try {
            if (result.isInnerClass()) {
                this.innerInvoke(callbackClassName, result);
            } else {
                CallbackConsumer.normalInvoke(callbackClassName, result);
            }
        }
        catch (InvocationTargetException e) {
            this.logger.error("transaction [{}] callback error", (Object)xid, (Object)e.getTargetException());
        }
        catch (Exception e) {
            this.logger.error("transaction [{}] callback error", (Object)xid, (Object)e);
        }
        finally {
            acker.ack(messageId);
        }
    }

    private void innerInvoke(String className, DtxResult result) throws Exception {
        String outClassName = className.substring(0, className.indexOf("$"));
        Class<?> outClass = Class.forName(outClassName);
        Object outObj = outClass.newInstance();
        Class<?> innerClass = Class.forName(className);
        Constructor<?> innerConstructor = innerClass.getDeclaredConstructors()[0];
        innerConstructor.setAccessible(true);
        Object innerObj = innerConstructor.newInstance(outObj);
        Method innerInvokeMethod = innerClass.getMethod(METHOD_NAME, DtxResult.class);
        innerInvokeMethod.setAccessible(true);
        innerInvokeMethod.invoke(innerObj, result);
    }

    private static void normalInvoke(String className, DtxResult result) throws Exception {
        Class<?> clazz = Class.forName(className);
        Object obj = clazz.newInstance();
        clazz.getDeclaredMethod(METHOD_NAME, DtxResult.class).invoke(obj, result);
    }
}

