/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.mq;

import java.util.Set;
import kd.bos.kdtx.common.config.DtxConfig;
import kd.bos.kdtx.common.mq.PublishManager;
import kd.bos.kdtx.server.mq.BranchConsumer;
import kd.bos.kdtx.server.mq.CallbackConsumer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.partition.MQConfig;

public class ConsumerRegistryService
implements MQConfig {
    private static final Log logger = LogFactory.getLog(ConsumerRegistryService.class);

    public String generateConfig() {
        StringBuilder builder = new StringBuilder("<root><region name=\"kdtx\">");
        builder.append("<queue name=\"kdtxDefaultQueue\" appid=\"bos\" >");
        builder.append("<consumer class=\"").append(BranchConsumer.class.getName()).append("\"  concurrency=\"").append(DtxConfig.getBranchConsumerConcurrency()).append("\"></consumer>");
        builder.append("</queue>");
        Set scenesLoadBalance = PublishManager.getloadBalanceScenes();
        for (String scene : scenesLoadBalance) {
            String queueName = PublishManager.getBalanceQueueName((String)scene);
            builder.append("<queue name=\"").append(queueName).append("\" appid=\"").append("bos").append("\" >");
            builder.append("<consumer class=\"").append(BranchConsumer.class.getName()).append("\"  concurrency=\"").append(DtxConfig.getBranchConsumerConcurrency()).append("\"></consumer>");
            builder.append("</queue>");
        }
        this.appendCallbackQueue(builder);
        builder.append("</region></root>");
        String mqConfig = builder.toString();
        logger.info("inject kdtx mqconfig :" + mqConfig);
        return mqConfig;
    }

    private void appendCallbackQueue(StringBuilder builder) {
        String notExistAppId = "abcddcbakdtx";
        builder.append("<queue name=\"").append("callback").append("\" appid=\"").append(notExistAppId).append("\" >");
        builder.append("<consumer class=\"").append(CallbackConsumer.class.getName()).append("\"  concurrency=\"").append(1).append("\"></consumer>");
        builder.append("</queue>");
    }
}

