/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.service;

import java.util.Arrays;
import kd.bos.framework.lifecycle.Service;
import kd.bos.instance.Instance;
import kd.bos.kdtx.common.config.DtxConfig;
import kd.bos.kdtx.common.config.MServiceRegisterConfig;
import kd.bos.kdtx.common.constant.AppInfo;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.service.DtxBranchDispatchService;
import kd.bos.kdtx.common.service.DtxTxDispatchService;
import kd.bos.kdtx.common.util.AppUtils;
import kd.bos.kdtx.server.service.impl.TxDispatchServiceImpl;
import kd.bos.service.register.ServiceRegister;

public class TCRegisterService
implements Service {
    public TCRegisterService() {
        if (AppUtils.isTCCServer() && Instance.isAppSplit() && Instance.getAppIds().length > 0 && !Arrays.asList(Instance.getAppIds()).contains(AppInfo.APP_ID.getName())) {
            Instance.addAppIds((String)AppInfo.APP_ID.getName());
        }
    }

    public String getName() {
        return TCRegisterService.class.getSimpleName();
    }

    public void start() {
        ExceptionLogger.info(TCRegisterService.class, (String)"dtx server register start.");
        if (AppUtils.isTCCServer()) {
            ExceptionLogger.info(TCRegisterService.class, (String)"this node is a dtx server.");
            this.registerRpc();
            ExceptionLogger.info(TCRegisterService.class, (String)"dtx server register finish.");
        }
        ExceptionLogger.info(TCRegisterService.class, (String)"dtx server register end.");
    }

    public void stop() {
    }

    public boolean isStarted() {
        return false;
    }

    private void registerRpc() {
        this.registerTCCTxService();
    }

    private void registerTCCBranchConsumer() {
        MServiceRegisterConfig mServiceRegisterConfig = MServiceRegisterConfig.getTCCBranchDispatchServiceConsumerConfig();
        ServiceRegister.registerConsumer((String)DtxBranchDispatchService.class.getSimpleName(), (String)mServiceRegisterConfig.toString());
    }

    private void registerTCCTxService() {
        MServiceRegisterConfig mServiceRegisterConfig = MServiceRegisterConfig.getMServiceServiceConfig((String)DtxTxDispatchService.class.getName(), (String)TxDispatchServiceImpl.class.getName());
        mServiceRegisterConfig.setServiceTimeout(Integer.toString(DtxConfig.getTxDispatchServiceTimeout()));
        mServiceRegisterConfig.setServiceRetries(Integer.toString(DtxConfig.getTxDispatchServiceRetries()));
        mServiceRegisterConfig.setAppId(AppInfo.APP_ID.getName());
        ServiceRegister.registerService((String)DtxTxDispatchService.class.getSimpleName(), (String)mServiceRegisterConfig.toString());
    }
}

